/*
 * Decompiled with CFR 0.152.
 */
package com.webbuilder.controls;

import com.webbuilder.controls.ExtControl;
import com.webbuilder.utils.StringUtil;
import com.webbuilder.utils.WebUtil;

public class MenuItem
extends ExtControl {
    private String[] key = new String[]{"type", "text", "toolType", "select", "popup", "module", "hidden", "ignoreParentClicks", "minWidth", "plain", "showSeparator"};
    private String text;
    private boolean hasText = true;

    @Override
    public void create() throws Exception {
        String xtype = "";
        String type = this.gs("type");
        String menuType = "menu";
        this.text = this.gs("text");
        if (StringUtil.isEqual(this.text, "-")) {
            xtype = StringUtil.isEqual(this.parentControl.optString("xwlMeta"), "menuItem") ? "menuseparator" : "tbseparator";
            this.hasText = false;
        } else if (StringUtil.isEqual(this.text, " ")) {
            xtype = "tbspacer";
            this.hasText = false;
        } else if (StringUtil.isEqual(this.text, "->")) {
            xtype = "tbfill";
            this.hasText = false;
        } else if (StringUtil.isEqual(type, "textItem")) {
            xtype = "tbtext";
        } else if (StringUtil.isEqual(type, "split")) {
            xtype = "splitbutton";
        } else if (StringUtil.isEqual(type, "colorPicker")) {
            menuType = "colormenu";
        } else if (StringUtil.isEqual(type, "datePicker")) {
            menuType = "datemenu";
        }
        if (!StringUtil.isEmpty(xtype)) {
            xtype = StringUtil.concat("xtype:\"", xtype, "\"");
        }
        this.headerScript(StringUtil.concat(this.getComma(), "{", this.getJson(xtype)));
        this.footerScript("}");
        if (this.hasChild || !StringUtil.isEqual(menuType, "menu")) {
            String p = this.gs("popup");
            String z = this.gs("select");
            p = !StringUtil.isEmpty(p) ? StringUtil.concat(",listeners:{show:function(menu,options){\n", p, "\n}}") : "";
            z = !StringUtil.isEmpty(z) ? StringUtil.concat(",handler:function(menu,value,options){\n", z, "\n}") : "";
            this.headerScriptNL(StringUtil.concat(",menu:{xtype:\"", menuType, "\"", this.getMenuExpress(), p, z));
            if (this.hasChild) {
                this.headerScriptNL(",items:[");
                this.footerScript("]}");
            } else {
                this.footerScript("}");
            }
        }
    }

    @Override
    protected String getTagProperties() throws Exception {
        String module = this.gs("module");
        String hidden = this.gs("hidden");
        if (!module.isEmpty() && !WebUtil.checkRight(this.request, WebUtil.getUrl(module, true))) {
            hidden = "true";
        }
        this.addExpress("hidden", hidden);
        if (!this.hasText) {
            return this.getPBuffer();
        }
        this.addText("text", this.text);
        this.addText("type", this.gs("toolType"));
        return this.getPBuffer();
    }

    @Override
    protected String[] getReservedKeys() throws Exception {
        return this.key;
    }

    private String getMenuExpress() throws Exception {
        String s;
        int j = this.key.length;
        this.resetPBuffer();
        int i = 7;
        while (i < j) {
            s = this.key[i];
            this.addExpress(s, this.gs(s));
            ++i;
        }
        s = this.getPBuffer();
        if (StringUtil.isEmpty(s)) {
            return "";
        }
        return "," + s;
    }
}

