/*
 * Decompiled with CFR 0.152.
 */
package com.webbuilder.controls;

import com.webbuilder.controls.ExtControl;
import com.webbuilder.utils.StringUtil;

public class ExtField
extends ExtControl {
    private String[] key = new String[]{"color", "bgColor", "bgImage", "fieldStyle", "height", "autoCreate", "inputType"};
    private boolean isFile;
    private String inputType;

    @Override
    public void create() throws Exception {
        boolean autoCreate = this.gb("autoCreate", true);
        this.inputType = this.gs("inputType");
        this.isFile = StringUtil.isEqual(this.inputType, "file");
        String id = this.gs("id");
        if (this.hasParent || !autoCreate) {
            String xtype = this.isFile ? "filefield" : this.getMeta("xwlXtype");
            xtype = StringUtil.isEmpty(xtype) ? "" : StringUtil.concat("xtype:\"", xtype, "\"");
            if (this.hasParent) {
                this.headerScript(StringUtil.concat(this.getComma(), "{", this.getJson(xtype)));
            } else {
                this.headerScript(StringUtil.concat("Wd.", id, "={", this.getJson(xtype)));
            }
            this.footerScript("}");
            if (this.hasChild) {
                this.headerScriptNL(",items:[");
                this.footerScript("]");
            }
        } else {
            String type = this.isFile ? "Ext.form.field.File" : this.getMeta("xwlType");
            this.headerScript(StringUtil.concat("Wd.", id, "=new ", type, "({"));
            this.footerScript("});");
            this.headerScript(this.getJson("renderTo:Ext.getBody()"));
            if (this.hasChild) {
                this.headerScriptNL(",items:[");
                this.footerScript("]");
            }
        }
    }

    @Override
    protected String getTagProperties() throws Exception {
        String color = this.gs("color");
        String bgColor = this.gs("bgColor");
        String bgImage = this.gs("bgImage");
        this.setStyles(this.gs("fieldStyle"));
        if (StringUtil.isEmpty(bgImage)) {
            if (!StringUtil.isEmpty(bgColor)) {
                bgImage = "none";
            }
        } else {
            bgImage = StringUtil.concat("url(", bgImage, ")");
        }
        this.addStyle("color", color);
        this.addStyle("background-color", bgColor);
        this.addStyle("background-image", bgImage);
        if (this.isFile) {
            this.addText("name", this.gs("id"));
            this.addExpress("buttonConfig", "{iconCls:\"explorer_icon\",text:\"\"}");
        } else {
            this.addText("inputType", this.inputType);
        }
        this.addText("fieldStyle", this.getSBuffer());
        if (this.getMeta("xwlXtype").equals("textarea")) {
            this.addExpress("height", this.gs("height"));
        }
        return this.getPBuffer();
    }

    @Override
    protected String[] getReservedKeys() throws Exception {
        return this.key;
    }
}

