/*
 * Decompiled with CFR 0.152.
 */
package com.webbuilder.controls;

import com.webbuilder.controls.FrontControl;
import com.webbuilder.utils.StringUtil;
import com.webbuilder.utils.WebUtil;
import java.util.Iterator;

public class ExtControl
extends FrontControl {
    private StringBuilder propertiesBuffer = new StringBuilder();
    private StringBuilder eventsBuffer = new StringBuilder();
    private StringBuilder stylesBuffer = new StringBuilder();
    private StringBuilder objectsBuffer = new StringBuilder();
    protected boolean listenersPrefix = true;
    protected boolean setRender = true;

    @Override
    public void create() throws Exception {
        this.createScript();
    }

    protected void createScript() throws Exception {
        if (this.hasParent) {
            String xtype = this.getMeta("xwlXtype");
            xtype = StringUtil.isEmpty(xtype) ? "" : StringUtil.concat("xtype:\"", xtype, "\"");
            this.headerScript(StringUtil.concat(this.getComma(), "{", this.getJson(xtype)));
            this.footerScript("}");
            if (this.hasChild) {
                this.headerScriptNL(",items:[");
                this.footerScript("]");
            }
        } else {
            String id = this.gs("id");
            this.headerScript(StringUtil.concat("Wd.", id, "=new ", this.getMeta("xwlType"), "({"));
            this.footerScript("});");
            if (this.setRender) {
                this.headerScript(this.getJson("renderTo:Ext.getBody()"));
            } else {
                this.headerScript(this.getJson(null));
            }
            if (this.hasChild) {
                this.headerScriptNL(",items:[");
                this.footerScript("]");
            }
        }
    }

    protected String getJson(String moreProperties) throws Exception {
        String te;
        String tp;
        StringBuilder buf = new StringBuilder();
        StringBuilder event = new StringBuilder();
        Iterator names = this.xwlObject.keys();
        boolean addComma = false;
        String tagProperties = null;
        String tagEvents = null;
        String[] reserved = this.getReservedKeys();
        String[] expTypes = new String[]{"boolean", "bind", "express", "object", "date"};
        while (names.hasNext()) {
            String metaType;
            String val;
            String n = (String)names.next();
            if (n.equals("xwlMeta") || n.equals("children") || reserved != null && StringUtil.indexOf(reserved, n) != -1 || StringUtil.isEmpty(val = this.gs(n))) continue;
            if (n.equals("tagProperties")) {
                tagProperties = val;
                continue;
            }
            if (n.equals("tagEvents")) {
                tagEvents = val;
                continue;
            }
            String meta = this.getMeta(n);
            if (StringUtil.isEmpty(meta)) {
                meta = "string";
            }
            if (StringUtil.isSame(metaType = StringUtil.getNamePart(meta), "js")) {
                if (this.isProperty(n)) {
                    if (addComma) {
                        buf.append(',');
                    } else {
                        addComma = true;
                    }
                    buf.append(String.valueOf(n) + ":function(" + StringUtil.replace(StringUtil.getValuePart(meta), " ", "") + "){\n");
                    buf.append(val);
                    buf.append("\n}");
                    continue;
                }
                if (event.length() > 0) {
                    event.append(',');
                }
                event.append(String.valueOf(n) + ":function(" + StringUtil.replace(StringUtil.getValuePart(meta), " ", "") + "){\n");
                event.append(val);
                event.append("\n}");
                continue;
            }
            if (addComma) {
                buf.append(',');
            } else {
                addComma = true;
            }
            buf.append(n);
            buf.append(':');
            if (val.startsWith("@")) {
                buf.append(val.substring(1));
                continue;
            }
            if (StringUtil.indexOf(expTypes, metaType) != -1) {
                buf.append(val);
                continue;
            }
            if (StringUtil.isEqual(metaType, "url")) {
                val = WebUtil.getUrl(val, false);
            }
            buf.append(StringUtil.quote(val));
        }
        if (!StringUtil.isEmpty(moreProperties)) {
            if (buf.length() > 0) {
                buf.append(',');
            }
            buf.append(moreProperties);
        }
        if (!StringUtil.isEmpty(tp = this.getTagProperties())) {
            if (buf.length() > 0) {
                buf.append(',');
            }
            buf.append(tp);
        }
        if (!StringUtil.isEmpty(tagProperties)) {
            if (buf.length() > 0) {
                buf.append(',');
            }
            buf.append(tagProperties);
        }
        if (!StringUtil.isEmpty(te = this.getTagEvents())) {
            if (event.length() > 0) {
                event.append(',');
            }
            event.append(te);
        }
        if (!StringUtil.isEmpty(tagEvents)) {
            if (event.length() > 0) {
                event.append(',');
            }
            event.append(tagEvents);
        }
        if (event.length() > 0) {
            if (this.listenersPrefix) {
                buf.append(",listeners:{");
                buf.append(event.toString());
                buf.append('}');
            } else {
                buf.append(',');
                buf.append(event.toString());
            }
        }
        return buf.toString();
    }

    protected String[] getReservedKeys() throws Exception {
        return null;
    }

    protected String getTagProperties() throws Exception {
        return "";
    }

    protected String getTagEvents() throws Exception {
        return "";
    }

    protected void addText(String key, String value) {
        if (StringUtil.isEmpty(value)) {
            return;
        }
        if (this.propertiesBuffer.length() > 0) {
            this.propertiesBuffer.append(',');
        }
        this.propertiesBuffer.append(key);
        this.propertiesBuffer.append(':');
        if (value.startsWith("@")) {
            this.propertiesBuffer.append(value.substring(1));
        } else {
            this.propertiesBuffer.append(StringUtil.quote(value));
        }
    }

    protected void addExpress(String key, String value) {
        if (StringUtil.isEmpty(value)) {
            return;
        }
        if (this.propertiesBuffer.length() > 0) {
            this.propertiesBuffer.append(',');
        }
        this.propertiesBuffer.append(key);
        this.propertiesBuffer.append(':');
        if (value.startsWith("@")) {
            this.propertiesBuffer.append(value.substring(1));
        } else {
            this.propertiesBuffer.append(value);
        }
    }

    protected void addEvent(String name, String script) {
        if (StringUtil.isEmpty(script)) {
            return;
        }
        if (this.eventsBuffer.length() > 0) {
            this.eventsBuffer.append(',');
        }
        this.eventsBuffer.append(name);
        this.eventsBuffer.append(':');
        this.eventsBuffer.append(script);
    }

    protected void setStyles(String styles) {
        if (StringUtil.isEmpty(styles)) {
            return;
        }
        if (this.stylesBuffer.length() > 0) {
            this.stylesBuffer.append(';');
        }
        this.stylesBuffer.append(styles);
    }

    protected void addStyle(String key, String value) {
        if (StringUtil.isEmpty(value)) {
            return;
        }
        if (this.stylesBuffer.length() > 0) {
            this.stylesBuffer.append(';');
        }
        this.stylesBuffer.append(key);
        this.stylesBuffer.append(':');
        this.stylesBuffer.append(value);
    }

    protected void setObjects(String objects) {
        if (objects != null && objects.startsWith("{")) {
            objects = objects.substring(1, objects.length() - 1);
        }
        if (StringUtil.isEmpty(objects)) {
            return;
        }
        if (this.objectsBuffer.length() > 0) {
            this.objectsBuffer.append(',');
        }
        this.objectsBuffer.append(objects);
    }

    protected void addObject(String key, String value) {
        if (StringUtil.isEmpty(value)) {
            return;
        }
        if (this.objectsBuffer.length() > 0) {
            this.objectsBuffer.append(',');
        }
        this.objectsBuffer.append(key);
        this.objectsBuffer.append(':');
        if (value.startsWith("@")) {
            this.objectsBuffer.append(value.substring(1));
        } else {
            this.objectsBuffer.append(value);
        }
    }

    protected String getPBuffer() {
        return this.propertiesBuffer.toString();
    }

    protected String getEBuffer() {
        return this.eventsBuffer.toString();
    }

    protected String getOBuffer() {
        String s = this.objectsBuffer.toString();
        if (StringUtil.isEmpty(s)) {
            return "";
        }
        return StringUtil.concat("{", this.objectsBuffer.toString(), "}");
    }

    protected String getSBuffer() {
        return this.stylesBuffer.toString();
    }

    protected void resetSBuffer() {
        this.stylesBuffer.delete(0, this.stylesBuffer.length());
    }

    protected void resetPBuffer() {
        this.propertiesBuffer.delete(0, this.propertiesBuffer.length());
    }

    protected void resetEBuffer() {
        this.eventsBuffer.delete(0, this.eventsBuffer.length());
    }
}

