/*
 * Decompiled with CFR 0.152.
 */
package com.webbuilder.controls;

import com.webbuilder.common.Str;
import com.webbuilder.common.SysMap;
import com.webbuilder.controls.FrontControl;
import com.webbuilder.tool.PageInfo;
import com.webbuilder.utils.DbUtil;
import com.webbuilder.utils.JsonUtil;
import com.webbuilder.utils.StringUtil;
import com.webbuilder.utils.WebUtil;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Timestamp;
import java.util.HashSet;
import org.json.JSONArray;
import org.json.JSONObject;

public class DataProvider
extends FrontControl {
    private static String treePrototypes = "[{name:'parentId',type:'auto',defaultValue:null},{name:'index',type:'int',defaultValue:null,persist:false},{name:'depth',type:'int',defaultValue:0,persist:false},{name:'expanded',type:'bool',defaultValue:false,persist:false},{name:'expandable',type:'bool',defaultValue:true,persist:false},{name:'checked',type:'auto',defaultValue:null,persist:false},{name:'leaf',type:'bool',defaultValue:false},{name:'cls',type:'string',defaultValue:null,persist:false},{name:'iconCls',type:'string',defaultValue:null,persist:false},{name:'icon',type:'string',defaultValue:null,persist:false},{name:'root',type:'boolean',defaultValue:false,persist:false},{name:'isLast',type:'boolean',defaultValue:false,persist:false},{name:'isFirst',type:'boolean',defaultValue:false,persist:false},{name:'allowDrop',type:'boolean',defaultValue:true,persist:false},{name:'allowDrag',type:'boolean',defaultValue:true,persist:false},{name:'loaded',type:'boolean',defaultValue:false,persist:false},{name:'loading',type:'boolean',defaultValue:false,persist:false},{name:'href',type:'string',defaultValue:null,persist:false},{name:'hrefTarget',type:'string',defaultValue:null,persist:false},{name:'qtip',type:'string',defaultValue:null,persist:false},{name:'qtitle',type:'string',defaultValue:null,persist:false},{name:'children',type:'auto',defaultValue:null,persist:false}]";
    private JSONObject keyMap;
    private boolean hasKey;

    @Override
    public void create() throws Exception {
        Object obj;
        PageInfo pageInfo;
        String type = this.gs("type");
        String mapFields = this.gs("keyMap");
        boolean isTree = type.equals("tree");
        boolean isArray = type.isEmpty() || type.equals("jsonArray") || isTree;
        this.keyMap = mapFields.isEmpty() ? null : new JSONObject(mapFields);
        boolean bl = this.hasKey = this.keyMap != null;
        if (isArray) {
            pageInfo = WebUtil.getPage(this.request);
            String ls = this.gs("limitRecords");
            if (!ls.isEmpty()) {
                pageInfo.limit = Integer.parseInt(ls);
                if (pageInfo.limit == -1) {
                    pageInfo.limit = Integer.MAX_VALUE;
                }
            }
        } else {
            pageInfo = null;
        }
        this.setOrderSql();
        String sql = this.gs("sql");
        String switcher = this.gs("sqlSwitcher");
        String jndi = this.gs("jndi");
        if (sql.isEmpty() && !switcher.isEmpty()) {
            sql = this.gp(switcher);
        }
        if (!((obj = this.run(sql, jndi, this.gs("resultSet"))) instanceof ResultSet)) {
            String valStr = obj == null ? "\"\"" : StringUtil.quote(obj.toString());
            WebUtil.response(this.response, StringUtil.concat("{total:1,metaData:{fields:[{name:\"result\",type:\"string\"}]},columns:[{dataIndex:\"result\",header:", StringUtil.quote(Str.format(this.request, "result", new String[0])), ",width:150}],returnResult:", valStr, ",rows:[{result:", valStr, "}]}"));
            return;
        }
        ResultSet rs = (ResultSet)obj;
        if (isArray) {
            Integer totalCount = null;
            String totalString = this.gs("totalCount");
            if (totalString.isEmpty()) {
                String totalSql = this.gs("totalSql");
                switcher = this.gs("totalSqlSwitcher");
                if (totalSql.isEmpty() && !switcher.isEmpty()) {
                    totalSql = this.gp(switcher);
                }
                if ((obj = this.run(totalSql, jndi, this.gs("totalResultSet"))) instanceof ResultSet) {
                    ResultSet totalRs = (ResultSet)obj;
                    if (totalRs.next()) {
                        totalCount = totalRs.getInt(1);
                    }
                } else if (obj != null) {
                    totalCount = Integer.parseInt(obj.toString());
                }
            } else {
                totalCount = Integer.parseInt(totalString);
            }
            this.outputJsonArray(rs, totalCount, pageInfo, isTree);
        } else if (type.equals("jsonObject")) {
            this.outputJsonObject(rs);
        } else if (type.equals("download")) {
            DbUtil.outputBlob(rs, this.request, this.response, true);
        } else if (type.equals("stream")) {
            DbUtil.outputBlob(rs, this.request, this.response, false);
        } else {
            DbUtil.outputImage(rs, this.request, this.response, type);
        }
    }

    private Object run(String sql, String jndi, String name) throws Exception {
        Object obj = sql.isEmpty() ? null : DbUtil.execute(this.request, sql, jndi);
        if (name.isEmpty()) {
            return obj;
        }
        Object attr = this.ga(name);
        if (attr == null) {
            return obj;
        }
        return attr;
    }

    private void outputJsonArray(ResultSet rs, Integer total, PageInfo pageInfo, boolean isTree) throws Exception {
        boolean needTotal;
        boolean first = true;
        boolean paged = this.gb("autoPage", true);
        String tagInfo = this.gs("tag");
        StringBuilder buf = new StringBuilder();
        ResultSetMetaData meta = rs.getMetaData();
        boolean dateAsString = this.gb("dateAsString", false);
        int j = meta.getColumnCount();
        String[] names = new String[j];
        String[] labels = new String[j];
        int[] types = new int[j];
        int i = 0;
        while (i < j) {
            names[i] = meta.getColumnLabel(i + 1);
            if (StringUtil.isEmpty(names[i])) {
                names[i] = "FIELD" + Integer.toString(i + 1);
            }
            labels[i] = StringUtil.quote(names[i]);
            types[i] = meta.getColumnType(i + 1);
            ++i;
        }
        if (total != null) {
            buf.append("{total:");
            buf.append(Integer.toString(total));
            needTotal = false;
        } else {
            needTotal = true;
        }
        if (!tagInfo.isEmpty()) {
            buf.append(",");
            buf.append(tagInfo);
        }
        buf.append(",metaData:{fields:");
        String fields = DbUtil.getFields(meta, j, dateAsString, this.keyMap);
        if (isTree) {
            buf.append(this.mergeFields(fields));
        } else {
            buf.append(fields);
        }
        buf.append('}');
        if (this.gb("createColumns", false)) {
            buf.append(",columns:");
            buf.append(DbUtil.getColumns(meta, j, this.gs("editorType"), this.gb("rowNumber", false), dateAsString, this.keyMap));
        }
        if (isTree) {
            buf.append(",children:[");
        } else {
            buf.append(",rows:[");
        }
        while (rs.next()) {
            int cp = WebUtil.checkPage(pageInfo, paged, needTotal);
            if (cp == 1) break;
            if (cp == 2) continue;
            if (first) {
                first = false;
            } else {
                buf.append(',');
            }
            buf.append('{');
            boolean addComma = false;
            i = 0;
            while (i < j) {
                Object obj = DbUtil.getObject(rs, i + 1, types[i]);
                if (obj != null) {
                    if (this.hasKey && this.keyMap.has(names[i])) {
                        obj = SysMap.get(this.keyMap.getString(names[i]), obj.toString());
                    }
                    if (addComma) {
                        buf.append(',');
                    } else {
                        addComma = true;
                    }
                    buf.append(labels[i]);
                    buf.append(':');
                    if (dateAsString && obj instanceof Timestamp) {
                        buf.append('\"');
                        String val = obj.toString();
                        if (val.endsWith("00:00:00.0")) {
                            val = val.substring(0, 10);
                        } else if (val.endsWith(".0")) {
                            val = val.substring(0, 19);
                        }
                        buf.append(val);
                        buf.append('\"');
                    } else if (isTree && obj != null) {
                        String xVal = obj.toString();
                        xVal = xVal.equals("__[]") ? "[]" : (xVal.equals("__true") ? "true" : (xVal.equals("__false") ? "false" : StringUtil.encode(obj)));
                        buf.append(xVal);
                    } else {
                        buf.append(StringUtil.encode(obj));
                    }
                }
                ++i;
            }
            buf.append('}');
        }
        buf.append("]}");
        if (needTotal) {
            WebUtil.setTotal(buf, pageInfo);
        }
        WebUtil.setCb(buf, this.request.getParameter("callback"));
        WebUtil.response(this.response, buf);
    }

    private String mergeFields(String fields) throws Exception {
        JSONArray pt = new JSONArray(treePrototypes);
        JSONArray ja = new JSONArray(fields);
        int j = pt.length();
        int l = ja.length();
        HashSet<String> hs = new HashSet<String>(j);
        int i = 0;
        while (i < j) {
            hs.add(pt.getJSONObject(i).getString("name"));
            ++i;
        }
        int k = 0;
        while (k < l) {
            JSONObject jo = ja.getJSONObject(k);
            if (!hs.contains(jo.getString("name"))) {
                pt.put((Object)jo);
            }
            ++k;
        }
        return pt.toString();
    }

    private void outputJsonObject(ResultSet rs) throws Exception {
        JSONObject jo = new JSONObject();
        if (rs.next()) {
            ResultSetMetaData meta = rs.getMetaData();
            int j = meta.getColumnCount();
            int i = 0;
            while (i < j) {
                int type = meta.getColumnType(i + 1);
                String key = meta.getColumnLabel(i + 1);
                if (StringUtil.isEmpty(key)) {
                    key = "FIELD" + Integer.toString(i + 1);
                }
                Object value = DbUtil.getObject(rs, i + 1, type);
                if (this.hasKey && value != null && this.keyMap.has(key)) {
                    value = SysMap.get(this.keyMap.getString(key), value.toString());
                }
                jo.put(key, value);
                ++i;
            }
        }
        WebUtil.response(this.response, jo);
    }

    private void setOrderSql() throws Exception {
        JSONArray ja;
        int j;
        String sort = this.gp("sort");
        if (!sort.isEmpty() && (j = (ja = new JSONArray(sort)).length()) > 0) {
            String defaultPrefix;
            JSONObject orderJo;
            StringBuilder exp = new StringBuilder();
            String orderFields = this.gs("orderFields");
            if (orderFields.isEmpty()) {
                orderJo = null;
                defaultPrefix = "";
            } else {
                orderJo = new JSONObject(orderFields);
                defaultPrefix = JsonUtil.optString(orderJo, "default");
            }
            int i = 0;
            while (i < j) {
                JSONObject jo = ja.getJSONObject(i);
                if (i > 0) {
                    exp.append(',');
                }
                String property = jo.getString("property");
                if (orderJo != null) {
                    if (orderJo.has(property)) {
                        String prefix = orderJo.optString(property);
                        if (!prefix.isEmpty()) {
                            exp.append(prefix);
                            exp.append(".");
                        }
                    } else if (!defaultPrefix.isEmpty()) {
                        exp.append(defaultPrefix);
                        exp.append(".");
                    }
                }
                exp.append(property);
                if (StringUtil.isSame(jo.optString("direction"), "desc")) {
                    exp.append(" desc");
                }
                ++i;
            }
            this.request.setAttribute("sql.orderBy", (Object)(" order by " + exp));
            this.request.setAttribute("sql.orderFields", (Object)("," + exp));
        }
    }
}

