/*
 * Decompiled with CFR 0.152.
 */
package com.webbuilder.controls;

import com.webbuilder.controls.ExtControl;
import com.webbuilder.utils.StringUtil;

public class Column
extends ExtControl {
    private String[] key = new String[]{"renderer", "align", "width", "sortable", "hideable", "style"};
    private String type;

    @Override
    public void create() throws Exception {
        this.type = this.gs("type");
        String xtype = this.type.equals("treeColumn") ? "xtype:\"treecolumn\"" : null;
        this.headerScript(StringUtil.concat(this.getComma(), "{", this.getJson(xtype)));
        this.footerScript("}");
        if (this.hasChild) {
            this.headerScriptNL(",columns:[");
            this.footerScript("]");
        }
    }

    @Override
    protected String getTagProperties() throws Exception {
        String render = this.gs("renderer");
        String align = this.gs("align");
        String format = this.gs("format");
        String width = this.gs("width");
        String sortable = this.gs("sortable");
        String hideable = this.gs("hideable");
        String style = this.gs("style");
        String headerAlign = this.gs("headerAlign");
        boolean isRowNumber = this.type.equals("rowNumber");
        if (isRowNumber) {
            if (width.isEmpty()) {
                width = "45";
            }
            if (sortable.isEmpty()) {
                sortable = "false";
            }
            if (align.isEmpty()) {
                align = "right";
            }
            if (hideable.isEmpty()) {
                hideable = "false";
            }
        }
        format = format.isEmpty() ? "0" : StringUtil.quote(format);
        if (StringUtil.isEmpty(render)) {
            if (!this.hasChild) {
                if (isRowNumber) {
                    this.addExpress("renderer", "Wb.nr");
                } else {
                    this.addExpress("renderer", StringUtil.concat("function(a,b){return Wb.rd(a,b,", this.gb("autoWrap", false) ? "1" : "0", ",", format, ")}"));
                }
            }
        } else {
            this.addExpress("renderer", StringUtil.concat("function(value,metaData,record,rowIndex,colIndex,store,view){\n", render, "\n}"));
        }
        this.addExpress("sortable", sortable);
        this.addExpress("hideable", hideable);
        this.addExpress("width", width);
        this.addText("align", align);
        if (!headerAlign.isEmpty()) {
            if (!style.isEmpty() && !style.endsWith(";")) {
                style = String.valueOf(style) + ";";
            }
            style = String.valueOf(style) + "text-align:" + headerAlign + ";";
        }
        this.addText("style", style);
        return this.getPBuffer();
    }

    @Override
    protected String[] getReservedKeys() throws Exception {
        return this.key;
    }
}

