/*
 * Decompiled with CFR 0.152.
 */
package com.webbuilder.common;

import com.webbuilder.utils.DbUtil;
import com.webbuilder.utils.StringUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SysMap {
    private static ConcurrentHashMap<String, ConcurrentHashMap<String, String>> buffer;

    public static String get(String type, String name) throws Exception {
        ConcurrentHashMap<String, String> map;
        if (buffer == null) {
            SysMap.initialize(false);
        }
        if ((map = buffer.get(type)) == null) {
            return null;
        }
        return map.get(name);
    }

    public static void put(String type, String name, String value) throws Exception {
        ConcurrentHashMap<String, String> map;
        if (buffer == null) {
            SysMap.initialize(false);
        }
        if ((map = buffer.get(type)) == null) {
            map = new ConcurrentHashMap();
        }
        map.put(name, value);
        buffer.put(type, map);
    }

    public static void remove(String type, String name) throws Exception {
        if (buffer == null) {
            return;
        }
        ConcurrentHashMap<String, String> map = buffer.get(type);
        if (map != null) {
            map.remove(name);
            if (map.isEmpty()) {
                buffer.remove(type);
            }
        }
    }

    public static String getList(String type, String sortType) {
        ConcurrentHashMap<String, String> map = buffer.get(type);
        if (map == null) {
            return "[]";
        }
        List<Map.Entry<String, ?>> ls = StringUtil.isSame(sortType, "keyAsNumber") ? StringUtil.sortMapKey(map, true) : (StringUtil.isSame(sortType, "value") ? StringUtil.sortMapValue(map) : StringUtil.sortMapKey(map));
        StringBuilder buf = new StringBuilder();
        boolean isFirst = true;
        buf.append("[");
        for (Map.Entry<String, ?> e : ls) {
            if (isFirst) {
                isFirst = false;
            } else {
                buf.append(",");
            }
            buf.append("[");
            buf.append(StringUtil.quote(e.getKey()));
            buf.append(",");
            buf.append(StringUtil.quote(e.getValue().toString()));
            buf.append("]");
        }
        buf.append("]");
        return buf.toString();
    }

    private static void loadKeys() throws Exception {
        Connection conn = null;
        ResultSet rs = null;
        String type = null;
        String preType = null;
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
        try {
            conn = DbUtil.getConnection();
            rs = DbUtil.getResultSet(conn, "select KEY_TYPE,KEY_NAME,KEY_VALUE from WB_KEY order by KEY_TYPE");
            while (rs.next()) {
                type = rs.getString(1);
                if (preType != null && !preType.equals(type)) {
                    buffer.put(preType, map);
                    map = new ConcurrentHashMap();
                }
                map.put(rs.getString(2), rs.getString(3));
                preType = type;
            }
            if (preType != null) {
                buffer.put(preType, map);
            }
        }
        catch (Throwable throwable) {
            DbUtil.closeResultSet(rs);
            DbUtil.closeConnection(conn);
            throw throwable;
        }
        DbUtil.closeResultSet(rs);
        DbUtil.closeConnection(conn);
    }

    public static synchronized void initialize(boolean reload) throws Exception {
        if (!reload && buffer != null) {
            return;
        }
        buffer = new ConcurrentHashMap();
        SysMap.loadKeys();
    }
}

