/*
 * Decompiled with CFR 0.152.
 */
package com.webbuilder.common;

import com.webbuilder.common.Str;
import com.webbuilder.common.UserInfo;
import com.webbuilder.common.Var;
import com.webbuilder.interact.Install;
import com.webbuilder.tool.Encrypter;
import com.webbuilder.utils.DbUtil;
import com.webbuilder.utils.StringUtil;
import com.webbuilder.utils.WebUtil;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class Session {
    public static final ConcurrentHashMap<String, HttpSession> sessionList = new ConcurrentHashMap();

    public static void verify(HttpServletRequest request, HttpServletResponse response) throws Exception {
        int userCt;
        String referer = request.getHeader("Referer");
        HttpSession session = request.getSession(false);
        if (StringUtil.isEmpty(referer) || referer.indexOf("main?xwl=login") != -1) {
            referer = "main?xwl=index";
        }
        if (session != null && session.getAttribute("sys.logined") != null && StringUtil.isEqual(request.getParameter("username"), (String)session.getAttribute("sys.userName"))) {
            WebUtil.response(response, referer);
            request.setAttribute("ignore", (Object)true);
            return;
        }
        if (Var.getBool("webbuilder.session.loginVerify")) {
            Session.checkVerifyCode(request);
        }
        if ((userCt = Install.getUserCount()) != -1 && sessionList.size() > userCt - 1) {
            if (userCt == 3) {
                throw new Exception("Trial version only allows 3 active users.");
            }
            throw new Exception("The license only allows " + userCt + " active users.");
        }
        String[] userInfo = Session.checkUser(request);
        Session.createSession(request, userInfo);
        WebUtil.response(response, referer);
    }

    public static void logout(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.invalidate();
        }
    }

    private static void checkVerifyCode(HttpServletRequest request) throws Exception {
        HttpSession session = request.getSession(false);
        if (session == null) {
            throw new Exception(Str.format(request, "vcExpired", new String[0]));
        }
        String vcCode = (String)session.getAttribute("sys.verifyCode");
        session.removeAttribute("sys.verifyCode");
        if (StringUtil.isEmpty(vcCode) || !StringUtil.isSame(vcCode, request.getParameter("verifyCode"))) {
            throw new Exception(Str.format(request, "invalidVc", new String[0]));
        }
    }

    private static String[] checkUser(HttpServletRequest request) throws Exception {
        ResultSet rs = DbUtil.query(request, "select USER_ID,USER_NAME,DISPLAY_NAME,PASSWORD,USE_LANG from WB_USER where USER_NAME={?username?} and STATUS=1");
        String password = request.getParameter("password");
        String username = request.getParameter("username");
        String[] result = new String[4];
        if (!rs.next()) {
            throw new Exception(Str.format(request, "userNotExist", username));
        }
        result[0] = rs.getString(1);
        result[1] = rs.getString(2);
        result[2] = rs.getString(3);
        String truePwd = rs.getString(4);
        result[3] = rs.getString(5);
        if (!StringUtil.isEqual(Encrypter.getMD5(password), truePwd)) {
            throw new Exception(Str.format(request, "invalidPwd", new String[0]));
        }
        return result;
    }

    private static String[] getRoles(HttpServletRequest request, String userId) throws Exception {
        request.setAttribute("userId", (Object)userId);
        ResultSet rs = DbUtil.query(request, "select ROLE_ID from WB_USER_ROLE where USER_ID={?userId?}");
        ArrayList<String> list = new ArrayList<String>();
        while (rs.next()) {
            list.add(rs.getString(1));
        }
        int size = list.size();
        if (size == 0) {
            return null;
        }
        return list.toArray(new String[size]);
    }

    private static void createSession(HttpServletRequest request, String[] userInfo) throws Exception {
        int timeout = Var.getInt("webbuilder.session.sessionTimeout");
        HttpSession session = request.getSession(true);
        session.setAttribute("sys.logined", (Object)1);
        request.setAttribute("sys.user", (Object)userInfo[0]);
        request.setAttribute("sys.userName", (Object)userInfo[1]);
        request.setAttribute("sys.dispName", (Object)userInfo[2]);
        request.setAttribute("sys.lang", (Object)userInfo[3]);
        if (timeout != 0) {
            session.setMaxInactiveInterval(timeout);
        }
        session.setAttribute("sys.user", (Object)userInfo[0]);
        session.setAttribute("sys.userName", (Object)userInfo[1]);
        session.setAttribute("sys.dispName", (Object)userInfo[2]);
        session.setAttribute("sys.lang", (Object)userInfo[3]);
        session.setAttribute("sys.userRoles", (Object)Session.getRoles(request, userInfo[0]));
        session.setAttribute("sys.userIp", (Object)request.getRemoteAddr());
        UserInfo user = new UserInfo();
        user.setSession(session);
        session.setAttribute("sys.userInfo", (Object)user);
    }
}

