/*
 * Decompiled with CFR 0.152.
 */
package com.webbuilder.common;

import com.webbuilder.common.Main;
import com.webbuilder.utils.StringUtil;
import java.io.File;
import java.io.FileReader;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ScriptBuffer {
    private static ScriptEngine engine;
    private static Compilable compilable;
    private static ConcurrentHashMap<String, CompiledScript> scriptMap;

    public static void run(String id, String scriptText, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CompiledScript script;
        if (scriptMap == null) {
            ScriptBuffer.initialize(false);
        }
        if ((script = scriptMap.get(id)) == null) {
            script = compilable.compile(StringUtil.concat("(function(){", scriptText, "\n})();"));
            scriptMap.put(id, script);
        }
        Bindings bindings = engine.createBindings();
        bindings.put("request", (Object)request);
        bindings.put("response", (Object)response);
        script.eval(bindings);
    }

    public static void remove(String id) throws Exception {
        if (scriptMap == null) {
            return;
        }
        Set<Map.Entry<String, CompiledScript>> es = scriptMap.entrySet();
        for (Map.Entry<String, CompiledScript> e : es) {
            String k = e.getKey();
            if (!k.startsWith(String.valueOf(id) + ".")) continue;
            scriptMap.remove(k);
        }
    }

    public static synchronized void initialize(boolean reload) throws Exception {
        if (!reload && scriptMap != null) {
            return;
        }
        ScriptEngineManager manager = new ScriptEngineManager();
        engine = manager.getEngineByName("javascript");
        compilable = (Compilable)((Object)engine);
        Bindings globalBindings = engine.getBindings(200);
        CompiledScript wbScript = compilable.compile(new FileReader(new File(Main.path, "webbuilder/script/server.js")));
        wbScript.eval(globalBindings);
        scriptMap = new ConcurrentHashMap();
    }
}

