/*
 * Decompiled with CFR 0.152.
 */
package com.webbuilder.common;

import com.webbuilder.common.ScriptBuffer;
import com.webbuilder.common.Str;
import com.webbuilder.common.Var;
import com.webbuilder.common.XwlBuffer;
import com.webbuilder.common.XwlData;
import com.webbuilder.controls.Control;
import com.webbuilder.controls.FrontControl;
import com.webbuilder.utils.DateUtil;
import com.webbuilder.utils.DbUtil;
import com.webbuilder.utils.LogUtil;
import com.webbuilder.utils.StringUtil;
import com.webbuilder.utils.SysUtil;
import com.webbuilder.utils.WebUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Stack;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.json.JSONArray;
import org.json.JSONObject;

public class Parser {
    public StringBuilder header = new StringBuilder();
    public Stack<String> footer = new Stack();
    public StringBuilder headerScript = new StringBuilder();
    public Stack<String> footerScript = new Stack();
    public StringBuilder initScript = new StringBuilder();
    public StringBuilder finalScript = new StringBuilder();
    private boolean loadLib;
    private String xwlId;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private JSONObject content;
    private XwlData xwlData;

    public Parser(HttpServletRequest req, HttpServletResponse resp, String xwl) throws Exception {
        this.request = req;
        this.response = resp;
        this.xwlId = xwl;
        this.xwlData = XwlBuffer.getXwl(this.xwlId);
        this.content = this.xwlData == null ? null : this.xwlData.content;
    }

    public void parse() throws Exception {
        if (this.content == null) {
            this.response.setStatus(500);
            WebUtil.response(this.response, Str.langFormat(WebUtil.getLanguage(this.request), "moduleNotFound", new String[0]));
            return;
        }
        if (!this.checkMethod()) {
            return;
        }
        boolean ex = false;
        List<?> list = null;
        String logType = this.gs("logType");
        boolean logAll = logType.equals("all");
        boolean loginRequired = this.content.optBoolean("loginRequired", true);
        String tokens = this.gs("tokens");
        if (!tokens.isEmpty() && this.checkToken(tokens)) {
            loginRequired = false;
        }
        try {
            this.storeVar();
            if (loginRequired) {
                if (WebUtil.checkLogin(this.request, this.response)) {
                    if (!WebUtil.checkRight(this.request, this.xwlId)) {
                        throw new Exception(Str.format(this.request, "forbidden", new String[0]));
                    }
                } else {
                    return;
                }
            }
            try {
                String logMsg;
                if (ServletFileUpload.isMultipartContent((HttpServletRequest)this.request)) {
                    list = WebUtil.setUploadFile(this.request);
                }
                if (!(logMsg = this.gs("logMessage")).isEmpty()) {
                    LogUtil.message(this.request, logMsg);
                } else if (logAll || logType.equals("access")) {
                    LogUtil.message(this.request, StringUtil.concat(this.xwlData.title, "(", this.xwlId, ")"));
                }
                boolean created = this.createModule(true);
                this.createChildren(this.content);
                this.doFinalize();
                this.outputScript(created);
            }
            catch (Throwable e) {
                ex = true;
                if (logAll || logType.equals("exception")) {
                    LogUtil.error(this.request, StringUtil.concat(this.xwlData.title, "(", this.xwlId, "): ", SysUtil.getShortError(e)));
                }
                WebUtil.showException(e, this.request, this.response);
            }
        }
        finally {
            this.closeObjects(this.request, ex);
            if (list != null) {
                WebUtil.clearUploadFile(this.request, list);
            }
        }
    }

    public void simpleParse(boolean asComp) throws Exception {
        boolean created = this.createModule(!asComp);
        this.createChildren(this.content);
        this.doFinalize();
        if (!asComp) {
            this.outputScript(created);
        }
    }

    private boolean checkToken(String tokens) {
        String[] ls;
        String token = WebUtil.fetch(this.request, "_token").trim();
        if (token.isEmpty()) {
            return false;
        }
        String[] stringArray = ls = StringUtil.split(tokens, ",");
        int n = ls.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (token.equals(s.trim())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void doFinalize() throws Exception {
        String modules = this.gs("finalModules");
        String script = this.gs("finalScript");
        String method = this.gs("finalMethod");
        if (!modules.isEmpty()) {
            this.importModules(modules);
        }
        if (!script.isEmpty()) {
            ScriptBuffer.run(StringUtil.concat(this.xwlId, ".", this.gs("id"), ".finalScript"), script, this.request, this.response);
        }
        if (!method.isEmpty()) {
            SysUtil.executeMethod(method, this.request, this.response);
        }
    }

    private void storeVar() throws Exception {
        Date date = new Date();
        this.request.setAttribute("sys.date", (Object)date);
        this.request.setAttribute("sys.now", (Object)DateUtil.toString(date));
        this.request.setAttribute("sys.id", (Object)SysUtil.getId());
        this.request.setAttribute("sys.lang", (Object)WebUtil.getLanguage(this.request));
    }

    private void createChildren(JSONObject obj) throws Exception {
        String parentMeta = obj.optString("xwlMeta");
        JSONArray ja = obj.optJSONArray("children");
        if (ja == null) {
            return;
        }
        int j = ja.length();
        int i = 0;
        while (i < j) {
            JSONObject jo = ja.getJSONObject(i);
            String metaName = jo.optString("xwlMeta");
            JSONObject meta = XwlBuffer.getMeta(metaName);
            JSONObject xwlMeta = meta.getJSONObject("xwlMeta");
            String className = xwlMeta.optString("xwlClass");
            Class<?> cls = className.indexOf(46) == -1 ? Class.forName("com.webbuilder.controls." + className) : Class.forName(className);
            Control control = (Control)cls.newInstance();
            control.setXwlMeta(xwlMeta);
            control.setPropertyList(meta.optJSONObject("properties"));
            control.xwlId = this.xwlId;
            control.request = this.request;
            control.response = this.response;
            control.xwlObject = jo;
            control.hasChild = jo.has("children");
            control.parentControl = obj;
            control.hasParent = !StringUtil.isEqual(parentMeta, "folder") && !StringUtil.isEqual(parentMeta, "module");
            control.isFirstChild = control.hasParent && i == 0;
            control.create();
            boolean isFrontControl = control instanceof FrontControl;
            if (isFrontControl) {
                FrontControl fc = (FrontControl)control;
                this.appendScript(this.header, fc.getHeader());
                this.footer.push(fc.getFooter());
                this.appendScript(this.headerScript, fc.getHeaderScript());
                this.footerScript.push(fc.getFooterScript());
                this.appendScript(this.initScript, fc.getInitScript());
                this.insertScript(this.finalScript, fc.getFinalScript());
            }
            if (control.hasChild) {
                this.createChildren(jo);
            }
            if (isFrontControl) {
                this.appendScript(this.headerScript, this.footerScript.pop());
            }
            if (isFrontControl) {
                this.appendScript(this.header, this.footer.pop());
            }
            ++i;
        }
    }

    private boolean checkMethod() throws Exception {
        String method = this.gs("method");
        return method.isEmpty() || method.equals(this.request.getMethod());
    }

    private String gs(String name) throws Exception {
        return StringUtil.replaceParameters(this.request, this.content.optString(name));
    }

    private boolean gb(String name, boolean defaultVal) throws Exception {
        String v = this.gs(name);
        if (StringUtil.isEmpty(v)) {
            return defaultVal;
        }
        return StringUtil.getBool(v);
    }

    private void importModules(String modules) throws Exception {
        String[] list;
        if (modules.substring(0, 1).equals("[")) {
            JSONArray ja = new JSONArray(modules);
            int j = ja.length();
            list = new String[j];
            int i = 0;
            while (i < j) {
                list[i] = WebUtil.getUrl(ja.getString(i), true);
                ++i;
            }
        } else {
            list = new String[]{WebUtil.getUrl(modules, true)};
        }
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String m = stringArray[n2];
            Parser p = new Parser(this.request, this.response, m);
            p.simpleParse(true);
            this.appendScript(this.header, p.header.toString());
            this.appendScript(this.headerScript, p.headerScript.toString());
            this.appendScript(this.initScript, p.initScript.toString());
            this.appendScript(this.finalScript, p.finalScript.toString());
            ++n2;
        }
    }

    private void createBody() throws Exception {
        ArrayList<String> cssFiles = new ArrayList<String>();
        ArrayList<String> jsFiles = new ArrayList<String>();
        String lang = null;
        this.loadLib = this.gb("loadLib", true);
        if (this.loadLib) {
            lang = (String)this.request.getAttribute("sys.lang");
            cssFiles.add("webbuilder/controls/ext/resources/css/ext-all.css");
            cssFiles.add("webbuilder/css/style.css");
            jsFiles.add("webbuilder/controls/ext/ext-all.js");
            jsFiles.add(StringUtil.concat("webbuilder/controls/ext/locale/ext-lang-", Str.optExtLanguage(lang), ".js"));
            jsFiles.add("webbuilder/script/wb.js");
            Calendar cal = Calendar.getInstance();
            int zoneOffset = (cal.get(15) + cal.get(16)) / 60000;
            String ajaxTimeout = Var.get("webbuilder.session.ajaxTimeout");
            if (StringUtil.isEmpty(ajaxTimeout)) {
                ajaxTimeout = null;
            }
            this.appendScript(this.initScript, StringUtil.concat("Wb.initialize(", ajaxTimeout, ",", Integer.toString(zoneOffset), ");"));
        }
        this.addUserFile(cssFiles, this.gs("cssFiles"));
        this.addUserFile(jsFiles, this.gs("jsFiles"));
        this.appendScript(this.header, "<!DOCTYPE html>\n<html>\n<head>\n<meta http-equiv=\"content-type\" content=\"text/html;charset=utf-8\">\n<title>");
        this.header.append(this.gs("title"));
        this.header.append("</title>");
        if (this.loadLib) {
            this.header.append("\n<script type=\"text/javascript\" src=\"webbuilder/script/locale/wb-lang-");
            this.header.append(Str.optLanguage(lang));
            this.header.append(".js\"></script>\n<script type=\"text/javascript\" src=\"webbuilder/script/welcome.js\"></script>");
        }
        for (String s : cssFiles) {
            this.appendScript(this.header, "<link rel=\"stylesheet\" href=\"");
            this.header.append(s);
            this.header.append("\" type=\"text/css\">");
        }
        for (String s : jsFiles) {
            this.appendScript(this.header, "<script type=\"text/javascript\" src=\"");
            this.header.append(s);
            this.header.append("\"></script>");
        }
        this.appendScript(this.header, this.gs("head"));
        this.appendScript(this.header, "</head>\n<body");
        String cls = this.gs("class");
        String style = this.gs("style");
        String tp = this.gs("tagProperties");
        if (!StringUtil.isEmpty(cls)) {
            this.header.append(" class=\"");
            this.header.append(cls);
            this.header.append("\"");
        }
        if (!StringUtil.isEmpty(style)) {
            this.header.append(" style=\"");
            this.header.append(style);
            this.header.append("\"");
        }
        if (!StringUtil.isEmpty(tp)) {
            this.header.append(' ');
            this.header.append(tp);
        }
        this.header.append('>');
        this.appendScript(this.initScript, this.gs("initialize"));
        this.appendScript(this.finalScript, this.gs("finalize"));
        this.populateEvents();
    }

    private boolean createModule(boolean create) throws Exception {
        boolean result;
        String method = this.gs("initMethod");
        String script = this.gs("initScript");
        String modules = this.gs("initModules");
        if (!method.isEmpty()) {
            SysUtil.executeMethod(method, this.request, this.response);
        }
        if (!script.isEmpty()) {
            ScriptBuffer.run(StringUtil.concat(this.xwlId, ".", this.gs("id"), ".initScript"), script, this.request, this.response);
        }
        if (create && this.gb("createBody", true)) {
            this.createBody();
            result = true;
        } else {
            result = false;
        }
        if (!modules.isEmpty()) {
            this.importModules(modules);
        }
        return result;
    }

    private void addUserFile(ArrayList<String> list, String url) throws Exception {
        if (!StringUtil.isEmpty(url)) {
            if (url.startsWith("[")) {
                JSONArray ja = new JSONArray(url);
                int j = ja.length();
                int i = 0;
                while (i < j) {
                    list.add(WebUtil.getUrl(ja.getString(i), false));
                    ++i;
                }
            } else {
                list.add(WebUtil.getUrl(url, false));
            }
        }
    }

    private void populateEvents() throws Exception {
        String resize = this.gs("resize");
        String unload = this.gs("beforeunload");
        if (!resize.isEmpty()) {
            this.appendScript(this.headerScript, "window.onresize=function(){\n");
            this.headerScript.append(resize);
            this.headerScript.append("\n}");
        }
        if (!unload.isEmpty()) {
            this.appendScript(this.headerScript, "Wd.wb_beforeunload=function(){\n");
            this.headerScript.append(unload);
            this.headerScript.append("\n}\nwindow.onbeforeunload=function(){if(!Wd.wb_forceCls&&!Wb.isLogout())return wb_beforeunload();}");
        }
    }

    private void appendScript(StringBuilder buf, String script) {
        if (!StringUtil.isEmpty(script)) {
            if (buf.length() > 0) {
                buf.append("\n");
            }
            buf.append(script);
        }
    }

    private void insertScript(StringBuilder buf, String script) {
        if (!StringUtil.isEmpty(script)) {
            if (buf.length() > 0) {
                buf.insert(0, "\n");
            }
            buf.insert(0, script);
        }
    }

    private void outputScript(boolean suffix) throws Exception {
        int l3;
        int l2;
        if (this.response.isCommitted()) {
            return;
        }
        int l1 = this.headerScript.length();
        if (l1 + (l2 = this.initScript.length()) + (l3 = this.finalScript.length()) > 0) {
            this.header.append("\n<script language=\"javascript\" type=\"text/javascript\">");
            if (this.loadLib) {
                this.header.append("\nExt.onReady(function(){");
            }
            if (l2 > 0) {
                this.header.append("\n");
                this.header.append((CharSequence)this.initScript);
            }
            if (l1 > 0) {
                this.header.append("\n");
                this.header.append((CharSequence)this.headerScript);
            }
            if (l3 > 0) {
                this.header.append("\n");
                this.header.append((CharSequence)this.finalScript);
            }
            if (this.loadLib) {
                this.header.append("\n});");
            }
            this.header.append("\n</script>");
        }
        if (suffix) {
            this.header.append("\n</body>\n</html>");
        }
        if (WebUtil.isFormSubmit(this.request)) {
            WebUtil.response(this.response, "{success:true,value:null}");
        } else if (this.header.length() > 0) {
            WebUtil.response(this.response, this.header);
        }
    }

    private void closeObjects(HttpServletRequest request, boolean isExcept) {
        Enumeration enums = request.getAttributeNames();
        ArrayList<Connection> connList = new ArrayList<Connection>();
        while (enums.hasMoreElements()) {
            String attrName = enums.nextElement().toString();
            Object object = request.getAttribute(attrName);
            if (object == null) continue;
            if (object instanceof ResultSet) {
                DbUtil.closeResultSet((ResultSet)object);
                continue;
            }
            if (!(object instanceof Connection)) continue;
            connList.add((Connection)object);
        }
        for (Connection conn : connList) {
            DbUtil.closeConnection(conn, isExcept);
        }
    }
}

