/*
 * Decompiled with CFR 0.152.
 */
package com.armadio.wormholes.gen;

import com.armadio.wormholes.ModItemsBlocks;
import com.armadio.wormholes.lib.Configurations;
import com.armadio.wormholes.tileentity.TileEntityWormhole;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class WormHoleWorldGen
implements IWorldGenerator {
    public void generate(Random random, int xChunk, int zChunk, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (random.nextDouble() < Configurations.probability) {
            int x1 = xChunk * 16 + random.nextInt(16);
            int z1 = zChunk * 16 + random.nextInt(16);
            int y1 = 10 + random.nextInt(240);
            int x2 = x1 + (random.nextBoolean() ? -1 : 1) * (random.nextInt(10000) + 5000);
            int y2 = 10 + random.nextInt(240);
            int z2 = z1 + (random.nextBoolean() ? -1 : 1) * (random.nextInt(10000) + 5000);
            this.structure(world, x1, y1, z1);
            this.structure(world, x2, y2, z2);
            this.setCoord(world, x1, y1, z1, x2, y2, z2);
            this.setCoord(world, x2, y2, z2, x1, y1, z1);
        }
    }

    private void setCoord(World world, int x1, int y1, int z1, int x2, int y2, int z2) {
        TileEntityWormhole tileEntityWormhole = (TileEntityWormhole)world.func_147438_o(x1, y1, z1);
        tileEntityWormhole.x = x2;
        tileEntityWormhole.y = y2;
        tileEntityWormhole.z = z2;
    }

    private void structure(World world, int xW, int yW, int zW) {
        int j;
        int i;
        Block air = Blocks.field_150350_a;
        Block wormhole = ModItemsBlocks.wormhole;
        Block dust = ModItemsBlocks.dust;
        for (i = -1; i < 2; ++i) {
            for (j = -1; j < 2; ++j) {
                world.func_147449_b(xW + i, yW + 2, zW + j, dust);
                world.func_147449_b(xW + i, yW - 4, zW + j, dust);
            }
        }
        for (i = -2; i < 3; ++i) {
            for (j = -2; j < 3; ++j) {
                if (Math.abs(i) == 2 || Math.abs(j) == 2) {
                    world.func_147449_b(xW + i, yW + 1, zW + j, dust);
                    world.func_147449_b(xW + i, yW - 3, zW + j, dust);
                    continue;
                }
                world.func_147449_b(xW + i, yW + 1, zW + j, air);
                world.func_147449_b(xW + i, yW - 3, zW + j, air);
            }
        }
        for (i = -3; i < 4; ++i) {
            for (j = -3; j < 4; ++j) {
                for (int k = 0; k > -3; --k) {
                    if (i == j && j == k && k == 0) {
                        world.func_147449_b(xW, yW, zW, wormhole);
                        continue;
                    }
                    if (Math.abs(i) == 3 ^ Math.abs(j) == 3) {
                        world.func_147449_b(xW + i, yW + k, zW + j, dust);
                        continue;
                    }
                    if (Math.abs(i) == 3 && Math.abs(j) == 3) continue;
                    world.func_147449_b(xW + i, yW + k, zW + j, air);
                }
            }
        }
    }
}

