local assets=
{ 
    Asset("ANIM", "anim/osk.zip"),
    Asset("ANIM", "anim/swap_osk.zip"), 
	Asset("SOUND", "sound/common.fsb"),

    Asset("ATLAS", "images/inventoryimages/osk.xml"),
    Asset("IMAGE", "images/inventoryimages/osk.tex"),
}
local prefabs =
{
	"nightstickfire",
}

local function onattack_aoe(inst, attacker, target)
    local atkfx = SpawnPrefab("explode_small")
    if atkfx then
	    local follower = atkfx.entity:AddFollower()
	    follower:FollowSymbol(target.GUID, target.components.combat.hiteffectsymbol, 0, 0, 0 )
	end

    if not target:IsValid() then
        return
    end

    if target.components.sleeper ~= nil and target.components.sleeper:IsAsleep() then
        target.components.sleeper:WakeUp()
    end

    if target.components.burnable ~= nil then
        if target.components.burnable:IsBurning() then
            target.components.burnable:Extinguish()
        elseif target.components.burnable:IsSmoldering() then
            target.components.burnable:SmotherSmolder()
        end
    end

    if target.components.combat ~= nil then
        target.components.combat:SuggestTarget(attacker)
    end

    if target.sg ~= nil and not target.sg:HasStateTag("frozen") then
        target:PushEvent("attacked", { attacker = attacker, damage = 0 })
    end

    if target.components.freezable ~= nil then
        target.components.freezable:AddColdness(1)
        target.components.freezable:SpawnShatterFX()
    end

    if attacker and attacker.components.health and attacker.components.hunger then
	attacker.components.hunger:DoDelta(0)
        attacker.components.health:DoDelta(0)
    end
end    

local function onequip(inst, owner)
    owner.components.combat:SetAreaDamage(1.5, 1) 
    inst.components.burnable:Ignite()
    owner.AnimState:OverrideSymbol("swap_object", "swap_osk", "swap_ham_bat")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
    
    inst.SoundEmitter:PlaySound("dontstarve_DLC001/common/morningstar", "torch")

    inst.fire = SpawnPrefab( "nightstickfire" )
    local follower = inst.fire.entity:AddFollower()
    follower:FollowSymbol( owner.GUID, "swap_object", 0, -110, 1 )
 
end
local function onunequip(inst,owner) 
    owner.components.combat:SetAreaDamage(nil, nil)
	inst.fire:Remove()
    inst.fire = nil
    
    inst.components.burnable:Extinguish()
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal")
    inst.SoundEmitter:KillSound("torch")
end

local function item_oneaten(inst, eater)

    if eater.wormlight then
        eater.wormlight.components.spell.lifetime = 0
        eater.wormlight.components.spell:ResumeSpell()
    else
        local light = SpawnPrefab("wormlight_light")
        light.components.spell:SetTarget(eater)
        if not light.components.spell.target then
            light:Remove()
        end
        light.components.spell:StartSpell()
    end
end

local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    local sound = inst.entity:AddSoundEmitter()
    anim:SetBank("osk")
    anim:SetBuild("osk")
    anim:PlayAnimation("idle")
    MakeInventoryPhysics(inst)
	inst.entity:AddNetwork()
	
	if not TheWorld.ismastersim then
		return inst
	end
	

	inst.entity:AddLight()
    inst.Light:Enable(true)
    inst.Light:SetIntensity(.75)
    inst.Light:SetColour(252/255,251/255,237/255)
    inst.Light:SetFalloff( 0.6 )
    inst.Light:SetRadius( 4 )

    inst:AddComponent("tool")
    inst.components.tool:SetAction(ACTIONS.MINE, 1)
    inst.components.tool:SetAction(ACTIONS.CHOP, 3)
    inst:AddComponent("blinkstaff")
	
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(60)
    inst.components.weapon:SetRange(8, 10)
    inst.components.weapon:SetOnAttack(onattack_aoe)
    inst.components.weapon:SetProjectile("ice_projectile")
    
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/osk.xml"
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnPocket( function(owner) inst.components.burnable:Extinguish()  end)
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
    inst.components.equippable.walkspeedmult = TUNING.CANE_SPEED_MULT
  
    inst:AddComponent("inspectable")
 
    inst:AddComponent("burnable")
    inst.components.burnable.canlight = false
    inst.components.burnable.fxprefab = nil
   
    return inst
end

return Prefab( "common/inventory/osk", fn, assets, prefabs) 