/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.gtk;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.CommonDialogs;
import com.sun.glass.ui.Cursor;
import com.sun.glass.ui.InvokeLaterDispatcher;
import com.sun.glass.ui.Launchable;
import com.sun.glass.ui.Pen;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Robot;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.Size;
import com.sun.glass.ui.Timer;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.glass.ui.gtk.GtkChildWindow;
import com.sun.glass.ui.gtk.GtkCommonDialogs;
import com.sun.glass.ui.gtk.GtkCursor;
import com.sun.glass.ui.gtk.GtkPixels;
import com.sun.glass.ui.gtk.GtkRobot;
import com.sun.glass.ui.gtk.GtkTimer;
import com.sun.glass.ui.gtk.GtkView;
import com.sun.glass.ui.gtk.GtkWindow;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GtkApplication
extends Application
implements InvokeLaterDispatcher.InvokeLaterSubmitter {
    public static int screen = -1;
    public static long display = 0L;
    public static long visualID = 0L;
    private final InvokeLaterDispatcher invokeLaterDispatcher = new InvokeLaterDispatcher(this);
    private Object eventLoopExitEnterPassValue;

    public GtkApplication() {
        this.invokeLaterDispatcher.start();
    }

    private void initDisplay() {
        Map map = GtkApplication.getDeviceDetails();
        if (map != null) {
            Object v = map.get("XDisplay");
            if (v != null) {
                display = (Long)v;
            }
            if ((v = map.get("XVisualID")) != null) {
                visualID = (Long)v;
            }
            if ((v = map.get("XScreenID")) != null) {
                screen = (Integer)v;
            }
        }
    }

    private void init() {
        this.initDisplay();
        long l = 0L;
        Map map = GtkApplication.getDeviceDetails();
        if (map != null) {
            Long l2 = (Long)map.get("javafx.embed.eventProc");
            l = l2 == null ? 0L : l2;
        }
        this._init(l);
    }

    @Override
    protected void runLoop(final String[] stringArray, final Launchable launchable) {
        boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Boolean.getBoolean("javafx.embed.isEventThread");
            }
        });
        final boolean bl2 = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Boolean.getBoolean("javafx.macosx.embedded");
            }
        });
        if (bl) {
            this.init();
            this.setEventThread(Thread.currentThread());
            launchable.finishLaunching(stringArray);
            return;
        }
        Thread thread = AccessController.doPrivileged(new PrivilegedAction<Thread>(){

            @Override
            public Thread run() {
                Thread thread = new Thread(new Runnable(){

                    public void run() {
                        GtkApplication.this.init();
                        GtkApplication.this._runLoop(stringArray, launchable, bl2);
                    }
                }, "GtkNativeMainLoopThread");
                return thread;
            }
        });
        this.setEventThread(thread);
        thread.start();
    }

    @Override
    protected void finishTerminating() {
        Thread thread = this.getEventThread();
        if (thread != null) {
            this._terminateLoop();
            this.setEventThread(null);
        }
        super.finishTerminating();
    }

    @Override
    public boolean shouldUpdateWindow() {
        return true;
    }

    private native void _terminateLoop();

    private native void _init(long var1);

    protected native void _runLoop(String[] var1, Launchable var2, boolean var3);

    @Override
    protected native void _invokeAndWait(Runnable var1);

    @Override
    public native void submitForLaterInvocation(Runnable var1);

    @Override
    protected void _invokeLater(Runnable runnable) {
        this.invokeLaterDispatcher.invokeLater(runnable);
    }

    @Override
    protected void _postOnEventQueue(Runnable runnable) {
        this._invokeLater(runnable);
    }

    private native void enterNestedEventLoopImpl();

    private native void leaveNestedEventLoopImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object _enterNestedEventLoop() {
        this.invokeLaterDispatcher.notifyEnteringNestedEventLoop();
        try {
            this.enterNestedEventLoopImpl();
            Object object = this.eventLoopExitEnterPassValue;
            this.eventLoopExitEnterPassValue = null;
            Object object2 = object;
            return object2;
        }
        finally {
            this.invokeLaterDispatcher.notifyLeftNestedEventLoop();
        }
    }

    @Override
    protected void _leaveNestedEventLoop(Object object) {
        this.invokeLaterDispatcher.notifyLeavingNestedEventLoop();
        this.eventLoopExitEnterPassValue = object;
        this.leaveNestedEventLoopImpl();
    }

    @Override
    public Window createWindow(Window window, Screen screen, int n) {
        return new GtkWindow(window, screen, n);
    }

    @Override
    public Window createWindow(long l) {
        return new GtkChildWindow(l);
    }

    @Override
    public View createView(Pen pen) {
        return new GtkView(pen);
    }

    @Override
    public Cursor createCursor(int n) {
        return new GtkCursor(n);
    }

    @Override
    public Cursor createCursor(int n, int n2, Pixels pixels) {
        return new GtkCursor(n, n2, pixels);
    }

    @Override
    protected void staticCursor_setVisible(boolean bl) {
    }

    @Override
    protected Size staticCursor_getBestSize(int n, int n2) {
        return GtkCursor._getBestSize(n, n2);
    }

    @Override
    public Pixels createPixels(int n, int n2, ByteBuffer byteBuffer) {
        return new GtkPixels(n, n2, byteBuffer);
    }

    @Override
    public Pixels createPixels(int n, int n2, IntBuffer intBuffer) {
        return new GtkPixels(n, n2, intBuffer);
    }

    @Override
    public Pixels createPixels(int n, int n2, IntBuffer intBuffer, float f) {
        return new GtkPixels(n, n2, intBuffer, f);
    }

    @Override
    protected int staticPixels_getNativeFormat() {
        return 1;
    }

    @Override
    public Robot createRobot() {
        return new GtkRobot();
    }

    @Override
    protected Screen staticScreen_getDeepestScreen() {
        List<Screen> list = this.staticScreen_getScreens();
        Screen screen = list.get(0);
        int n = list.size();
        for (int i = 1; i < n; ++i) {
            if (screen.getDepth() >= list.get(i).getDepth()) continue;
            screen = list.get(i);
        }
        return screen;
    }

    @Override
    protected Screen staticScreen_getMainScreen() {
        List<Screen> list = this.staticScreen_getScreens();
        return list.get(0);
    }

    @Override
    protected Screen staticScreen_getScreenForLocation(int n, int n2) {
        List<Screen> list = this.staticScreen_getScreens();
        for (Screen screen : list) {
            if (n < screen.getX() || n > screen.getWidth() + screen.getX() || n2 < screen.getY() || n2 > screen.getHeight() + screen.getY()) continue;
            return screen;
        }
        return null;
    }

    @Override
    protected Screen staticScreen_getScreenForPtr(long l) {
        List<Screen> list = this.staticScreen_getScreens();
        for (Screen screen : list) {
            if (screen.getNativeScreen() != l) continue;
            return screen;
        }
        return null;
    }

    @Override
    protected native List<Screen> staticScreen_getScreens();

    @Override
    public Timer createTimer(Runnable runnable) {
        return new GtkTimer(runnable);
    }

    @Override
    protected native int staticTimer_getMinPeriod();

    @Override
    protected native int staticTimer_getMaxPeriod();

    @Override
    protected List<File> staticCommonDialogs_showFileChooser(Window window, String string, String string2, String string3, int n, boolean bl, CommonDialogs.ExtensionFilter[] extensionFilterArray) {
        return GtkCommonDialogs.showFileChooser(window, string, string2, string3, n, bl, extensionFilterArray);
    }

    @Override
    protected File staticCommonDialogs_showFolderChooser(Window window, String string, String string2) {
        return GtkCommonDialogs.showFolderChooser(window, string, string2);
    }

    @Override
    protected native long staticView_getMultiClickTime();

    @Override
    protected native int staticView_getMultiClickMaxX();

    @Override
    protected native int staticView_getMultiClickMaxY();

    @Override
    public native boolean supportsTransparentWindows();
}

