/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui;

import com.sun.glass.ui.Clipboard;
import java.util.HashMap;

public class ClipboardAssistance {
    private final HashMap<String, Object> cacheData = new HashMap();
    private final Clipboard clipboard;
    private int supportedActions = 0x4FFFFFFF;

    public ClipboardAssistance(String string) {
        this.clipboard = Clipboard.get(string);
        this.clipboard.add(this);
    }

    public void close() {
        this.clipboard.remove(this);
    }

    public void flush() {
        this.clipboard.flush(this, this.cacheData, this.supportedActions);
    }

    public void emptyCache() {
        this.cacheData.clear();
    }

    public boolean isCacheEmpty() {
        return this.cacheData.isEmpty();
    }

    public void setData(String string, Object object) {
        this.cacheData.put(string, object);
    }

    public Object getData(String string) {
        return this.clipboard.getData(string);
    }

    public void setSupportedActions(int n) {
        this.supportedActions = n;
    }

    public int getSupportedSourceActions() {
        return this.clipboard.getSupportedSourceActions();
    }

    public void setTargetAction(int n) {
        this.clipboard.setTargetAction(n);
    }

    public void contentChanged() {
    }

    public void actionPerformed(int n) {
    }

    public String[] getMimeTypes() {
        return this.clipboard.getMimeTypes();
    }

    public String toString() {
        return "ClipboardAssistance[" + this.clipboard + "]";
    }

    public String dumpToString() {
        StringBuilder stringBuilder = new StringBuilder("{ClipboardAssistance[").append(this.clipboard.toString()).append("]");
        String[] stringArray = this.getMimeTypes();
        if (stringArray == null) {
            stringBuilder.append(" clipbard is empty");
        } else {
            for (String string : stringArray) {
                stringBuilder.append("\nmimeType:").append(string).append(" value:").append(this.getData(string));
            }
            stringBuilder.append("\n");
        }
        stringBuilder.append("}ClipboardAssistance");
        return stringBuilder.toString();
    }
}

