/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.bind.v2.model.impl;

import com.sun.xml.internal.bind.v2.model.core.MapPropertyInfo;
import com.sun.xml.internal.bind.v2.model.core.NonElement;
import com.sun.xml.internal.bind.v2.model.core.PropertyKind;
import com.sun.xml.internal.bind.v2.model.core.TypeInfo;
import com.sun.xml.internal.bind.v2.model.impl.ClassInfoImpl;
import com.sun.xml.internal.bind.v2.model.impl.PropertyInfoImpl;
import com.sun.xml.internal.bind.v2.model.impl.PropertySeed;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.namespace.QName;

class MapPropertyInfoImpl<T, C, F, M>
extends PropertyInfoImpl<T, C, F, M>
implements MapPropertyInfo<T, C> {
    private final QName xmlName;
    private boolean nil;
    private final T keyType;
    private final T valueType;
    private NonElement<T, C> keyTypeInfo;
    private NonElement<T, C> valueTypeInfo;

    public MapPropertyInfoImpl(ClassInfoImpl<T, C, F, M> classInfoImpl, PropertySeed<T, C, F, M> propertySeed) {
        super(classInfoImpl, propertySeed);
        XmlElementWrapper xmlElementWrapper = propertySeed.readAnnotation(XmlElementWrapper.class);
        this.xmlName = this.calcXmlName(xmlElementWrapper);
        this.nil = xmlElementWrapper != null && xmlElementWrapper.nillable();
        Object t = this.getRawType();
        Object t2 = this.nav().getBaseClass(t, this.nav().asDecl(Map.class));
        assert (t2 != null);
        if (this.nav().isParameterizedType(t2)) {
            this.keyType = this.nav().getTypeArgument(t2, 0);
            this.valueType = this.nav().getTypeArgument(t2, 1);
        } else {
            this.valueType = this.nav().ref(Object.class);
            this.keyType = this.valueType;
        }
    }

    @Override
    public Collection<? extends TypeInfo<T, C>> ref() {
        return Arrays.asList(this.getKeyType(), this.getValueType());
    }

    @Override
    public final PropertyKind kind() {
        return PropertyKind.MAP;
    }

    @Override
    public QName getXmlName() {
        return this.xmlName;
    }

    @Override
    public boolean isCollectionNillable() {
        return this.nil;
    }

    @Override
    public NonElement<T, C> getKeyType() {
        if (this.keyTypeInfo == null) {
            this.keyTypeInfo = this.getTarget(this.keyType);
        }
        return this.keyTypeInfo;
    }

    @Override
    public NonElement<T, C> getValueType() {
        if (this.valueTypeInfo == null) {
            this.valueTypeInfo = this.getTarget(this.valueType);
        }
        return this.valueTypeInfo;
    }

    public NonElement<T, C> getTarget(T t) {
        assert (this.parent.builder != null) : "this method must be called during the build stage";
        return this.parent.builder.getTypeInfo(t, this);
    }
}

