/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicMenuItemUI;

public class BaseMenuItemUI
extends BasicMenuItemUI {
    public static ComponentUI createUI(JComponent c) {
        return new BaseMenuItemUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        c.setOpaque(false);
    }

    public void uninstallUI(JComponent c) {
        c.setOpaque(true);
        super.uninstallUI(c);
    }

    public void update(Graphics g, JComponent c) {
        this.paintBackground(g, c, 0, 0, c.getWidth(), c.getHeight());
        this.paint(g, c);
    }

    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        if (menuItem.isOpaque()) {
            int w = menuItem.getWidth();
            int h = menuItem.getHeight();
            this.paintBackground(g, menuItem, 0, 0, w, h);
        }
    }

    protected void paintBackground(Graphics g, JComponent c, int x, int y, int w, int h) {
        ButtonModel model;
        JMenuItem mi = (JMenuItem)c;
        Color backColor = mi.getBackground();
        if (backColor == null || backColor instanceof UIResource) {
            backColor = AbstractLookAndFeel.getMenuBackgroundColor();
        }
        if ((model = mi.getModel()).isArmed() || model.isRollover() || c instanceof JMenu && model.isSelected()) {
            g.setColor(AbstractLookAndFeel.getMenuSelectionBackgroundColor());
            g.fillRect(x, y, w, h);
            g.setColor(AbstractLookAndFeel.getMenuSelectionForegroundColor());
        } else if (!AbstractLookAndFeel.getTheme().isMenuOpaque()) {
            Graphics2D g2D = (Graphics2D)g;
            Composite savedComposite = g2D.getComposite();
            AlphaComposite alpha = AlphaComposite.getInstance(3, AbstractLookAndFeel.getTheme().getMenuAlpha());
            g2D.setComposite(alpha);
            g2D.setColor(backColor);
            g2D.fillRect(x, y, w, h);
            g2D.setComposite(savedComposite);
            g.setColor(AbstractLookAndFeel.getMenuForegroundColor());
        } else {
            g.setColor(backColor);
            g.fillRect(x, y, w, h);
            g.setColor(AbstractLookAndFeel.getMenuForegroundColor());
        }
    }

    protected void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
        ButtonModel model = menuItem.getModel();
        Color foreColor = menuItem.getForeground();
        if (model.isArmed() || model.isRollover()) {
            foreColor = AbstractLookAndFeel.getMenuSelectionForegroundColor();
        } else if (foreColor == null || foreColor instanceof UIResource) {
            foreColor = AbstractLookAndFeel.getMenuForegroundColor();
        }
        Graphics2D g2D = (Graphics2D)g;
        Object savedRenderingHint = null;
        if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
            savedRenderingHint = g2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AbstractLookAndFeel.getTheme().getTextAntiAliasingHint());
        }
        g2D.setColor(foreColor);
        super.paintText(g, menuItem, textRect, text);
        if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
            g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, savedRenderingHint);
        }
    }
}

