/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.LazyImageIcon;
import com.jtattoo.plaf.LazyMenuArrowImageIcon;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class BaseIcons {
    public static final LazyImageIcon PEARL_RED_SMALL = new LazyImageIcon("icons/small/pearl_red_24x24.png");
    public static final LazyImageIcon PEARL_YELLOW_SMALL = new LazyImageIcon("icons/small/pearl_yellow_24x24.png");
    public static final LazyImageIcon PEARL_GREEN_SMALL = new LazyImageIcon("icons/small/pearl_green_24x24.png");
    public static final LazyImageIcon PEARL_GREY_SMALL = new LazyImageIcon("icons/small/pearl_grey_24x24.png");
    public static final LazyImageIcon PEARL_RED_MEDIUM = new LazyImageIcon("icons/medium/pearl_red_28x28.png");
    public static final LazyImageIcon PEARL_YELLOW_MEDIUM = new LazyImageIcon("icons/medium/pearl_yellow_28x28.png");
    public static final LazyImageIcon PEARL_GREEN_MEDIUM = new LazyImageIcon("icons/medium/pearl_green_28x28.png");
    public static final LazyImageIcon PEARL_GREY_MEDIUM = new LazyImageIcon("icons/medium/pearl_grey_28x28.png");
    public static final LazyImageIcon PEARL_RED_LARGE = new LazyImageIcon("icons/large/pearl_red_32x32.png");
    public static final LazyImageIcon PEARL_YELLOW_LARGE = new LazyImageIcon("icons/large/pearl_yellow_32x32.png");
    public static final LazyImageIcon PEARL_GREEN_LARGE = new LazyImageIcon("icons/large/pearl_green_32x32.png");
    public static final LazyImageIcon PEARL_GREY_LARGE = new LazyImageIcon("icons/large/pearl_grey_32x32.png");
    public static final LazyImageIcon ICONIZER_SMALL = new LazyImageIcon("icons/small/iconizer_10x10.png");
    public static final LazyImageIcon MINIMIZER_SMALL = new LazyImageIcon("icons/small/minimizer_10x10.png");
    public static final LazyImageIcon MAXIMIZER_SMALL = new LazyImageIcon("icons/small/maximizer_10x10.png");
    public static final LazyImageIcon CLOSER_SMALL = new LazyImageIcon("icons/small/closer_10x10.png");
    public static final LazyImageIcon ICONIZER_MEDIUM = new LazyImageIcon("icons/medium/iconizer_12x12.png");
    public static final LazyImageIcon MINIMIZER_MEDIUM = new LazyImageIcon("icons/medium/minimizer_12x12.png");
    public static final LazyImageIcon MAXIMIZER_MEDIUM = new LazyImageIcon("icons/medium/maximizer_12x12.png");
    public static final LazyImageIcon CLOSER_MEDIUM = new LazyImageIcon("icons/medium/closer_12x12.png");
    public static final LazyImageIcon ICONIZER_LARGE = new LazyImageIcon("icons/large/iconizer_12x12.png");
    public static final LazyImageIcon MINIMIZER_LARGE = new LazyImageIcon("icons/large/minimizer_12x12.png");
    public static final LazyImageIcon MAXIMIZER_LARGE = new LazyImageIcon("icons/large/maximizer_12x12.png");
    public static final LazyImageIcon CLOSER_LARGE = new LazyImageIcon("icons/large/closer_12x12.png");
    public static final LazyImageIcon EMPTY_8x8 = new LazyImageIcon("icons/empty_8x8.png");
    protected static Icon checkBoxIcon = null;
    protected static Icon menuCheckBoxIcon = null;
    protected static Icon radioButtonIcon = null;
    protected static Icon menuRadioButtonIcon = null;
    protected static Icon optionPaneErrorIcon = null;
    protected static Icon optionPaneWarningIcon = null;
    protected static Icon optionPaneInformationIcon = null;
    protected static Icon optionPaneQuestionIcon = null;
    protected static Icon fileChooserUpFolderIcon = null;
    protected static Icon fileChooserHomeFolderIcon = null;
    protected static Icon fileChooserNewFolderIcon = null;
    protected static Icon fileChooserListViewIcon = null;
    protected static Icon fileChooserDetailViewIcon = null;
    protected static Icon fileViewComputerIcon = null;
    protected static Icon fileViewFloppyDriveIcon = null;
    protected static Icon fileViewHardDriveIcon = null;
    protected static Icon treeOpenedIcon = null;
    protected static Icon treeClosedIcon = null;
    protected static Icon treeLeafIcon = null;
    protected static Icon treeExpandedIcon = null;
    protected static Icon treeCollapsedIcon = null;
    protected static Icon paletteCloseIcon = null;
    protected static Icon menuIcon = null;
    protected static Icon iconIcon = null;
    protected static Icon maxIcon = null;
    protected static Icon minIcon = null;
    protected static Icon closeIcon = null;
    protected static Icon upArrowIcon = null;
    protected static Icon upArrowInverseIcon = null;
    protected static Icon downArrowIcon = null;
    protected static Icon downArrowInverseIcon = null;
    protected static Icon leftArrowIcon = null;
    protected static Icon leftArrowInverseIcon = null;
    protected static Icon rightArrowIcon = null;
    protected static Icon rightArrowInverseIcon = null;
    protected static Icon menuArrowIcon = null;
    protected static Icon splitterUpArrowIcon = null;
    protected static Icon splitterDownArrowIcon = null;
    protected static Icon splitterLeftArrowIcon = null;
    protected static Icon splitterRightArrowIcon = null;
    protected static Icon splitterHorBumpIcon = null;
    protected static Icon splitterVerBumpIcon = null;
    protected static Icon thumbHorIcon = null;
    protected static Icon thumbVerIcon = null;
    protected static Icon thumbHorIconRollover = null;
    protected static Icon thumbVerIconRollover = null;

    public static void initDefaults() {
        checkBoxIcon = null;
        menuCheckBoxIcon = null;
        radioButtonIcon = null;
        menuRadioButtonIcon = null;
        optionPaneErrorIcon = null;
        optionPaneWarningIcon = null;
        optionPaneInformationIcon = null;
        optionPaneQuestionIcon = null;
        fileChooserUpFolderIcon = null;
        fileChooserHomeFolderIcon = null;
        fileChooserNewFolderIcon = null;
        fileChooserListViewIcon = null;
        fileChooserDetailViewIcon = null;
        fileViewComputerIcon = null;
        fileViewFloppyDriveIcon = null;
        fileViewHardDriveIcon = null;
        treeOpenedIcon = null;
        treeClosedIcon = null;
        treeLeafIcon = null;
        treeExpandedIcon = null;
        treeCollapsedIcon = null;
        paletteCloseIcon = null;
        menuIcon = null;
        iconIcon = null;
        maxIcon = null;
        minIcon = null;
        closeIcon = null;
        upArrowIcon = null;
        upArrowInverseIcon = null;
        downArrowIcon = null;
        downArrowInverseIcon = null;
        leftArrowIcon = null;
        leftArrowInverseIcon = null;
        rightArrowIcon = null;
        rightArrowInverseIcon = null;
        menuArrowIcon = null;
        splitterUpArrowIcon = null;
        splitterDownArrowIcon = null;
        splitterLeftArrowIcon = null;
        splitterRightArrowIcon = null;
        splitterHorBumpIcon = null;
        splitterVerBumpIcon = null;
        thumbHorIcon = null;
        thumbVerIcon = null;
        thumbHorIconRollover = null;
        thumbVerIconRollover = null;
    }

    public static Icon getRadioButtonIcon() {
        if (radioButtonIcon == null) {
            radioButtonIcon = new RadioButtonIcon();
        }
        return radioButtonIcon;
    }

    public static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new CheckBoxIcon();
        }
        return checkBoxIcon;
    }

    public static Icon getComboBoxIcon() {
        return BaseIcons.getDownArrowIcon();
    }

    public static Icon getComboBoxInverseIcon() {
        return BaseIcons.getDownArrowInverseIcon();
    }

    public static Icon getOptionPaneErrorIcon() {
        if (optionPaneErrorIcon == null) {
            optionPaneErrorIcon = AbstractLookAndFeel.getTheme().isSmallFontSize() ? new LazyImageIcon("icons/medium/error_32x32.png") : (AbstractLookAndFeel.getTheme().isMediumFontSize() ? new LazyImageIcon("icons/medium/error_32x32.png") : new LazyImageIcon("icons/large/error_48x48.png"));
        }
        return optionPaneErrorIcon;
    }

    public static Icon getOptionPaneWarningIcon() {
        if (optionPaneWarningIcon == null) {
            optionPaneWarningIcon = AbstractLookAndFeel.getTheme().isSmallFontSize() ? new LazyImageIcon("icons/medium/warning_32x32.png") : (AbstractLookAndFeel.getTheme().isMediumFontSize() ? new LazyImageIcon("icons/medium/warning_32x32.png") : new LazyImageIcon("icons/large/warning_48x48.png"));
        }
        return optionPaneWarningIcon;
    }

    public static Icon getOptionPaneInformationIcon() {
        if (optionPaneInformationIcon == null) {
            optionPaneInformationIcon = AbstractLookAndFeel.getTheme().isSmallFontSize() ? new LazyImageIcon("icons/medium/information_32x32.png") : (AbstractLookAndFeel.getTheme().isMediumFontSize() ? new LazyImageIcon("icons/medium/information_32x32.png") : new LazyImageIcon("icons/large/information_48x48.png"));
        }
        return optionPaneInformationIcon;
    }

    public static Icon getOptionPaneQuestionIcon() {
        if (optionPaneQuestionIcon == null) {
            optionPaneQuestionIcon = AbstractLookAndFeel.getTheme().isSmallFontSize() ? new LazyImageIcon("icons/medium/question_32x32.png") : (AbstractLookAndFeel.getTheme().isMediumFontSize() ? new LazyImageIcon("icons/medium/question_32x32.png") : new LazyImageIcon("icons/large/question_48x48.png"));
        }
        return optionPaneQuestionIcon;
    }

    public static Icon getFileChooserUpFolderIcon() {
        if (fileChooserUpFolderIcon == null) {
            fileChooserUpFolderIcon = new LazyImageIcon("icons/folder_up_22x22.png");
        }
        return fileChooserUpFolderIcon;
    }

    public static Icon getFileChooserHomeFolderIcon() {
        if (fileChooserHomeFolderIcon == null) {
            fileChooserHomeFolderIcon = new LazyImageIcon("icons/home_22x22.png");
        }
        return fileChooserHomeFolderIcon;
    }

    public static Icon getFileChooserNewFolderIcon() {
        if (fileChooserNewFolderIcon == null) {
            fileChooserNewFolderIcon = new LazyImageIcon("icons/folder_new_22x22.png");
        }
        return fileChooserNewFolderIcon;
    }

    public static Icon getFileChooserListViewIcon() {
        if (fileChooserListViewIcon == null) {
            fileChooserListViewIcon = new LazyImageIcon("icons/view_list_22x22.png");
        }
        return fileChooserListViewIcon;
    }

    public static Icon getFileChooserDetailViewIcon() {
        if (fileChooserDetailViewIcon == null) {
            fileChooserDetailViewIcon = new LazyImageIcon("icons/view_detail_22x22.png");
        }
        return fileChooserDetailViewIcon;
    }

    public static Icon getFileViewComputerIcon() {
        if (fileViewComputerIcon == null) {
            fileViewComputerIcon = new LazyImageIcon("icons/computer_16x16.png");
        }
        return fileViewComputerIcon;
    }

    public static Icon getFileViewFloppyDriveIcon() {
        if (fileViewFloppyDriveIcon == null) {
            fileViewFloppyDriveIcon = new LazyImageIcon("icons/floppy_drive_16x16.png");
        }
        return fileViewFloppyDriveIcon;
    }

    public static Icon getFileViewHardDriveIcon() {
        if (fileViewHardDriveIcon == null) {
            fileViewHardDriveIcon = new LazyImageIcon("icons/hard_drive_16x16.png");
        }
        return fileViewHardDriveIcon;
    }

    public static Icon getTreeOpenedIcon() {
        if (treeOpenedIcon == null) {
            treeOpenedIcon = AbstractLookAndFeel.getTheme().isSmallFontSize() ? new LazyImageIcon("icons/small/folder_opened_16x16.png") : (AbstractLookAndFeel.getTheme().isMediumFontSize() ? new LazyImageIcon("icons/medium/folder_opened_20x20.png") : new LazyImageIcon("icons/large/folder_opened_24x24.png"));
        }
        return treeOpenedIcon;
    }

    public static Icon getTreeClosedIcon() {
        if (treeClosedIcon == null) {
            treeClosedIcon = AbstractLookAndFeel.getTheme().isSmallFontSize() ? new LazyImageIcon("icons/small/folder_closed_16x16.png") : (AbstractLookAndFeel.getTheme().isMediumFontSize() ? new LazyImageIcon("icons/medium/folder_closed_20x20.png") : new LazyImageIcon("icons/large/folder_closed_24x24.png"));
        }
        return treeClosedIcon;
    }

    public static Icon getTreeLeafIcon() {
        if (treeLeafIcon == null) {
            treeLeafIcon = AbstractLookAndFeel.getTheme().isSmallFontSize() ? new LazyImageIcon("icons/small/document_16x16.png") : (AbstractLookAndFeel.getTheme().isMediumFontSize() ? new LazyImageIcon("icons/medium/document_20x20.png") : new LazyImageIcon("icons/large/document_24x24.png"));
        }
        return treeLeafIcon;
    }

    public static Icon getTreeCollapsedIcon() {
        if (treeCollapsedIcon == null) {
            treeCollapsedIcon = AbstractLookAndFeel.getTheme().isSmallFontSize() ? new LazyImageIcon("icons/small/tree_collapsed_9x9.png") : (AbstractLookAndFeel.getTheme().isMediumFontSize() ? new LazyImageIcon("icons/medium/tree_collapsed_11x11.png") : new LazyImageIcon("icons/large/tree_collapsed_14x14.png"));
        }
        return treeCollapsedIcon;
    }

    public static Icon getTreeExpandedIcon() {
        if (treeExpandedIcon == null) {
            treeExpandedIcon = AbstractLookAndFeel.getTheme().isSmallFontSize() ? new LazyImageIcon("icons/small/tree_expanded_9x9.png") : (AbstractLookAndFeel.getTheme().isMediumFontSize() ? new LazyImageIcon("icons/medium/tree_expanded_11x11.png") : new LazyImageIcon("icons/large/tree_expanded_14x14.png"));
        }
        return treeExpandedIcon;
    }

    public static Icon getMenuIcon() {
        if (menuIcon == null) {
            menuIcon = AbstractLookAndFeel.getTheme().isSmallFontSize() ? new LazyImageIcon("icons/small/cup_16x16.png") : (AbstractLookAndFeel.getTheme().isMediumFontSize() ? new LazyImageIcon("icons/medium/cup_20x20.png") : new LazyImageIcon("icons/large/cup_24x24.png"));
        }
        return menuIcon;
    }

    public static Icon getIconIcon() {
        if (iconIcon == null) {
            if (AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn()) {
                iconIcon = new MacIconIcon();
            } else {
                ColorUIResource iconColor = AbstractLookAndFeel.getTheme().getWindowIconColor();
                ColorUIResource iconRolloverColor = AbstractLookAndFeel.getTheme().getWindowIconRolloverColor();
                iconIcon = new IconSymbol(iconColor, null, iconRolloverColor);
            }
        }
        return iconIcon;
    }

    public static Icon getMaxIcon() {
        if (maxIcon == null) {
            if (AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn()) {
                maxIcon = new MacMaxIcon();
            } else {
                ColorUIResource iconColor = AbstractLookAndFeel.getTheme().getWindowIconColor();
                ColorUIResource iconRolloverColor = AbstractLookAndFeel.getTheme().getWindowIconRolloverColor();
                maxIcon = new MaxSymbol(iconColor, null, iconRolloverColor);
            }
        }
        return maxIcon;
    }

    public static Icon getMinIcon() {
        if (minIcon == null) {
            if (AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn()) {
                minIcon = new MacMinIcon();
            } else {
                ColorUIResource iconColor = AbstractLookAndFeel.getTheme().getWindowIconColor();
                ColorUIResource iconRolloverColor = AbstractLookAndFeel.getTheme().getWindowIconRolloverColor();
                minIcon = new MinSymbol(iconColor, null, iconRolloverColor);
            }
        }
        return minIcon;
    }

    public static Icon getCloseIcon() {
        if (closeIcon == null) {
            if (AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn()) {
                closeIcon = new MacCloseIcon();
            } else {
                ColorUIResource iconColor = AbstractLookAndFeel.getTheme().getWindowIconColor();
                ColorUIResource iconRolloverColor = AbstractLookAndFeel.getTheme().getWindowIconRolloverColor();
                closeIcon = new CloseSymbol(iconColor, null, iconRolloverColor);
            }
        }
        return closeIcon;
    }

    public static Icon getPaletteCloseIcon() {
        if (paletteCloseIcon == null) {
            paletteCloseIcon = new CloseSymbol(Color.black, null, Color.red);
        }
        return paletteCloseIcon;
    }

    public static Icon getMenuArrowIcon() {
        if (menuArrowIcon == null) {
            menuArrowIcon = new LazyMenuArrowImageIcon("icons/MenuRightArrow.gif", "icons/MenuLeftArrow.gif");
        }
        return menuArrowIcon;
    }

    public static Icon getMenuCheckBoxIcon() {
        if (menuCheckBoxIcon == null) {
            menuCheckBoxIcon = new CheckBoxIcon();
        }
        return menuCheckBoxIcon;
    }

    public static Icon getMenuRadioButtonIcon() {
        if (menuRadioButtonIcon == null) {
            menuRadioButtonIcon = new RadioButtonIcon();
        }
        return menuRadioButtonIcon;
    }

    public static Icon getUpArrowIcon() {
        if (upArrowIcon == null) {
            upArrowIcon = AbstractLookAndFeel.getTheme().isSmallFontSize() ? new LazyImageIcon("icons/small/arrow_up_7x4.png") : (AbstractLookAndFeel.getTheme().isMediumFontSize() ? new LazyImageIcon("icons/medium/arrow_up_9x6.png") : new LazyImageIcon("icons/large/arrow_up_11x8.png"));
        }
        return upArrowIcon;
    }

    public static Icon getUpArrowInverseIcon() {
        if (upArrowInverseIcon == null) {
            upArrowInverseIcon = AbstractLookAndFeel.getTheme().isSmallFontSize() ? new LazyImageIcon("icons/small/arrow_up_inverse_7x4.png") : (AbstractLookAndFeel.getTheme().isMediumFontSize() ? new LazyImageIcon("icons/medium/arrow_up_inverse_9x6.png") : new LazyImageIcon("icons/large/arrow_up_inverse_11x8.png"));
        }
        return upArrowInverseIcon;
    }

    public static Icon getDownArrowIcon() {
        if (downArrowIcon == null) {
            downArrowIcon = AbstractLookAndFeel.getTheme().isSmallFontSize() ? new LazyImageIcon("icons/small/arrow_down_7x4.png") : (AbstractLookAndFeel.getTheme().isMediumFontSize() ? new LazyImageIcon("icons/medium/arrow_down_9x6.png") : new LazyImageIcon("icons/large/arrow_down_11x8.png"));
        }
        return downArrowIcon;
    }

    public static Icon getDownArrowInverseIcon() {
        if (downArrowInverseIcon == null) {
            downArrowInverseIcon = AbstractLookAndFeel.getTheme().isSmallFontSize() ? new LazyImageIcon("icons/small/arrow_down_inverse_7x4.png") : (AbstractLookAndFeel.getTheme().isMediumFontSize() ? new LazyImageIcon("icons/medium/arrow_down_inverse_9x6.png") : new LazyImageIcon("icons/large/arrow_down_inverse_11x8.png"));
        }
        return downArrowInverseIcon;
    }

    public static Icon getLeftArrowIcon() {
        if (leftArrowIcon == null) {
            leftArrowIcon = AbstractLookAndFeel.getTheme().isSmallFontSize() ? new LazyImageIcon("icons/small/arrow_left_4x7.png") : (AbstractLookAndFeel.getTheme().isMediumFontSize() ? new LazyImageIcon("icons/medium/arrow_left_6x9.png") : new LazyImageIcon("icons/large/arrow_left_8x11.png"));
        }
        return leftArrowIcon;
    }

    public static Icon getLeftArrowInverseIcon() {
        if (leftArrowInverseIcon == null) {
            leftArrowInverseIcon = AbstractLookAndFeel.getTheme().isSmallFontSize() ? new LazyImageIcon("icons/small/arrow_left_inverse_4x7.png") : (AbstractLookAndFeel.getTheme().isMediumFontSize() ? new LazyImageIcon("icons/medium/arrow_left_inverse_6x9.png") : new LazyImageIcon("icons/large/arrow_left_inverse_8x11.png"));
        }
        return leftArrowInverseIcon;
    }

    public static Icon getRightArrowIcon() {
        if (rightArrowIcon == null) {
            rightArrowIcon = AbstractLookAndFeel.getTheme().isSmallFontSize() ? new LazyImageIcon("icons/small/arrow_right_4x7.png") : (AbstractLookAndFeel.getTheme().isMediumFontSize() ? new LazyImageIcon("icons/medium/arrow_right_6x9.png") : new LazyImageIcon("icons/large/arrow_right_8x11.png"));
        }
        return rightArrowIcon;
    }

    public static Icon getRightArrowInverseIcon() {
        if (rightArrowInverseIcon == null) {
            rightArrowInverseIcon = AbstractLookAndFeel.getTheme().isSmallFontSize() ? new LazyImageIcon("icons/small/arrow_right_inverse_4x7.png") : (AbstractLookAndFeel.getTheme().isMediumFontSize() ? new LazyImageIcon("icons/medium/arrow_right_inverse_6x9.png") : new LazyImageIcon("icons/large/arrow_right_inverse_8x11.png"));
        }
        return rightArrowInverseIcon;
    }

    public static Icon getSplitterUpArrowIcon() {
        if (splitterUpArrowIcon == null) {
            splitterUpArrowIcon = new LazyImageIcon("icons/SplitterUpArrow.gif");
        }
        return splitterUpArrowIcon;
    }

    public static Icon getSplitterDownArrowIcon() {
        if (splitterDownArrowIcon == null) {
            splitterDownArrowIcon = new LazyImageIcon("icons/SplitterDownArrow.gif");
        }
        return splitterDownArrowIcon;
    }

    public static Icon getSplitterLeftArrowIcon() {
        if (splitterLeftArrowIcon == null) {
            splitterLeftArrowIcon = new LazyImageIcon("icons/SplitterLeftArrow.gif");
        }
        return splitterLeftArrowIcon;
    }

    public static Icon getSplitterRightArrowIcon() {
        if (splitterRightArrowIcon == null) {
            splitterRightArrowIcon = new LazyImageIcon("icons/SplitterRightArrow.gif");
        }
        return splitterRightArrowIcon;
    }

    public static Icon getSplitterHorBumpIcon() {
        if (splitterHorBumpIcon == null) {
            splitterHorBumpIcon = new LazyImageIcon("icons/SplitterHorBumps.gif");
        }
        return splitterHorBumpIcon;
    }

    public static Icon getSplitterVerBumpIcon() {
        if (splitterVerBumpIcon == null) {
            splitterVerBumpIcon = new LazyImageIcon("icons/SplitterVerBumps.gif");
        }
        return splitterVerBumpIcon;
    }

    public static Icon getThumbHorIcon() {
        if (thumbHorIcon == null) {
            thumbHorIcon = new LazyImageIcon("icons/thumb_hor.gif");
        }
        return thumbHorIcon;
    }

    public static Icon getThumbVerIcon() {
        if (thumbVerIcon == null) {
            thumbVerIcon = new LazyImageIcon("icons/thumb_ver.gif");
        }
        return thumbVerIcon;
    }

    public static Icon getThumbHorIconRollover() {
        if (thumbHorIconRollover == null) {
            thumbHorIconRollover = new LazyImageIcon("icons/thumb_hor_rollover.gif");
        }
        return thumbHorIconRollover;
    }

    public static Icon getThumbVerIconRollover() {
        if (thumbVerIconRollover == null) {
            thumbVerIconRollover = new LazyImageIcon("icons/thumb_ver_rollover.gif");
        }
        return thumbVerIconRollover;
    }

    public static class CloseSymbol
    implements Icon {
        private Color foregroundColor = null;
        private Color shadowColor = null;
        private Color rolloverColor = null;
        private Color inactiveForegroundColor = null;
        private Color inactiveShadowColor = null;
        private Insets insets = new Insets(0, 0, 0, 0);

        public CloseSymbol(Color foregroundColor, Color shadowColor, Color rolloverColor) {
            this.foregroundColor = foregroundColor;
            this.shadowColor = shadowColor;
            this.rolloverColor = rolloverColor;
            this.inactiveForegroundColor = foregroundColor;
            this.inactiveShadowColor = shadowColor;
        }

        public CloseSymbol(Color foregroundColor, Color shadowColor, Color rolloverColor, Insets insets) {
            this.foregroundColor = foregroundColor;
            this.shadowColor = shadowColor;
            this.rolloverColor = rolloverColor;
            this.insets = insets;
            this.inactiveForegroundColor = foregroundColor;
            this.inactiveShadowColor = shadowColor;
        }

        public CloseSymbol(Color foregroundColor, Color shadowColor, Color rolloverColor, Color inactiveForegroundColor, Color inactiveShadowColor, Insets insets) {
            this.foregroundColor = foregroundColor;
            this.shadowColor = shadowColor;
            this.rolloverColor = rolloverColor;
            this.inactiveForegroundColor = inactiveForegroundColor;
            this.inactiveShadowColor = inactiveShadowColor;
            this.insets = insets;
        }

        public int getIconHeight() {
            return 16;
        }

        public int getIconWidth() {
            return 16;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            int dx;
            Graphics2D g2D = (Graphics2D)g;
            g2D.translate(this.insets.left, this.insets.top);
            int w = c.getWidth() - this.insets.left - this.insets.right;
            int h = c.getHeight() - this.insets.top - this.insets.bottom;
            boolean active = JTattooUtilities.isActive((JComponent)c);
            Color color = this.foregroundColor;
            if (!active) {
                color = this.inactiveForegroundColor;
            }
            if (c instanceof AbstractButton && ((AbstractButton)c).getModel().isRollover() && this.rolloverColor != null) {
                color = this.rolloverColor;
            }
            int lw = h > 22 ? 3 : 2;
            int dy = dx = w / 5 + 2;
            Stroke savedStroke = g2D.getStroke();
            Object savedRederingHint = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2D.setStroke(new BasicStroke(lw, 1, 2));
            if (this.shadowColor != null) {
                if (!active) {
                    g2D.setColor(this.inactiveShadowColor);
                } else {
                    g2D.setColor(this.shadowColor);
                }
                g2D.drawLine(dx + 1, dy + 1, w - dx + 1, h - dy + 1);
                g2D.drawLine(w - dx + 1, dy + 1, dx + 1, h - dy + 1);
            }
            g2D.setColor(color);
            g2D.drawLine(dx, dy, w - dx, h - dy);
            g2D.drawLine(w - dx, dy, dx, h - dy);
            g2D.setStroke(savedStroke);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, savedRederingHint);
            g2D.translate(-this.insets.left, -this.insets.top);
        }
    }

    public static class MinSymbol
    implements Icon {
        private Color foregroundColor = null;
        private Color shadowColor = null;
        private Color rolloverColor = null;
        private Color inactiveForegroundColor = null;
        private Color inactiveShadowColor = null;
        private Insets insets = new Insets(0, 0, 0, 0);

        public MinSymbol(Color foregroundColor, Color shadowColor, Color rolloverColor) {
            this.foregroundColor = foregroundColor;
            this.shadowColor = shadowColor;
            this.rolloverColor = rolloverColor;
            this.inactiveForegroundColor = foregroundColor;
            this.inactiveShadowColor = shadowColor;
        }

        public MinSymbol(Color foregroundColor, Color shadowColor, Color rolloverColor, Insets insets) {
            this.foregroundColor = foregroundColor;
            this.shadowColor = shadowColor;
            this.rolloverColor = rolloverColor;
            this.inactiveForegroundColor = foregroundColor;
            this.inactiveShadowColor = shadowColor;
            this.insets = insets;
        }

        public MinSymbol(Color foregroundColor, Color shadowColor, Color rolloverColor, Color inactiveForegroundColor, Color inactiveShadowColor, Insets insets) {
            this.foregroundColor = foregroundColor;
            this.shadowColor = shadowColor;
            this.rolloverColor = rolloverColor;
            this.inactiveForegroundColor = inactiveForegroundColor;
            this.inactiveShadowColor = inactiveShadowColor;
            this.insets = insets;
        }

        public int getIconHeight() {
            return 16;
        }

        public int getIconWidth() {
            return 16;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2D = (Graphics2D)g;
            g2D.translate(this.insets.left, this.insets.top);
            int w = c.getWidth() - this.insets.left - this.insets.right;
            int h = c.getHeight() - this.insets.top - this.insets.bottom;
            int lw = h > 22 ? 2 : 1;
            int delta = w / 4;
            h = w = Math.min(w, h) - 6;
            int x1 = 3;
            int y1 = 3;
            int w1 = w - delta;
            int h1 = h - delta;
            int x2 = delta + 2;
            int y2 = Math.max(delta + 2, y1 + 2 * lw + 1);
            int w2 = w - delta;
            int h2 = h - delta;
            boolean active = JTattooUtilities.isActive((JComponent)c);
            Color ic = this.foregroundColor;
            Color sc = this.shadowColor;
            if (!active) {
                ic = this.inactiveForegroundColor;
                if (sc != null) {
                    sc = this.inactiveShadowColor;
                }
            }
            if (c instanceof AbstractButton && ((AbstractButton)c).getModel().isRollover() && this.rolloverColor != null) {
                ic = this.rolloverColor;
            }
            Shape savedClip = g2D.getClip();
            Stroke savedStroke = g2D.getStroke();
            g2D.setStroke(new BasicStroke(lw, 0, 0));
            Area clipArea = new Area(savedClip);
            clipArea.subtract(new Area(new Rectangle2D.Double(x2, y2, w2, h2)));
            g2D.setClip(clipArea);
            this.paintRect(g2D, x1, y1, w1, h1, lw, ic, sc);
            g2D.setClip(savedClip);
            this.paintRect(g2D, x2, y2, w2, h2, lw, ic, sc);
            g2D.setStroke(savedStroke);
            g2D.translate(-this.insets.left, -this.insets.top);
        }

        private void paintRect(Graphics2D g2D, int x, int y, int w, int h, int lw, Color iconColor, Color shadowColor) {
            if (shadowColor != null) {
                g2D.setColor(shadowColor);
                g2D.drawRect(x + 1, y + 1, w, h);
                g2D.drawLine(x + 1, y + lw + 1, x + w + 1, y + lw + 1);
            }
            g2D.setColor(iconColor);
            g2D.drawRect(x, y, w, h);
            g2D.drawLine(x, y + lw, x + w, y + lw);
        }
    }

    public static class MaxSymbol
    implements Icon {
        private Color foregroundColor = null;
        private Color shadowColor = null;
        private Color rolloverColor = null;
        private Color inactiveForegroundColor = null;
        private Color inactiveShadowColor = null;
        private Insets insets = new Insets(0, 0, 0, 0);

        public MaxSymbol(Color foregroundColor, Color shadowColor, Color rolloverColor) {
            this.foregroundColor = foregroundColor;
            this.shadowColor = shadowColor;
            this.rolloverColor = rolloverColor;
            this.inactiveForegroundColor = foregroundColor;
            this.inactiveShadowColor = shadowColor;
        }

        public MaxSymbol(Color foregroundColor, Color shadowColor, Color rolloverColor, Insets insets) {
            this.foregroundColor = foregroundColor;
            this.shadowColor = shadowColor;
            this.rolloverColor = rolloverColor;
            this.inactiveForegroundColor = foregroundColor;
            this.inactiveShadowColor = shadowColor;
            this.insets = insets;
        }

        public MaxSymbol(Color foregroundColor, Color shadowColor, Color rolloverColor, Color inactiveForegroundColor, Color inactiveShadowColor, Insets insets) {
            this.foregroundColor = foregroundColor;
            this.shadowColor = shadowColor;
            this.rolloverColor = rolloverColor;
            this.inactiveForegroundColor = inactiveForegroundColor;
            this.inactiveShadowColor = inactiveShadowColor;
            this.insets = insets;
        }

        public int getIconHeight() {
            return 16;
        }

        public int getIconWidth() {
            return 16;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2D = (Graphics2D)g;
            g2D.translate(this.insets.left, this.insets.top);
            int w = c.getWidth() - this.insets.left - this.insets.right;
            int h = c.getHeight() - this.insets.top - this.insets.bottom;
            boolean active = JTattooUtilities.isActive((JComponent)c);
            Color color = this.foregroundColor;
            if (!active) {
                color = this.inactiveForegroundColor;
            }
            if (c instanceof AbstractButton && ((AbstractButton)c).getModel().isRollover() && this.rolloverColor != null) {
                color = this.rolloverColor;
            }
            int lw = h > 22 ? 2 : 1;
            int dx = w / 5 + 1;
            int dy = h / 5 + 2;
            Stroke savedStroke = g2D.getStroke();
            g2D.setStroke(new BasicStroke(lw, 0, 0));
            if (this.shadowColor != null) {
                if (!active) {
                    g2D.setColor(this.inactiveShadowColor);
                } else {
                    g2D.setColor(this.shadowColor);
                }
                g2D.drawRect(dx + 1, dy + 1, w - 2 * dx, h - 2 * dy);
                g2D.drawLine(dx + 1, dy + lw + 1, w - dx, dy + lw + 1);
            }
            g2D.setColor(color);
            g2D.drawRect(dx, dy, w - 2 * dx, h - 2 * dy);
            g2D.drawLine(dx + 1, dy + lw, w - dx, dy + lw);
            g2D.setStroke(savedStroke);
            g2D.translate(-this.insets.left, -this.insets.top);
        }
    }

    public static class IconSymbol
    implements Icon {
        private Color foregroundColor = null;
        private Color shadowColor = null;
        private Color inactiveForegroundColor = null;
        private Color inactiveShadowColor = null;
        private Color rolloverColor = null;
        private Insets insets = new Insets(0, 0, 0, 0);

        public IconSymbol(Color foregroundColor, Color shadowColor, Color rolloverColor) {
            this.foregroundColor = foregroundColor;
            this.shadowColor = shadowColor;
            this.rolloverColor = rolloverColor;
            this.inactiveForegroundColor = foregroundColor;
            this.inactiveShadowColor = shadowColor;
        }

        public IconSymbol(Color foregroundColor, Color shadowColor, Color rolloverColor, Insets insets) {
            this.foregroundColor = foregroundColor;
            this.shadowColor = shadowColor;
            this.rolloverColor = rolloverColor;
            this.inactiveForegroundColor = foregroundColor;
            this.inactiveShadowColor = shadowColor;
            this.insets = insets;
        }

        public IconSymbol(Color foregroundColor, Color shadowColor, Color rolloverColor, Color inactiveForegroundColor, Color inactiveShadowColor, Insets insets) {
            this.foregroundColor = foregroundColor;
            this.shadowColor = shadowColor;
            this.rolloverColor = rolloverColor;
            this.inactiveForegroundColor = inactiveForegroundColor;
            this.inactiveShadowColor = inactiveShadowColor;
            this.insets = insets;
        }

        public int getIconHeight() {
            return 16;
        }

        public int getIconWidth() {
            return 16;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            int dx;
            Graphics2D g2D = (Graphics2D)g;
            g2D.translate(this.insets.left, this.insets.top);
            int w = c.getWidth() - this.insets.left - this.insets.right;
            int h = c.getHeight() - this.insets.top - this.insets.bottom;
            boolean active = JTattooUtilities.isActive((JComponent)c);
            Color color = this.foregroundColor;
            if (!active) {
                color = this.inactiveForegroundColor;
            }
            if (c instanceof AbstractButton && ((AbstractButton)c).getModel().isRollover() && this.rolloverColor != null) {
                color = this.rolloverColor;
            }
            int lw = h > 22 ? 3 : 2;
            int dy = dx = w / 5 + 2;
            Stroke savedStroke = g2D.getStroke();
            g2D.setStroke(new BasicStroke(lw, 0, 0));
            if (this.shadowColor != null) {
                if (!active) {
                    g2D.setColor(this.inactiveShadowColor);
                } else {
                    g2D.setColor(this.shadowColor);
                }
                g2D.drawLine(dx + 1, h - dy, w - dx + 1, h - dy);
            }
            g2D.setColor(color);
            g2D.drawLine(dx, h - dy - 1, w - dx, h - dy - 1);
            g2D.setStroke(savedStroke);
            g2D.translate(-this.insets.left, -this.insets.top);
        }
    }

    public static class MacMinIcon
    implements Icon,
    UIResource {
        public void paintIcon(Component c, Graphics g, int x, int y) {
            LazyImageIcon pearlIcon;
            LazyImageIcon minimizerIcon;
            AbstractButton btn = (AbstractButton)c;
            ButtonModel model = btn.getModel();
            int w = c.getWidth();
            int h = c.getHeight();
            if (AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn()) {
                if (AbstractLookAndFeel.getTheme().isSmallFontSize()) {
                    minimizerIcon = MINIMIZER_SMALL;
                    pearlIcon = PEARL_GREEN_SMALL;
                    if (!JTattooUtilities.isActive(btn)) {
                        pearlIcon = PEARL_GREY_SMALL;
                    }
                } else if (AbstractLookAndFeel.getTheme().isMediumFontSize()) {
                    minimizerIcon = MINIMIZER_MEDIUM;
                    pearlIcon = PEARL_GREEN_MEDIUM;
                    if (!JTattooUtilities.isActive(btn)) {
                        pearlIcon = PEARL_GREY_MEDIUM;
                    }
                } else {
                    minimizerIcon = MINIMIZER_LARGE;
                    pearlIcon = PEARL_GREEN_LARGE;
                    if (!JTattooUtilities.isActive(btn)) {
                        pearlIcon = PEARL_GREY_LARGE;
                    }
                }
            } else if (AbstractLookAndFeel.getTheme().isSmallFontSize()) {
                minimizerIcon = MINIMIZER_SMALL;
                pearlIcon = PEARL_YELLOW_SMALL;
                if (!JTattooUtilities.isActive(btn)) {
                    pearlIcon = PEARL_GREY_SMALL;
                }
            } else if (AbstractLookAndFeel.getTheme().isMediumFontSize()) {
                minimizerIcon = MINIMIZER_MEDIUM;
                pearlIcon = PEARL_YELLOW_MEDIUM;
                if (!JTattooUtilities.isActive(btn)) {
                    pearlIcon = PEARL_GREY_MEDIUM;
                }
            } else {
                minimizerIcon = MINIMIZER_LARGE;
                pearlIcon = PEARL_YELLOW_LARGE;
                if (!JTattooUtilities.isActive(btn)) {
                    pearlIcon = PEARL_GREY_LARGE;
                }
            }
            x = (w - pearlIcon.getIconWidth()) / 2;
            y = (h - pearlIcon.getIconHeight()) / 2;
            pearlIcon.paintIcon(c, g, x, y);
            if (model.isRollover()) {
                minimizerIcon.paintIcon(c, g, x += (pearlIcon.getIconWidth() - minimizerIcon.getIconWidth()) / 2, y += (pearlIcon.getIconHeight() - minimizerIcon.getIconHeight()) / 2);
            }
        }

        public int getIconHeight() {
            return 24;
        }

        public int getIconWidth() {
            return 24;
        }
    }

    public static class MacMaxIcon
    implements Icon,
    UIResource {
        public void paintIcon(Component c, Graphics g, int x, int y) {
            LazyImageIcon pearlIcon;
            LazyImageIcon maximizerIcon;
            AbstractButton btn = (AbstractButton)c;
            ButtonModel model = btn.getModel();
            int w = c.getWidth();
            int h = c.getHeight();
            if (AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn()) {
                if (AbstractLookAndFeel.getTheme().isSmallFontSize()) {
                    maximizerIcon = MAXIMIZER_SMALL;
                    pearlIcon = PEARL_GREEN_SMALL;
                    if (!JTattooUtilities.isActive(btn)) {
                        pearlIcon = PEARL_GREY_SMALL;
                    }
                } else if (AbstractLookAndFeel.getTheme().isMediumFontSize()) {
                    maximizerIcon = MAXIMIZER_MEDIUM;
                    pearlIcon = PEARL_GREEN_MEDIUM;
                    if (!JTattooUtilities.isActive(btn)) {
                        pearlIcon = PEARL_GREY_MEDIUM;
                    }
                } else {
                    maximizerIcon = MAXIMIZER_LARGE;
                    pearlIcon = PEARL_GREEN_LARGE;
                    if (!JTattooUtilities.isActive(btn)) {
                        pearlIcon = PEARL_GREY_LARGE;
                    }
                }
            } else if (AbstractLookAndFeel.getTheme().isSmallFontSize()) {
                maximizerIcon = MAXIMIZER_SMALL;
                pearlIcon = PEARL_YELLOW_SMALL;
                if (!JTattooUtilities.isActive(btn)) {
                    pearlIcon = PEARL_GREY_SMALL;
                }
            } else if (AbstractLookAndFeel.getTheme().isMediumFontSize()) {
                maximizerIcon = MAXIMIZER_MEDIUM;
                pearlIcon = PEARL_YELLOW_MEDIUM;
                if (!JTattooUtilities.isActive(btn)) {
                    pearlIcon = PEARL_GREY_MEDIUM;
                }
            } else {
                maximizerIcon = MAXIMIZER_LARGE;
                pearlIcon = PEARL_YELLOW_LARGE;
                if (!JTattooUtilities.isActive(btn)) {
                    pearlIcon = PEARL_GREY_LARGE;
                }
            }
            x = (w - pearlIcon.getIconWidth()) / 2;
            y = (h - pearlIcon.getIconHeight()) / 2;
            pearlIcon.paintIcon(c, g, x, y);
            if (model.isRollover()) {
                maximizerIcon.paintIcon(c, g, x += (pearlIcon.getIconWidth() - maximizerIcon.getIconWidth()) / 2, y += (pearlIcon.getIconHeight() - maximizerIcon.getIconHeight()) / 2);
            }
        }

        public int getIconHeight() {
            return 24;
        }

        public int getIconWidth() {
            return 24;
        }
    }

    public static class MacIconIcon
    implements Icon,
    UIResource {
        public void paintIcon(Component c, Graphics g, int x, int y) {
            LazyImageIcon pearlIcon;
            LazyImageIcon iconizerIcon;
            AbstractButton btn = (AbstractButton)c;
            ButtonModel model = btn.getModel();
            int w = c.getWidth();
            int h = c.getHeight();
            if (AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn()) {
                if (AbstractLookAndFeel.getTheme().isSmallFontSize()) {
                    iconizerIcon = ICONIZER_SMALL;
                    pearlIcon = PEARL_YELLOW_SMALL;
                    if (!JTattooUtilities.isActive(btn)) {
                        pearlIcon = PEARL_GREY_SMALL;
                    }
                } else if (AbstractLookAndFeel.getTheme().isMediumFontSize()) {
                    iconizerIcon = ICONIZER_MEDIUM;
                    pearlIcon = PEARL_YELLOW_MEDIUM;
                    if (!JTattooUtilities.isActive(btn)) {
                        pearlIcon = PEARL_GREY_MEDIUM;
                    }
                } else {
                    iconizerIcon = ICONIZER_LARGE;
                    pearlIcon = PEARL_YELLOW_LARGE;
                    if (!JTattooUtilities.isActive(btn)) {
                        pearlIcon = PEARL_GREY_LARGE;
                    }
                }
            } else if (AbstractLookAndFeel.getTheme().isSmallFontSize()) {
                iconizerIcon = ICONIZER_SMALL;
                pearlIcon = PEARL_GREEN_SMALL;
                if (!JTattooUtilities.isActive(btn)) {
                    pearlIcon = PEARL_GREY_SMALL;
                }
            } else if (AbstractLookAndFeel.getTheme().isMediumFontSize()) {
                iconizerIcon = ICONIZER_MEDIUM;
                pearlIcon = PEARL_GREEN_MEDIUM;
                if (!JTattooUtilities.isActive(btn)) {
                    pearlIcon = PEARL_GREY_MEDIUM;
                }
            } else {
                iconizerIcon = ICONIZER_LARGE;
                pearlIcon = PEARL_GREEN_LARGE;
                if (!JTattooUtilities.isActive(btn)) {
                    pearlIcon = PEARL_GREY_LARGE;
                }
            }
            x = (w - pearlIcon.getIconWidth()) / 2;
            y = (h - pearlIcon.getIconHeight()) / 2;
            pearlIcon.paintIcon(c, g, x, y);
            if (model.isRollover()) {
                iconizerIcon.paintIcon(c, g, x += (pearlIcon.getIconWidth() - iconizerIcon.getIconWidth()) / 2, y += (pearlIcon.getIconHeight() - iconizerIcon.getIconHeight()) / 2);
            }
        }

        public int getIconHeight() {
            return 24;
        }

        public int getIconWidth() {
            return 24;
        }
    }

    public static class MacCloseIcon
    implements Icon,
    UIResource {
        public void paintIcon(Component c, Graphics g, int x, int y) {
            LazyImageIcon pearlIcon;
            LazyImageIcon closerIcon;
            AbstractButton btn = (AbstractButton)c;
            ButtonModel model = btn.getModel();
            int w = c.getWidth();
            int h = c.getHeight();
            if (AbstractLookAndFeel.getTheme().isSmallFontSize()) {
                closerIcon = CLOSER_SMALL;
                pearlIcon = PEARL_RED_SMALL;
                if (!JTattooUtilities.isActive(btn)) {
                    pearlIcon = PEARL_GREY_SMALL;
                }
            } else if (AbstractLookAndFeel.getTheme().isMediumFontSize()) {
                closerIcon = CLOSER_MEDIUM;
                pearlIcon = PEARL_RED_MEDIUM;
                if (!JTattooUtilities.isActive(btn)) {
                    pearlIcon = PEARL_GREY_MEDIUM;
                }
            } else {
                closerIcon = CLOSER_LARGE;
                pearlIcon = PEARL_RED_LARGE;
                if (!JTattooUtilities.isActive(btn)) {
                    pearlIcon = PEARL_GREY_LARGE;
                }
            }
            x = (w - pearlIcon.getIconWidth()) / 2;
            y = (h - pearlIcon.getIconHeight()) / 2;
            pearlIcon.paintIcon(c, g, x, y);
            if (model.isRollover()) {
                closerIcon.paintIcon(c, g, x += (pearlIcon.getIconWidth() - closerIcon.getIconWidth()) / 2, y += (pearlIcon.getIconHeight() - closerIcon.getIconHeight()) / 2);
            }
        }

        public int getIconHeight() {
            return 24;
        }

        public int getIconWidth() {
            return 24;
        }
    }

    private static class RadioButtonIcon
    implements Icon {
        private static int GAP = 2;

        private RadioButtonIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (!JTattooUtilities.isLeftToRight(c)) {
                x += GAP;
            }
            int w = this.getIconWidth() - GAP;
            int h = this.getIconHeight();
            Graphics2D g2D = (Graphics2D)g;
            AbstractButton button = (AbstractButton)c;
            ButtonModel model = button.getModel();
            Color cHi = Color.white;
            Color cLo = Color.white;
            if (!(c instanceof JRadioButtonMenuItem)) {
                Color[] colors = button.isEnabled() ? (button.isRolloverEnabled() && model.isRollover() || model.isPressed() && model.isArmed() ? AbstractLookAndFeel.getTheme().getRolloverColors() : (AbstractLookAndFeel.getTheme().doShowFocusFrame() && button.hasFocus() ? AbstractLookAndFeel.getTheme().getFocusColors() : AbstractLookAndFeel.getTheme().getCheckBoxColors())) : AbstractLookAndFeel.getTheme().getDisabledColors();
                cHi = colors[0];
                cLo = colors[colors.length - 1];
            }
            Paint savedPaint = g2D.getPaint();
            g2D.setPaint(new GradientPaint(0.0f, 0.0f, cHi, 0.0f, h, cLo));
            g2D.fillOval(x, y, w, h);
            g2D.setPaint(savedPaint);
            Shape savedClip = g.getClip();
            Area clipArea = new Area(new Ellipse2D.Double(x, y, w + 1, h + 1));
            if (savedClip != null) {
                clipArea.intersect(new Area(savedClip));
            }
            g2D.setClip(clipArea);
            if (c instanceof JRadioButtonMenuItem) {
                g.setColor(Color.white);
                g.fillRect(x, y, w, h);
            } else if (button.isEnabled()) {
                if (button.isRolloverEnabled() && model.isRollover() || model.isPressed() && model.isArmed()) {
                    JTattooUtilities.fillHorGradient(g, AbstractLookAndFeel.getTheme().getRolloverColors(), x, y, w, h);
                } else if (AbstractLookAndFeel.getTheme().doShowFocusFrame() && button.hasFocus()) {
                    JTattooUtilities.fillHorGradient(g, AbstractLookAndFeel.getTheme().getFocusColors(), x, y, w, h);
                } else {
                    JTattooUtilities.fillHorGradient(g, AbstractLookAndFeel.getTheme().getCheckBoxColors(), x, y, w, h);
                }
            } else {
                JTattooUtilities.fillHorGradient(g, AbstractLookAndFeel.getTheme().getDisabledColors(), x, y, w, h);
            }
            g2D.setClip(savedClip);
            Object savedRederingHint = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (!model.isRollover()) {
                Composite savedComposite = g2D.getComposite();
                AlphaComposite alpha = AlphaComposite.getInstance(3, 0.6f);
                g2D.setComposite(alpha);
                g2D.setColor(Color.white);
                g2D.drawOval(x + 1, y + 1, w - 2, h - 2);
                g2D.setComposite(savedComposite);
            }
            if (button.isEnabled()) {
                if (AbstractLookAndFeel.getTheme().doShowFocusFrame() && button.hasFocus()) {
                    Color hiColor = ColorHelper.brighter(AbstractLookAndFeel.getTheme().getFocusFrameColor(), 30.0);
                    Color loColor = ColorHelper.darker(AbstractLookAndFeel.getTheme().getFocusFrameColor(), 20.0);
                    g.setColor(hiColor);
                    g.drawOval(x - 1, y - 1, w + 2, h + 2);
                    g.setColor(loColor);
                    g2D.drawOval(x, y, w, h);
                } else {
                    g.setColor(AbstractLookAndFeel.getFrameColor());
                    g2D.drawOval(x, y, w, h);
                }
            } else {
                g.setColor(ColorHelper.brighter(AbstractLookAndFeel.getFrameColor(), 40.0));
                g2D.drawOval(x, y, w, h);
            }
            if (model.isSelected()) {
                if (button.isEnabled()) {
                    ColorUIResource fc = AbstractLookAndFeel.getForegroundColor();
                    if (ColorHelper.getGrayValue(cLo) < 128) {
                        if (ColorHelper.getGrayValue(fc) < 128) {
                            g2D.setColor(Color.white);
                        } else {
                            g2D.setColor(fc);
                        }
                    } else if (ColorHelper.getGrayValue(fc) > 128) {
                        g2D.setColor(Color.black);
                    } else {
                        g2D.setColor(fc);
                    }
                } else {
                    g.setColor(AbstractLookAndFeel.getDisabledForegroundColor());
                }
                if (AbstractLookAndFeel.getTheme().isSmallFontSize()) {
                    g2D.fillOval(x + 4, y + 4, w - 7, h - 7);
                } else if (AbstractLookAndFeel.getTheme().isMediumFontSize()) {
                    g2D.fillOval(x + 4, y + 4, w - 7, h - 7);
                } else {
                    g2D.fillOval(x + 5, y + 5, w - 9, h - 9);
                }
            }
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, savedRederingHint);
        }

        public int getIconWidth() {
            int w = AbstractLookAndFeel.getTheme().isSmallFontSize() ? 14 : (AbstractLookAndFeel.getTheme().isMediumFontSize() ? 16 : 18);
            return w + GAP;
        }

        public int getIconHeight() {
            if (AbstractLookAndFeel.getTheme().isSmallFontSize()) {
                return 14;
            }
            if (AbstractLookAndFeel.getTheme().isMediumFontSize()) {
                return 16;
            }
            return 18;
        }
    }

    private static class CheckBoxIcon
    implements Icon {
        private static int GAP = 2;
        private static final Icon SMALL_CHECK_ICON = new LazyImageIcon("icons/small/check_symbol_10x10.png");
        private static final Icon SMALL_CHECK_DISABLED_ICON = new LazyImageIcon("icons/small/check_symbol_disabled_10x10.png");
        private static final Icon MEDIUM_CHECK_ICON = new LazyImageIcon("icons/medium/check_symbol_12x12.png");
        private static final Icon MEDIUM_CHECK_DISABLED_ICON = new LazyImageIcon("icons/medium/check_symbol_disabled_12x12.png");
        private static final Icon LARGE_CHECK_ICON = new LazyImageIcon("icons/large/check_symbol_14x14.png");
        private static final Icon LARGE_CHECK_DISABLED_ICON = new LazyImageIcon("icons/large/check_symbol_disabled_14x14.png");

        private CheckBoxIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Icon checkDisabledIcon;
            Icon checkIcon;
            if (!JTattooUtilities.isLeftToRight(c)) {
                x += GAP;
            }
            int w = this.getIconWidth() - GAP;
            int h = this.getIconHeight();
            AbstractButton button = (AbstractButton)c;
            ButtonModel model = button.getModel();
            if (c instanceof JCheckBoxMenuItem) {
                g.setColor(Color.white);
                g.fillRect(x, y, w, h);
                if (button.isEnabled()) {
                    g.setColor(AbstractLookAndFeel.getFrameColor());
                } else {
                    g.setColor(ColorHelper.brighter(AbstractLookAndFeel.getFrameColor(), 40.0));
                }
                g.drawRect(x, y, w, h);
            } else if (button.isEnabled()) {
                if (button.isRolloverEnabled() && model.isRollover()) {
                    JTattooUtilities.fillHorGradient(g, AbstractLookAndFeel.getTheme().getRolloverColors(), x, y, w, h);
                } else {
                    if (AbstractLookAndFeel.getTheme().doShowFocusFrame() && button.hasFocus()) {
                        JTattooUtilities.fillHorGradient(g, AbstractLookAndFeel.getTheme().getFocusColors(), x, y, w, h);
                    } else {
                        JTattooUtilities.fillHorGradient(g, AbstractLookAndFeel.getTheme().getCheckBoxColors(), x, y, w, h);
                    }
                    if (!model.isPressed()) {
                        g.setColor(Color.white);
                        g.drawLine(x + 1, y + 1, x + 1, y + h - 2);
                        g.drawLine(x + w - 1, y + 1, x + w - 1, y + h - 2);
                    }
                }
                if (AbstractLookAndFeel.getTheme().doShowFocusFrame() && button.hasFocus()) {
                    Color hiColor = ColorHelper.brighter(AbstractLookAndFeel.getTheme().getFocusFrameColor(), 30.0);
                    Color loColor = ColorHelper.darker(AbstractLookAndFeel.getTheme().getFocusFrameColor(), 20.0);
                    g.setColor(hiColor);
                    g.drawRect(x - 1, y - 1, w + 2, h + 2);
                    g.setColor(loColor);
                    g.drawRect(x, y, w, h);
                } else {
                    g.setColor(AbstractLookAndFeel.getFrameColor());
                    g.drawRect(x, y, w, h);
                }
            } else {
                JTattooUtilities.fillHorGradient(g, AbstractLookAndFeel.getTheme().getDisabledColors(), x, y, w, h);
                g.setColor(ColorHelper.brighter(AbstractLookAndFeel.getFrameColor(), 40.0));
                g.drawRect(x, y, w, h);
            }
            if (AbstractLookAndFeel.getTheme().isSmallFontSize()) {
                checkIcon = SMALL_CHECK_ICON;
                checkDisabledIcon = SMALL_CHECK_DISABLED_ICON;
            } else if (AbstractLookAndFeel.getTheme().isMediumFontSize()) {
                checkIcon = MEDIUM_CHECK_ICON;
                checkDisabledIcon = MEDIUM_CHECK_DISABLED_ICON;
            } else {
                checkIcon = LARGE_CHECK_ICON;
                checkDisabledIcon = LARGE_CHECK_DISABLED_ICON;
            }
            int xi = x + (w - checkIcon.getIconWidth()) / 2 + 1;
            int yi = y + (h - checkIcon.getIconHeight()) / 2 + 1;
            if (model.isPressed() && model.isArmed()) {
                ColorUIResource bc = AbstractLookAndFeel.getTheme().getSelectionBackgroundColor();
                Color fc = ColorHelper.darker(bc, 40.0);
                g.setColor(fc);
                g.drawRect(x + 3, y + 3, w - 6, h - 6);
                g.setColor(bc);
                g.fillRect(x + 4, y + 4, w - 7, h - 7);
            } else if (model.isSelected()) {
                if (button.isEnabled()) {
                    checkIcon.paintIcon(c, g, xi, yi);
                } else {
                    checkDisabledIcon.paintIcon(c, g, xi, yi);
                }
            }
        }

        public int getIconWidth() {
            int w = AbstractLookAndFeel.getTheme().isSmallFontSize() ? 15 : (AbstractLookAndFeel.getTheme().isMediumFontSize() ? 17 : 19);
            return w + GAP;
        }

        public int getIconHeight() {
            if (AbstractLookAndFeel.getTheme().isSmallFontSize()) {
                return 15;
            }
            if (AbstractLookAndFeel.getTheme().isMediumFontSize()) {
                return 17;
            }
            return 19;
        }
    }
}

