/*
 * Decompiled with CFR 0.152.
 */
package com.floreysoft.jmte.token;

import com.floreysoft.jmte.token.Token;

public abstract class AbstractToken
implements Token {
    protected String text;
    protected int line;
    protected int column;
    protected String sourceName;
    private int tokenIndex;

    public AbstractToken() {
    }

    public AbstractToken(AbstractToken token) {
        this.text = token.text;
        this.line = token.line;
        this.column = token.column;
        this.sourceName = token.sourceName;
        this.setTokenIndex(token.getTokenIndex());
    }

    public AbstractToken(char[] buffer, int start, int end, int tokenIndex) {
        this(null, buffer, start, end, tokenIndex);
    }

    public AbstractToken(String sourceName, char[] buffer, int start, int end, int tokenIndex) {
        this.setSourceName(sourceName);
        this.setText(buffer, start, end);
        this.setLine(buffer, start, end);
        this.setColumn(buffer, start, end);
        this.setTokenIndex(tokenIndex);
    }

    @Override
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public void setText(char[] buffer, int start, int end) {
        this.setText(new String(buffer, start, end - start));
    }

    public void setLine(char[] buffer, int start, int end) {
        this.line = 1;
        for (int i = 0; i < start; ++i) {
            if (buffer[i] != '\n') continue;
            ++this.line;
        }
    }

    public void setColumn(char[] buffer, int start, int end) {
        this.column = 0;
        if (buffer.length != 0) {
            for (int i = start; i >= 0 && buffer[i] != '\n'; --i) {
                ++this.column;
            }
        }
    }

    public String toString() {
        return this.getText();
    }

    @Override
    public String emit() {
        return this.getText();
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    @Override
    public String getSourceName() {
        return this.sourceName;
    }

    @Override
    public int getTokenIndex() {
        return this.tokenIndex;
    }

    public void setTokenIndex(int tokenIndex) {
        this.tokenIndex = tokenIndex;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

