/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.tools;

import com.threerings.getdown.tools.Digester;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class DigesterTask
extends Task {
    protected File _appdir;
    protected File _storepath;
    protected String _storepass;
    protected String _storealias;

    public void setAppdir(File file) {
        this._appdir = file;
    }

    public void setKeystore(File file) {
        this._storepath = file;
    }

    public void setStorepass(String string) {
        this._storepass = string;
    }

    public void setAlias(String string) {
        this._storealias = string;
    }

    public void execute() throws BuildException {
        if (this._appdir == null) {
            throw new BuildException("Must specify the path to the application directory via the 'appdir' attribute.");
        }
        if (this._storepath != null && (this._storepass == null || this._storealias == null)) {
            throw new BuildException("Must specify both a keystore password and a private key alias.");
        }
        try {
            Digester.createDigest(this._appdir);
            if (this._storepath != null) {
                Digester.signDigest(this._appdir, this._storepath, this._storepass, this._storealias);
            }
            return;
        }
        catch (IOException iOException) {
            throw new BuildException("Error creating digest: " + iOException.getMessage(), (Throwable)iOException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new BuildException("Error creating signature: " + generalSecurityException.getMessage(), (Throwable)generalSecurityException);
        }
    }
}

