/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.launcher;

import com.threerings.getdown.Log;
import com.threerings.getdown.launcher.ImageLoader;
import java.awt.Image;

public class RotatingBackgrounds {
    protected long currentDisplayStart;
    protected int current = -1;
    protected Image[] images;
    protected Image errorImage;
    protected int[] percentages;
    protected int[] minDisplayTime;

    public RotatingBackgrounds() {
        this.makeEmpty();
    }

    public RotatingBackgrounds(Image image) {
        this.percentages = new int[]{0};
        this.minDisplayTime = new int[]{0};
        this.images = new Image[]{image};
        this.errorImage = this.images[0];
    }

    public RotatingBackgrounds(String[] stringArray, String string, ImageLoader imageLoader) {
        this.percentages = new int[stringArray.length];
        this.minDisplayTime = new int[stringArray.length];
        this.images = new Image[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String[] stringArray2 = stringArray[i2].split(";");
            if (stringArray2.length != 2) {
                Log.log.b("Unable to parse background image '" + stringArray[i2] + "'", new Object[0]);
                this.makeEmpty();
                return;
            }
            this.images[i2] = imageLoader.loadImage(stringArray2[0]);
            try {
                this.minDisplayTime[i2] = Integer.parseInt(stringArray2[1]);
            }
            catch (NumberFormatException numberFormatException) {
                Log.log.b("Unable to parse background image display time '" + stringArray[i2] + "'", new Object[0]);
                this.makeEmpty();
                return;
            }
            this.percentages[i2] = (int)((float)i2 / (float)stringArray.length * 100.0f);
        }
        if (string == null) {
            this.errorImage = this.images[0];
            return;
        }
        this.errorImage = imageLoader.loadImage(string);
    }

    public Image getImage(int n2) {
        if (this.images.length == 0) {
            return null;
        }
        long l2 = System.currentTimeMillis();
        if (this.current != this.images.length - 1 && (this.current == -1 || n2 >= this.percentages[this.current + 1] && (l2 - this.currentDisplayStart) / 1000L > (long)this.minDisplayTime[this.current])) {
            ++this.current;
            this.currentDisplayStart = l2;
        }
        return this.images[this.current];
    }

    public Image getErrorImage() {
        return this.errorImage;
    }

    public int getNumImages() {
        return this.images.length;
    }

    protected void makeEmpty() {
        this.percentages = new int[0];
        this.minDisplayTime = new int[0];
        this.images = new Image[0];
    }
}

