/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.classworlds;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.classworlds.DefaultClassRealm;
import org.codehaus.classworlds.DuplicateRealmException;
import org.codehaus.classworlds.NoSuchRealmException;

public class ClassWorld {
    private Map realms = new HashMap();

    public ClassRealm newRealm(String id) throws DuplicateRealmException {
        return this.newRealm(id, ClassLoader.getSystemClassLoader());
    }

    public ClassRealm newRealm(final String id, final ClassLoader parentClassloader) throws DuplicateRealmException {
        if (this.realms.containsKey(id)) {
            throw new DuplicateRealmException(this, id);
        }
        DefaultClassRealm realm = AccessController.doPrivileged(new PrivilegedAction<DefaultClassRealm>(){

            @Override
            public DefaultClassRealm run() {
                return new DefaultClassRealm(ClassWorld.this, id, parentClassloader);
            }
        });
        this.realms.put(id, realm);
        return realm;
    }

    public ClassRealm getRealm(String id) throws NoSuchRealmException {
        if (this.realms.containsKey(id)) {
            return (ClassRealm)this.realms.get(id);
        }
        throw new NoSuchRealmException(this, id);
    }

    DefaultClassRealm getRealmImpl(String id) throws NoSuchRealmException {
        return (DefaultClassRealm)this.getRealm(id);
    }

    public Collection getRealms() {
        return this.realms.values();
    }

    Class loadClass(String name) throws ClassNotFoundException {
        return this.getClass().getClassLoader().loadClass(name);
    }
}

