/*
 * Decompiled with CFR 0.152.
 */
package net.jcores.jre.utils.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.jcores.jre.CommonCore;
import net.jcores.jre.CoreKeeper;
import net.jcores.jre.options.MessageType;
import net.jcores.jre.options.Option;

public class Files {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readText(CommonCore commonCore, File file) {
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new FileReader(file));
            StringBuilder stringBuilder = new StringBuilder();
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string);
                stringBuilder.append("\n");
            }
            String string2 = stringBuilder.toString();
            return string2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            commonCore.report(MessageType.EXCEPTION, "File not found " + file);
        }
        catch (IOException iOException) {
            commonCore.report(MessageType.EXCEPTION, "Error reading from file " + file);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    commonCore.report(MessageType.EXCEPTION, "Error closing file " + file);
                }
            }
        }
        return null;
    }

    public static File[] dir(File file, boolean bl) {
        ArrayList<File> arrayList = new ArrayList<File>();
        ArrayList<File> arrayList2 = new ArrayList<File>();
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return null;
        }
        arrayList2.addAll(Arrays.asList(fileArray));
        while (arrayList2.size() > 0) {
            fileArray = arrayList2.toArray(new File[0]);
            arrayList2.clear();
            for (File file2 : fileArray) {
                File[] fileArray2;
                if (!file2.isDirectory()) {
                    arrayList.add(file2);
                    continue;
                }
                if (bl) {
                    arrayList.add(file2);
                }
                if ((fileArray2 = file2.listFiles()) == null) continue;
                arrayList2.addAll(Arrays.asList(fileArray2));
            }
        }
        return arrayList.toArray(new File[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File[] copy(CommonCore commonCore, File file, File file2) {
        boolean bl;
        boolean bl2 = file2.getAbsolutePath().endsWith("/") || file2.isDirectory();
        boolean bl3 = bl = file.getAbsolutePath().endsWith("/") || file.isDirectory();
        if (bl) {
            File[] fileArray = Files.dir(file, false);
            ArrayList<File> arrayList = new ArrayList<File>();
            for (File file3 : fileArray) {
                String string = file3.getAbsolutePath().replace(file.getAbsolutePath(), "");
                arrayList.addAll(Arrays.asList(Files.copy(commonCore, file3, new File(file2 + "/" + string))));
            }
            return arrayList.toArray(new File[0]);
        }
        if (bl2) {
            file2.mkdirs();
        } else if (!file2.getParentFile().mkdirs()) {
            commonCore.report(MessageType.EXCEPTION, "Unable to create directory " + file2.getParentFile());
        }
        File file4 = bl2 ? new File(file2.getAbsoluteFile() + "/" + file.getName()) : file2;
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file4);
            byte[] byArray = new byte[65536];
            int n = 0;
            while ((n = fileInputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
        }
        catch (Exception exception) {
            commonCore.report(MessageType.EXCEPTION, "Error copying file " + file + " " + file2 + " due to a " + exception.getMessage());
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return new File[]{file4};
    }

    public static void zipFiles(File file, File[] fileArray) {
        byte[] byArray = new byte[32768];
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
            zipOutputStream.setLevel(9);
            for (File file2 : fileArray) {
                File[] fileArray2 = file2.isDirectory() ? CoreKeeper.$(file2).dir(new Option[0]).array(File.class) : CoreKeeper.$(file2).array(File.class);
                String string = file2.getAbsolutePath();
                for (File file3 : fileArray2) {
                    String string2 = file2.isDirectory() ? file3.getAbsolutePath().substring(string.length() + 1) : file3.getName();
                    string2 = string2.replaceAll("\\\\", "/");
                    string2 = file3.isDirectory() ? string2 + "/" : string2;
                    try {
                        int n;
                        FileInputStream fileInputStream = new FileInputStream(file3);
                        ZipEntry zipEntry = new ZipEntry(string2);
                        zipOutputStream.putNextEntry(zipEntry);
                        while ((n = fileInputStream.read(byArray)) != -1) {
                            zipOutputStream.write(byArray, 0, n);
                        }
                        fileInputStream.close();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        fileNotFoundException.printStackTrace();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    zipOutputStream.closeEntry();
                }
            }
            zipOutputStream.close();
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void jarFiles(File file, Manifest manifest, File[] fileArray) {
        byte[] byArray = new byte[32768];
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            JarOutputStream jarOutputStream = manifest == null ? new JarOutputStream(fileOutputStream) : new JarOutputStream((OutputStream)fileOutputStream, manifest);
            jarOutputStream.setLevel(9);
            for (File file2 : fileArray) {
                File[] fileArray2 = file2.isDirectory() ? CoreKeeper.$(file2).dir(new Option[0]).array(File.class) : CoreKeeper.$(file2).array(File.class);
                String string = file2.getAbsolutePath();
                for (File file3 : fileArray2) {
                    String string2 = file2.isDirectory() ? file3.getAbsolutePath().substring(string.length() + 1) : file3.getName();
                    string2 = string2.replaceAll("\\\\", "/");
                    string2 = file3.isDirectory() ? string2 + "/" : string2;
                    try {
                        int n;
                        FileInputStream fileInputStream = new FileInputStream(file3);
                        JarEntry jarEntry = new JarEntry(string2);
                        jarOutputStream.putNextEntry(jarEntry);
                        while ((n = fileInputStream.read(byArray)) != -1) {
                            jarOutputStream.write(byArray, 0, n);
                        }
                        fileInputStream.close();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        fileNotFoundException.printStackTrace();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    jarOutputStream.closeEntry();
                }
            }
            jarOutputStream.close();
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

