/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Locale;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.CountryCode;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;

public class MediaScrapeOptions {
    private MediaSearchResult result;
    private MediaMetadata metadata;
    private HashMap<String, String> ids = new HashMap();
    private MediaType type;
    private MediaArtwork.MediaArtworkType artworkType = MediaArtwork.MediaArtworkType.ALL;
    private Locale language = Locale.getDefault();
    private CountryCode country = CountryCode.US;
    private MediaArtwork.FanartSizes fanartSize = MediaArtwork.FanartSizes.MEDIUM;
    private MediaArtwork.PosterSizes posterSize = MediaArtwork.PosterSizes.MEDIUM;

    public MediaScrapeOptions(MediaType type) {
        this.type = type;
    }

    public MediaSearchResult getResult() {
        return this.result;
    }

    public void setResult(MediaSearchResult result) {
        this.result = result;
    }

    public String getId(String providerId) {
        return this.ids.get(providerId);
    }

    public void setId(String providerId, String id) {
        this.ids.put(providerId, id);
    }

    public String getImdbId() {
        String obj = this.ids.get("imdb");
        if (obj == null && (obj = this.ids.get("imdbId")) == null) {
            return "";
        }
        return obj.toString();
    }

    public int getTmdbId() {
        int id = 0;
        try {
            id = Integer.parseInt(this.ids.get("tmdb"));
        }
        catch (Exception ignored) {
            // empty catch block
        }
        if (id == 0) {
            try {
                id = Integer.parseInt(this.ids.get("tmdbId"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return id;
    }

    public void setImdbId(String imdbId) {
        this.ids.put("imdb", imdbId);
    }

    public void setTmdbId(int tmdbId) {
        this.ids.put("tmdb", String.valueOf(tmdbId));
    }

    public MediaArtwork.MediaArtworkType getArtworkType() {
        return this.artworkType;
    }

    public void setArtworkType(MediaArtwork.MediaArtworkType artworkType) {
        this.artworkType = artworkType;
    }

    public MediaMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(MediaMetadata metadata) {
        this.metadata = metadata;
    }

    public MediaType getType() {
        return this.type;
    }

    public Locale getLanguage() {
        return this.language;
    }

    public void setLanguage(Locale language) {
        this.language = language;
    }

    public CountryCode getCountry() {
        return this.country;
    }

    public void setCountry(CountryCode country) {
        this.country = country;
    }

    public MediaArtwork.FanartSizes getFanartSize() {
        return this.fanartSize;
    }

    public MediaArtwork.PosterSizes getPosterSize() {
        return this.posterSize;
    }

    public void setFanartSize(MediaArtwork.FanartSizes fanartSize) {
        this.fanartSize = fanartSize;
    }

    public void setPosterSize(MediaArtwork.PosterSizes posterSize) {
        this.posterSize = posterSize;
    }

    public String toString() {
        return new ReflectionToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE){

            protected boolean accept(Field f) {
                return super.accept(f) && !f.getName().equals("metadata");
            }
        }.toString();
    }
}

