/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.rottentomatoes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.xeoh.plugins.base.annotations.PluginImplementation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.MediaSearchOptions;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.UnsupportedMediaTypeException;
import org.tinymediamanager.scraper.entities.MediaCastMember;
import org.tinymediamanager.scraper.entities.MediaGenres;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.mediaprovider.IMovieMetadataProvider;
import org.tinymediamanager.scraper.rottentomatoes.RottenTomatoes;
import org.tinymediamanager.scraper.rottentomatoes.entities.RTCast;
import org.tinymediamanager.scraper.rottentomatoes.entities.RTDirector;
import org.tinymediamanager.scraper.rottentomatoes.entities.RTMovieInfo;
import org.tinymediamanager.scraper.rottentomatoes.entities.RTMovieSearchResult;
import org.tinymediamanager.scraper.util.ApiKey;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.RingBuffer;

@PluginImplementation
public class RottenTomatoesMetadataProvider
implements IMovieMetadataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(RottenTomatoesMetadataProvider.class);
    private static final RingBuffer<Long> connectionCounter = new RingBuffer(5);
    private static final MediaProviderInfo providerInfo = RottenTomatoesMetadataProvider.createMediaProviderInfo();
    private static RottenTomatoes api;

    private static MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo providerInfo = new MediaProviderInfo("rottentomatoes", "Rotten Tomatoes", "<html><h3>Rotten Tomatoes</h3><br />An american movie database.<br />Does not provide plot for older movies via the API.<br /><br />Available languages: EN</html>", RottenTomatoesMetadataProvider.class.getResource("/rottentomatoes_com.png"));
        providerInfo.setVersion(RottenTomatoes.class);
        return providerInfo;
    }

    private static synchronized void initRottenTomatoesApiInstance() throws Exception {
        if (api == null) {
            try {
                api = new RottenTomatoes(ApiKey.decryptApikey((String)"O0HBqxsoTCzaT3lTxVxmoMji3yzUuXSRbnMTRLnkHY4="));
            }
            catch (Exception e) {
                LOGGER.error("RottenTomatoesMetadataProvider", (Throwable)e);
                throw e;
            }
        }
    }

    public MediaProviderInfo getProviderInfo() {
        return providerInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaMetadata getMetadata(MediaScrapeOptions options) throws Exception {
        MediaCastMember cm;
        LOGGER.debug("getMetadata() " + options.toString());
        RottenTomatoesMetadataProvider.initRottenTomatoesApiInstance();
        if (options.getType() != MediaType.MOVIE) {
            throw new UnsupportedMediaTypeException(options.getType());
        }
        if (options.getResult() != null && options.getResult().getMediaMetadata() != null) {
            LOGGER.debug("RottenTomatoes: getMetadata from cache: " + options.getResult());
            return options.getResult().getMediaMetadata();
        }
        MediaMetadata md = new MediaMetadata(providerInfo.getId());
        int rottenId = 0;
        if (options.getResult() != null) {
            rottenId = Integer.parseInt(options.getResult().getId());
        }
        if (rottenId == 0) {
            try {
                rottenId = Integer.parseInt(options.getId(providerInfo.getId()));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        String imdbId = options.getImdbId();
        if (rottenId == 0 && !MetadataUtil.isValidImdbId((String)imdbId)) {
            LOGGER.warn("not possible to scrape from RottenTomatoes - no rottenId/imdbId found");
            return md;
        }
        LOGGER.debug("RottenTomatoes: getMetadata: rottenId = " + rottenId + "; imdbId = " + imdbId);
        RTMovieInfo movie = null;
        RottenTomatoes rottenTomatoes = api;
        synchronized (rottenTomatoes) {
            this.trackConnections();
            if (rottenId == 0 && MetadataUtil.isValidImdbId((String)imdbId)) {
                try {
                    movie = api.getMovieAliasService().getMovieInfo(imdbId);
                }
                catch (Exception e) {
                    LOGGER.warn("problem getting data vom RottenTomatoes: " + e.getMessage());
                }
            }
            if (movie == null && rottenId != 0) {
                try {
                    movie = api.getMovieInfoService().getMovieInfo(rottenId);
                }
                catch (Exception e) {
                    LOGGER.warn("problem getting data vom RottenTomatoes: " + e.getMessage());
                }
            }
            if (movie == null) {
                LOGGER.warn("no result found");
                return md;
            }
        }
        md.setId(providerInfo.getId(), (Object)movie.id);
        if (StringUtils.isNotBlank((CharSequence)movie.alternateIds.imdb)) {
            md.setId("imdb", (Object)("tt" + movie.alternateIds.imdb));
        }
        md.setPlot(movie.synopsis);
        md.setTitle(movie.title);
        md.setYear(movie.year.intValue());
        md.addProductionCompany(movie.studio);
        md.setRating((float)movie.ratings.audience_score.intValue() / 10.0f);
        md.setRuntime(movie.runtime.intValue());
        for (String genre : movie.genres) {
            if ("Science Fiction & Fantasy".equals(genre)) {
                md.addGenre(MediaGenres.FANTASY);
                md.addGenre(MediaGenres.SCIENCE_FICTION);
                continue;
            }
            MediaGenres g = MediaGenres.getGenre((String)genre);
            if (g == null) continue;
            md.addGenre(g);
        }
        for (RTCast rtCast : movie.abridgedCast) {
            cm = new MediaCastMember();
            cm.setName(rtCast.name);
            cm.setType(MediaCastMember.CastType.ACTOR);
            String roles = "";
            for (String character : rtCast.characters) {
                if (StringUtils.isNotBlank((CharSequence)roles)) {
                    roles = roles + ", ";
                }
                roles = roles + character;
            }
            cm.setCharacter(roles);
            md.addCastMember(cm);
        }
        for (RTDirector person : movie.abridgedDirectors) {
            cm = new MediaCastMember();
            cm.setType(MediaCastMember.CastType.DIRECTOR);
            cm.setName(person.name);
            md.addCastMember(cm);
        }
        return md;
    }

    public List<MediaSearchResult> search(MediaSearchOptions query) throws Exception {
        RottenTomatoesMetadataProvider.initRottenTomatoesApiInstance();
        if (query.getMediaType() == MediaType.MOVIE) {
            return this.searchMovies(query);
        }
        throw new UnsupportedMediaTypeException(query.getMediaType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MediaSearchResult> searchMovies(MediaSearchOptions query) throws Exception {
        LOGGER.debug("search() " + query.toString());
        ArrayList<MediaSearchResult> resultList = new ArrayList<MediaSearchResult>();
        String searchString = "";
        if (StringUtils.isEmpty((CharSequence)searchString) && StringUtils.isNotEmpty((CharSequence)query.getQuery())) {
            searchString = query.getQuery();
        }
        int year = 0;
        if (query.getYear() != 0) {
            year = query.getYear();
        }
        if (StringUtils.isEmpty((CharSequence)searchString)) {
            LOGGER.debug("RT Scraper: empty searchString");
            return resultList;
        }
        searchString = MetadataUtil.removeNonSearchCharacters((String)searchString);
        LOGGER.info("========= BEGIN RT Scraper Search for: " + searchString);
        RTMovieSearchResult searchResult = null;
        String imdbId = "";
        RottenTomatoes rottenTomatoes = api;
        synchronized (rottenTomatoes) {
            if (StringUtils.isNotEmpty((CharSequence)query.getImdbId())) {
                imdbId = query.getImdbId();
                this.trackConnections();
                try {
                    searchResult = api.getMovieSearchService().searchMovie(imdbId);
                }
                catch (Exception e) {
                    LOGGER.warn("problem getting data vom rt: " + e.getMessage());
                }
            }
            if (searchResult == null || searchResult.total == 0) {
                this.trackConnections();
                try {
                    searchResult = api.getMovieSearchService().searchMovie(searchString);
                }
                catch (Exception e) {
                    LOGGER.warn("problem getting data vom rt: " + e.getMessage());
                }
            }
        }
        if (searchResult != null) {
            LOGGER.info("found " + searchResult.total + " results");
        }
        if (searchResult == null || searchResult.total == 0) {
            return resultList;
        }
        for (RTMovieInfo movie : searchResult.movies) {
            if (movie == null) continue;
            MediaSearchResult sr = new MediaSearchResult(providerInfo.getId(), query.getMediaType());
            sr.setId(Integer.toString(movie.id));
            sr.setTitle(movie.title);
            if (StringUtils.isNotBlank((CharSequence)movie.alternateIds.imdb)) {
                sr.setIMDBId(movie.alternateIds.imdb);
            }
            if (movie.posters != null) {
                String posterUrl = movie.posters.detailed;
                if (StringUtils.isBlank((CharSequence)posterUrl)) {
                    posterUrl = movie.posters.original;
                }
                if (StringUtils.isNotBlank((CharSequence)posterUrl)) {
                    sr.setPosterUrl(posterUrl.replace("_tmb.", "_det."));
                }
            }
            sr.setYear(movie.year.intValue());
            if (sr.getYear() == 0 && movie.releaseDates != null) {
                String releaseDate = movie.releaseDates.theater;
                if (StringUtils.isBlank((CharSequence)releaseDate)) {
                    releaseDate = movie.releaseDates.dvd;
                }
                if (releaseDate != null && releaseDate.length() > 3) {
                    try {
                        sr.setYear(Integer.parseInt(releaseDate.substring(0, 4)));
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                }
            }
            if (imdbId.equals(sr.getIMDBId())) {
                sr.setScore(1.0f);
            } else {
                float score = MetadataUtil.calculateScore((String)searchString, (String)movie.title);
                if (this.yearDiffers(year, movie.year)) {
                    float diff = (float)Math.abs(year - movie.year) / 100.0f;
                    LOGGER.debug("parsed year does not match search result year - downgrading score by " + diff);
                    score -= diff;
                }
                sr.setScore(score);
            }
            resultList.add(sr);
        }
        Collections.sort(resultList);
        Collections.reverse(resultList);
        return resultList;
    }

    private void trackConnections() {
        Long oldestConnection;
        Long currentTime = System.currentTimeMillis();
        if (connectionCounter.count() == connectionCounter.maxSize() && (oldestConnection = (Long)connectionCounter.getTailItem()) > currentTime - 1000L) {
            LOGGER.debug("connection limit reached, throttling " + connectionCounter);
            try {
                Thread.sleep(1100L - (currentTime - oldestConnection));
            }
            catch (InterruptedException e) {
                LOGGER.warn(e.getMessage());
            }
        }
        currentTime = System.currentTimeMillis();
        connectionCounter.add((Object)currentTime);
    }

    private boolean yearDiffers(Integer i1, Integer i2) {
        return i1 != null && i1 != 0 && i2 != null && i2 != 0 && i1 != i2;
    }
}

