/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui.model;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import org.japura.gui.model.AbstractNumberDocument;

public abstract class NumberDocument<T extends Number>
extends AbstractNumberDocument<T, Number> {
    private static final long serialVersionUID = 3L;

    public NumberDocument(Locale locale, boolean acceptFraction) {
        super(locale, acceptFraction);
    }

    protected NumberFormat getNumberFormat() {
        NumberFormat nf = NumberFormat.getInstance(this.getLocale());
        nf.setGroupingUsed(false);
        return nf;
    }

    @Override
    protected Number parse(String text) {
        NumberFormat n = this.getNumberFormat();
        try {
            return n.parse(text);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    @Override
    protected String format(T value) {
        NumberFormat n = this.getNumberFormat();
        n.setMaximumFractionDigits(Integer.MAX_VALUE);
        return n.format(value);
    }
}

