/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.japura.gui.event.ListCheckListener;
import org.japura.gui.event.ListEvent;
import org.japura.gui.event.ListLockListener;
import org.japura.gui.event.ListModelListener;
import org.japura.gui.model.ListCheckModel;

public class DefaultListCheckModel
implements ListCheckModel,
Serializable {
    protected EventListenerList listenerList = new EventListenerList();
    private List<Object> items;
    private List<Object> checkeds = new ArrayList<Object>();
    private List<Object> lockeds = new ArrayList<Object>();

    public DefaultListCheckModel() {
        this.items = new ArrayList<Object>();
    }

    protected void fireAddedListModelListeners(List<Object> values, int index1, int index2, boolean valueIsAdjusting) {
        ListDataListener[] listeners2;
        ListModelListener[] listeners = (ListModelListener[])this.listenerList.getListeners(ListModelListener.class);
        ListEvent e = new ListEvent(this, values, valueIsAdjusting);
        for (ListModelListener l : listeners) {
            l.valueAdded(e);
        }
        ListDataEvent e2 = new ListDataEvent(this, 1, index1, index2);
        for (ListDataListener l : listeners2 = (ListDataListener[])this.listenerList.getListeners(ListDataListener.class)) {
            l.intervalAdded(e2);
        }
    }

    protected void fireRemovedListModelListeners(List<Object> values, boolean valueIsAdjusting) {
        ListModelListener[] listeners = (ListModelListener[])this.listenerList.getListeners(ListModelListener.class);
        ListEvent e = new ListEvent(this, values, valueIsAdjusting);
        for (ListModelListener l : listeners) {
            l.valueRemoved(e);
        }
    }

    protected void fireRemovedListModelListeners(int index1, int index2, boolean valueIsAdjusting) {
        ListDataListener[] listeners2;
        ListDataEvent e2 = new ListDataEvent(this, 2, index1, index2);
        for (ListDataListener l : listeners2 = (ListDataListener[])this.listenerList.getListeners(ListDataListener.class)) {
            l.intervalRemoved(e2);
        }
    }

    protected void fireAddLockListModelListeners(List<Object> values, boolean valueIsAdjusting) {
        this.fireLockListModelListeners(values, valueIsAdjusting, true);
    }

    protected void fireRemoveLockListModelListeners(List<Object> values, boolean valueIsAdjusting) {
        this.fireLockListModelListeners(values, valueIsAdjusting, false);
    }

    private void fireLockListModelListeners(List<Object> values, boolean valueIsAdjusting, boolean add) {
        ListLockListener[] listeners = (ListLockListener[])this.listenerList.getListeners(ListLockListener.class);
        ListEvent e = new ListEvent(this, values, valueIsAdjusting);
        for (ListLockListener l : listeners) {
            if (add) {
                l.addLock(e);
                continue;
            }
            l.removeLock(e);
        }
    }

    protected void fireAddCheckListModelListeners(List<Object> values, boolean valueIsAdjusting) {
        this.fireCheckListModelListeners(values, valueIsAdjusting, true);
    }

    protected void fireRemoveCheckListModelListeners(List<Object> values, boolean valueIsAdjusting) {
        this.fireCheckListModelListeners(values, valueIsAdjusting, false);
    }

    private void fireCheckListModelListeners(List<Object> values, boolean valueIsAdjusting, boolean add) {
        ListCheckListener[] listeners = (ListCheckListener[])this.listenerList.getListeners(ListCheckListener.class);
        ListEvent e = new ListEvent(this, values, valueIsAdjusting);
        for (ListCheckListener l : listeners) {
            if (add) {
                l.addCheck(e);
                continue;
            }
            l.removeCheck(e);
        }
    }

    @Override
    public void clear() {
        this.clear(false);
    }

    private void clear(boolean valueIsAdjusting) {
        if (this.items.size() == 0) {
            return;
        }
        this.checkeds.clear();
        this.lockeds.clear();
        if (this.items.size() > 0) {
            int index2 = this.items.size() - 1;
            this.items.clear();
            this.fireRemovedListModelListeners(0, index2, valueIsAdjusting);
            this.fireRemovedListModelListeners(new ArrayList<Object>(), valueIsAdjusting);
        }
    }

    public void clearLockeds() {
        this.clearLockeds(false);
    }

    private void clearLockeds(boolean valueIsAdjusting) {
        if (this.lockeds.size() == 0) {
            return;
        }
        this.lockeds.clear();
        this.fireRemoveLockListModelListeners(new ArrayList<Object>(), valueIsAdjusting);
    }

    @Override
    public void addListLockListener(ListLockListener listener) {
        this.listenerList.add(ListLockListener.class, listener);
    }

    @Override
    public ListLockListener[] getListLockListeners() {
        return (ListLockListener[])this.listenerList.getListeners(ListLockListener.class);
    }

    @Override
    public void removeListLockListener(ListLockListener listener) {
        this.listenerList.remove(ListLockListener.class, listener);
    }

    @Override
    public void addLock(Object ... values) {
        if (values.length == 0) {
            return;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object value : values) {
            if (!this.contains(value) || this.lockeds.contains(value)) continue;
            this.lockeds.add(value);
            list.add(value);
        }
        if (list.size() > 0) {
            this.fireAddLockListModelListeners(list, false);
        }
    }

    @Override
    public boolean isLocked(Object obj) {
        return this.lockeds.contains(obj);
    }

    @Override
    public void removeLock(Object ... values) {
        if (values.length == 0) {
            return;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object value : values) {
            if (!this.lockeds.remove(value)) continue;
            list.add(value);
        }
        if (list.size() > 0) {
            this.fireRemoveLockListModelListeners(list, false);
        }
    }

    @Override
    public void setLock(Object ... objs) {
        this.clearLockeds(true);
        this.addLock(objs);
    }

    @Override
    public List<Object> getLockeds() {
        return new ArrayList<Object>(this.lockeds);
    }

    private void clearCheckeds(boolean valueIsAdjusting) {
        if (this.checkeds.size() == 0) {
            return;
        }
        this.checkeds.clear();
        this.fireRemoveCheckListModelListeners(new ArrayList<Object>(), valueIsAdjusting);
    }

    @Override
    public void addListCheckListener(ListCheckListener listener) {
        this.listenerList.add(ListCheckListener.class, listener);
    }

    @Override
    public ListCheckListener[] getListCheckListeners() {
        return (ListCheckListener[])this.listenerList.getListeners(ListCheckListener.class);
    }

    @Override
    public void removeListCheckListener(ListCheckListener listener) {
        this.listenerList.remove(ListCheckListener.class, listener);
    }

    @Override
    public void addCheck(Object ... values) {
        if (values.length == 0) {
            return;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object value : values) {
            if (!this.contains(value) || this.checkeds.contains(value)) continue;
            this.checkeds.add(value);
            list.add(value);
        }
        if (list.size() > 0) {
            this.fireAddCheckListModelListeners(list, false);
        }
    }

    @Override
    public boolean isChecked(Object value) {
        return this.checkeds.contains(value);
    }

    @Override
    public void removeCheck(Object ... values) {
        if (values.length == 0) {
            return;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object value : values) {
            if (!this.checkeds.remove(value)) continue;
            list.add(value);
        }
        if (list.size() > 0) {
            this.fireRemoveCheckListModelListeners(list, false);
        }
    }

    @Override
    public void setCheck(Object ... values) {
        this.clearCheckeds(true);
        this.addCheck(values);
    }

    @Override
    public List<Object> getCheckeds() {
        return new ArrayList<Object>(this.checkeds);
    }

    @Override
    public void addElement(int index, Object value) {
        if (index >= 0 && index <= this.items.size() && !this.items.contains(value)) {
            ArrayList<Object> list = new ArrayList<Object>();
            this.items.add(index, value);
            list.add(value);
            this.fireAddedListModelListeners(list, index, index, false);
        }
    }

    @Override
    public void setElement(Object ... values) {
        this.clear(true);
        this.addElement(values);
    }

    @Override
    public void addElement(Object ... values) {
        if (values.length == 0) {
            return;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object value : values) {
            this.items.add(value);
            list.add(value);
        }
        if (list.size() > 0) {
            int index1 = this.items.size();
            int index2 = index1 - 1 + list.size();
            this.fireAddedListModelListeners(list, index1, index2, false);
        }
    }

    @Override
    public boolean contains(Object obj) {
        return this.items.contains(obj);
    }

    @Override
    public void removeElement(Object ... values) {
        if (values.length == 0) {
            return;
        }
        HashMap<Object, Integer> indexMap = new HashMap<Object, Integer>();
        for (Object value : values) {
            indexMap.put(value, this.items.indexOf(value));
        }
        ArrayList indexList = new ArrayList();
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object value : values) {
            if (!this.items.remove(value)) continue;
            indexList.add(indexMap.get(value));
            list.add(value);
            this.lockeds.remove(value);
            this.checkeds.remove(value);
        }
        if (list.size() > 0) {
            Collections.sort(indexList);
            int index1 = -1;
            int index2 = -1;
            for (int i = 0; i < indexList.size(); ++i) {
                if (index1 == -1) {
                    index2 = index1 = ((Integer)indexList.get(i)).intValue();
                } else if ((Integer)indexList.get(i) > index2 + 1) {
                    this.fireRemovedListModelListeners(index1, index2, true);
                    index2 = index1 = ((Integer)indexList.get(i)).intValue();
                } else {
                    index2 = (Integer)indexList.get(i);
                }
                if (i != indexList.size() - 1) continue;
                this.fireRemovedListModelListeners(index1, index2, false);
            }
            this.fireRemovedListModelListeners(list, false);
        }
    }

    @Override
    public Object getElementAt(int index) {
        return this.items.get(index);
    }

    @Override
    public int getSize() {
        return this.items.size();
    }

    @Override
    public void addListModelListener(ListModelListener listener) {
        this.listenerList.add(ListModelListener.class, listener);
    }

    @Override
    public ListModelListener[] getListModelListeners() {
        return (ListModelListener[])this.listenerList.getListeners(ListModelListener.class);
    }

    @Override
    public void removeListModelListener(ListModelListener listener) {
        this.listenerList.remove(ListModelListener.class, listener);
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.listenerList.add(ListDataListener.class, l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.listenerList.remove(ListDataListener.class, l);
    }

    @Override
    public void removeChecks() {
        ArrayList<Object> list = null;
        if (this.listenerList.getListenerCount(ListCheckListener.class) > 0) {
            list = new ArrayList<Object>(this.checkeds);
        }
        this.checkeds.clear();
        if (list != null) {
            this.fireRemoveCheckListModelListeners(list, false);
        }
    }

    @Override
    public void removeLocks() {
        ArrayList<Object> list = null;
        if (this.listenerList.getListenerCount(ListLockListener.class) > 0) {
            list = new ArrayList<Object>(this.checkeds);
        }
        this.lockeds.clear();
        if (list != null) {
            this.fireRemoveLockListModelListeners(list, false);
        }
    }

    @Override
    public int getLocksCount() {
        return this.lockeds.size();
    }

    @Override
    public int getChecksCount() {
        return this.checkeds.size();
    }

    @Override
    public void checkAll() {
        ArrayList<Object> list = null;
        if (this.listenerList.getListenerCount(ListCheckListener.class) > 0) {
            list = new ArrayList<Object>(this.items);
        }
        this.checkeds.clear();
        this.checkeds.addAll(this.items);
        if (list != null) {
            this.fireAddCheckListModelListeners(list, false);
        }
    }

    @Override
    public void lockAll() {
        ArrayList<Object> list = null;
        if (this.listenerList.getListenerCount(ListLockListener.class) > 0) {
            list = new ArrayList<Object>(this.items);
        }
        this.lockeds.clear();
        this.lockeds.addAll(this.items);
        if (list != null) {
            this.fireAddLockListModelListeners(list, false);
        }
    }
}

