/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui.dialogs;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.japura.gui.WrapLabel;
import org.japura.gui.dialogs.DialogBuilder;

public class CustomDialog {
    private static Icon defaultDialogIcon;
    private Integer defaultButtonForDialogClose;
    private Integer result;
    private Integer focusedButton;
    private JDialog dialog;
    private Map<Integer, JButton> buttons;
    private Map<Integer, List<ActionListener>> buttonActions;
    private LinkedHashMap<Component, Integer> contents;
    private int defaultGap = 7;
    private final String title;
    private Icon dialogIcon;
    private Icon messageIcon;

    public static void setDefaultDialogIcon(Icon icon) {
        if (icon != null) {
            defaultDialogIcon = icon;
        }
    }

    public static Icon getDefaultDialogIcon() {
        return defaultDialogIcon;
    }

    public CustomDialog(String title) {
        this(title, null);
    }

    public CustomDialog(String title, String message) {
        if (title == null) {
            title = "";
        }
        this.buttons = new HashMap<Integer, JButton>();
        this.buttonActions = new HashMap<Integer, List<ActionListener>>();
        this.title = title;
        this.contents = new LinkedHashMap();
        if (message != null) {
            this.addMessageBlock(message);
        }
        if (CustomDialog.getDefaultDialogIcon() != null) {
            this.setDialogIcon(CustomDialog.getDefaultDialogIcon());
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setDefaultButtonForDialogClose(Integer button) {
        this.defaultButtonForDialogClose = button;
    }

    public Integer getDefaultButtonForDialogClose() {
        return this.defaultButtonForDialogClose;
    }

    private JDialog getDialog() {
        return this.dialog;
    }

    public void setDialogIcon(Icon dialogIcon) {
        this.dialogIcon = dialogIcon;
    }

    public Icon getDialogIcon() {
        return this.dialogIcon;
    }

    public Icon getMessageIcon() {
        return this.messageIcon;
    }

    public void setMessageIcon(Icon messageIcon) {
        this.messageIcon = messageIcon;
    }

    public LinkedHashMap<Component, Integer> getContents() {
        return new LinkedHashMap<Component, Integer>(this.contents);
    }

    private void fireButtonActions(int button, ActionEvent e) {
        this.setResult(new Integer(button));
        this.getDialog().dispose();
        for (ActionListener listener : this.buttonActions.get(button)) {
            listener.actionPerformed(e);
        }
    }

    public int addButton(String text) {
        for (JButton otherButton : this.buttons.values()) {
            if (!otherButton.getText().equals(text)) continue;
            throw new IllegalArgumentException("Button already exists: " + text);
        }
        JButton button = new JButton();
        button.setText(text);
        final Integer pos = new Integer(this.buttons.size());
        button.setName(text);
        this.buttons.put(pos, button);
        this.buttonActions.put(pos, new ArrayList());
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomDialog.this.fireButtonActions(pos, e);
            }
        });
        return pos;
    }

    public Integer show() {
        return this.show(null);
    }

    public Integer show(Component owner) {
        Window window = null;
        if (owner != null) {
            window = SwingUtilities.getWindowAncestor(owner);
        }
        return this.show(window);
    }

    public Integer show(Window owner) {
        this.dialog = DialogBuilder.getDefaultDialogBuilder().buildDialog(this);
        this.getDialog().pack();
        this.getDialog().setLocationRelativeTo(owner);
        this.getDialog().setVisible(true);
        return this.result;
    }

    protected void setResult(Integer result) {
        this.result = result;
    }

    public int getButtonsCount() {
        return this.buttons.size();
    }

    public JButton getButton(int buttonIndex) {
        Integer index = new Integer(buttonIndex);
        return this.buttons.get(index);
    }

    public void setFocusedButton(int button) {
        JButton b = this.getButton(button);
        if (b != null) {
            this.focusedButton = new Integer(button);
        }
    }

    public Integer getFocusedButton() {
        return this.focusedButton;
    }

    public String getButtonText(int button) {
        JButton b = this.getButton(button);
        if (b == null) {
            return null;
        }
        return b.getText();
    }

    public void setButtonText(int button, String text) {
        JButton b = this.getButton(button);
        if (b != null && text != null) {
            b.setText(text);
        }
    }

    public void setButtonEnabled(int button, boolean enabled) {
        JButton b = this.getButton(button);
        if (b != null) {
            b.setEnabled(enabled);
        }
    }

    public boolean isButtonEnabled(int button) {
        JButton b = this.getButton(button);
        if (b != null) {
            return b.isEnabled();
        }
        return false;
    }

    public void addButtonActionKeyCode(int button, final int keyCode) {
        final JButton b = this.getButton(button);
        if (b != null) {
            b.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == keyCode) {
                        b.doClick();
                    }
                }
            });
        }
    }

    public void addButtonAction(int button, ActionListener actionListener) {
        Integer index = new Integer(button);
        List<ActionListener> list = this.buttonActions.get(index);
        if (list != null) {
            list.add(actionListener);
        }
    }

    public void addContent(Component content) {
        this.addContent(content, this.defaultGap);
    }

    public void addContent(Component content, int topMargin) {
        this.contents.put(content, Math.max(topMargin, 0));
    }

    public void addMessageBlock(String message) {
        this.addMessageBlock(message, this.defaultGap);
    }

    public void addMessageBlock(String message, int topMargin) {
        WrapLabel wrapLabel = new WrapLabel(message);
        wrapLabel.setWrapWidth(450);
        this.addContent(wrapLabel, topMargin);
    }
}

