/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;

class WrapperComponent
extends JLayeredPane
implements MouseListener {
    private static final long serialVersionUID = 2895107538779323011L;
    private JComponent component;
    private JPanel filterPanel = new JPanel();
    private MouseListener mouseHandler;

    public WrapperComponent(JComboBox component) {
        this(component, null);
    }

    public WrapperComponent(JComboBox component, MouseListener mouseListener) {
        this.filterPanel.setOpaque(false);
        this.mouseHandler = mouseListener;
        this.component = component;
        this.add((Component)component, JLayeredPane.DEFAULT_LAYER);
        this.add((Component)this.filterPanel, (Object)(JLayeredPane.DEFAULT_LAYER + 1));
        this.filterPanel.addMouseListener(this);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.component.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.component.getMinimumSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.component.getMaximumSize();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.component.setEnabled(enabled);
        this.filterPanel.setEnabled(enabled);
    }

    @Override
    public void doLayout() {
        Insets insets = this.getInsets();
        int top = insets.top;
        int bottom = this.getHeight() - insets.bottom;
        int left = insets.left;
        int right = this.getWidth() - insets.right;
        this.component.setBounds(left, top, right - left, bottom - top);
        this.filterPanel.setBounds(left, top, right - left, bottom - top);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.isEnabled() && this.mouseHandler != null) {
            e.setSource(this.component);
            this.mouseHandler.mouseReleased(e);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.isEnabled()) {
            this.component.requestFocusInWindow();
            if (this.mouseHandler != null) {
                e.setSource(this.component);
                this.mouseHandler.mousePressed(e);
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.isEnabled()) {
            e.setSource(this.component);
            this.component.dispatchEvent(e);
            if (this.mouseHandler != null) {
                this.mouseHandler.mouseExited(e);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.isEnabled()) {
            e.setSource(this.component);
            this.component.dispatchEvent(e);
            if (this.mouseHandler != null) {
                this.mouseHandler.mouseEntered(e);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.isEnabled() && this.mouseHandler != null) {
            e.setSource(this.component);
            this.mouseHandler.mouseClicked(e);
        }
    }
}

