/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.zelluloid;

import java.io.InputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import net.xeoh.plugins.base.annotations.PluginImplementation;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.MediaSearchOptions;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.UnsupportedMediaTypeException;
import org.tinymediamanager.scraper.entities.Certification;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCastMember;
import org.tinymediamanager.scraper.entities.MediaGenres;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.http.CachedUrl;
import org.tinymediamanager.scraper.mediaprovider.IMovieMetadataProvider;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.scraper.zelluloid.SearchTitleWithGoogle;

@PluginImplementation
public class ZelluloidMetadataProvider
implements IMovieMetadataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZelluloidMetadataProvider.class);
    private static final String BASE_URL = "http://www.zelluloid.de";
    private static final String PAGE_ENCODING = "ISO-8859-1";
    private static MediaProviderInfo providerInfo = ZelluloidMetadataProvider.createMediaProviderInfo();

    private static MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo providerInfo = new MediaProviderInfo("zelluloid", "zelluloid.de", "<html><h3>Zelluloid.de</h3><br />Scraper for the german site zelluloid.de which is able to scrape movie metadata<br /><br />Available languages: german</html>", ZelluloidMetadataProvider.class.getResource("/zelluloid_de.png"));
        providerInfo.setVersion(ZelluloidMetadataProvider.class);
        return providerInfo;
    }

    public MediaProviderInfo getProviderInfo() {
        return providerInfo;
    }

    public MediaMetadata getMetadata(MediaScrapeOptions options) throws Exception {
        LOGGER.debug("getMetadata() " + options.toString());
        if (options.getType() != MediaType.MOVIE) {
            throw new UnsupportedMediaTypeException(options.getType());
        }
        String id = "";
        if (StringUtils.isNotBlank((CharSequence)options.getId(providerInfo.getId()))) {
            id = options.getId(providerInfo.getId());
        }
        if (StringUtils.isBlank((CharSequence)id) && options.getResult() != null) {
            id = StringUtils.isEmpty((CharSequence)options.getResult().getId()) ? StrgUtils.substr((String)options.getResult().getUrl(), (String)"id=(.*?)") : options.getResult().getId();
        }
        if (StringUtils.isBlank((CharSequence)id) && StringUtils.isBlank((CharSequence)options.getResult().getUrl())) {
            throw new Exception("cannot scrape without id and url");
        }
        String detailurl = "http://www.zelluloid.de/filme/index.php3?id=" + id;
        if (StringUtils.isBlank((CharSequence)id)) {
            detailurl = options.getResult().getUrl();
        }
        MediaMetadata md = new MediaMetadata(providerInfo.getId());
        try {
            Elements ratings;
            String rt;
            CachedUrl url = new CachedUrl(detailurl);
            InputStream in = url.getInputStream();
            Document doc = Jsoup.parse((InputStream)in, (String)PAGE_ENCODING, (String)"");
            in.close();
            String title = doc.getElementsByAttributeValue("property", "og:title").attr("content").trim();
            md.setTitle(title);
            String plot = doc.getElementsByAttributeValue("class", "bigtext").text();
            md.setPlot(plot);
            md.setTagline(plot.length() > 150 ? plot.substring(0, 150) : plot);
            Elements el = doc.getElementsByAttributeValueStarting("src", "/images/poster");
            if (el.size() == 1) {
                MediaArtwork ma = new MediaArtwork(providerInfo.getId(), MediaArtwork.MediaArtworkType.POSTER);
                ma.setPreviewUrl(BASE_URL + ((Element)el.get(0)).attr("src"));
                ma.setDefaultUrl(BASE_URL + ((Element)el.get(0)).attr("src"));
                ma.setLanguage(options.getLanguage().getLanguage());
                md.addMediaArt(ma);
            }
            if ((el = doc.getElementsByAttributeValueContaining("href", "az.php3?j=")).size() == 1) {
                try {
                    md.setYear(Integer.parseInt(((Element)el.get(0)).text()));
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            if ((el = doc.getElementsByAttributeValueContaining("href", "?v=w")).size() > 0) {
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
                    Date d = sdf.parse(((Element)el.get(0)).text());
                    md.setReleaseDate(d);
                }
                catch (Exception e) {
                    LOGGER.warn("cannot parse cinema release date: " + ((Element)el.get(0)).text());
                }
            }
            md.setOriginalTitle(StrgUtils.substr((String)doc.toString(), (String)"Originaltitel: (.*?)\\<"));
            if (StringUtils.isEmpty((CharSequence)md.getOriginalTitle())) {
                md.setOriginalTitle(md.getTitle());
            }
            if (!(rt = StrgUtils.substr((String)doc.toString(), (String)"ca.&nbsp;(.*?)&nbsp;min")).isEmpty()) {
                try {
                    md.setRuntime(Integer.valueOf(rt).intValue());
                }
                catch (Exception e2) {
                    LOGGER.warn("cannot convert runtime: " + rt);
                }
            }
            el = doc.getElementsByAttributeValueContaining("href", "az.php3?g=");
            for (Element g : el) {
                String gid = g.attr("href").substring(g.attr("href").lastIndexOf(61) + 1);
                md.addGenre(this.getTmmGenre(gid));
            }
            String fsk = StrgUtils.substr((String)doc.toString(), (String)"FSK: (.*?)[,<]");
            if (!fsk.isEmpty()) {
                md.addCertification(Certification.findCertification((String)fsk));
            }
            if ((ratings = doc.getElementsByAttributeValue("class", "ratingBarTable")).size() == 2) {
                Element e = (Element)ratings.get(1);
                String r = e.getElementsByTag("div").text().replace("%", "");
                try {
                    md.setRating(Float.valueOf(r).floatValue() / 10.0f);
                }
                catch (Exception e2) {
                    LOGGER.warn("cannot convert rating: " + r);
                }
            }
            doc = null;
            String detailsUrl = "http://www.zelluloid.de/filme/details.php3?id=" + id;
            try {
                url = new CachedUrl(detailsUrl);
                in = url.getInputStream();
                doc = Jsoup.parse((InputStream)in, (String)PAGE_ENCODING, (String)"");
                in.close();
            }
            catch (Exception e) {
                LOGGER.error("failed to get details: " + e.getMessage());
            }
            if (doc != null) {
                Element tab = doc.getElementById("ccdetails");
                int header = 0;
                String lastRole = "";
                for (Element tr : tab.getElementsByTag("tr")) {
                    if (tr.toString().contains("dyngfx")) {
                        if (tr.toString().contains("Besetzung")) {
                            header = 1;
                            continue;
                        }
                        if (tr.toString().contains("Crew")) {
                            header = 2;
                            continue;
                        }
                        if (tr.toString().contains("Produktion")) {
                            header = 3;
                            continue;
                        }
                        if (tr.toString().contains("Verleih")) {
                            header = 4;
                            continue;
                        }
                        if (!tr.toString().contains("Alternativtitel")) continue;
                        header = 5;
                        continue;
                    }
                    MediaCastMember mcm = new MediaCastMember();
                    el = tr.getElementsByTag("td");
                    if (header == 1) {
                        String role;
                        if (el.size() != 2 || (role = "" + ((Element)el.get(0)).text().trim()).equals("\u00a0") || StringUtils.isBlank((CharSequence)role)) continue;
                        mcm.setCharacter(role);
                        mcm.setName(((Element)el.get(1)).getElementsByTag("a").text());
                        mcm.setId(StrgUtils.substr((String)((Element)el.get(1)).getElementsByTag("a").attr("href"), (String)"id=(\\d+)"));
                        mcm.setType(MediaCastMember.CastType.ACTOR);
                        md.addCastMember(mcm);
                        continue;
                    }
                    if (header == 2) {
                        if (el.size() != 2) continue;
                        String crewrole = ((Element)el.get(0)).html().trim();
                        mcm.setName(((Element)el.get(1)).getElementsByTag("a").text());
                        if (crewrole.equals("&nbsp;")) {
                            crewrole = lastRole;
                        } else {
                            lastRole = crewrole;
                        }
                        mcm.setPart(crewrole);
                        switch (crewrole) {
                            case "Regie": {
                                mcm.setType(MediaCastMember.CastType.DIRECTOR);
                                break;
                            }
                            case "Drehbuch": {
                                mcm.setType(MediaCastMember.CastType.WRITER);
                                break;
                            }
                            case "Produktion": {
                                mcm.setType(MediaCastMember.CastType.PRODUCER);
                                break;
                            }
                            default: {
                                mcm.setType(MediaCastMember.CastType.OTHER);
                            }
                        }
                        mcm.setId(StrgUtils.substr((String)((Element)el.get(1)).getElementsByTag("a").attr("href"), (String)"id=(\\d+)"));
                        md.addCastMember(mcm);
                        continue;
                    }
                    if (header != 3) continue;
                    md.addProductionCompany(((Element)el.get(0)).text());
                }
            }
            doc = null;
            String linksUrl = "http://www.zelluloid.de/filme/links.php3?id=" + id;
            try {
                url = new CachedUrl(linksUrl);
                in = url.getInputStream();
                doc = Jsoup.parse((InputStream)in, (String)PAGE_ENCODING, (String)"");
                in.close();
            }
            catch (Exception e) {
                LOGGER.error("failed to get links page: " + e.getMessage());
            }
            if (doc != null && (el = doc.getElementsByAttributeValueContaining("href", "german.imdb.com")) != null && el.size() > 0) {
                String imdb = StrgUtils.substr((String)((Element)el.get(0)).attr("href"), (String)"(tt\\d{7})");
                if (imdb.isEmpty()) {
                    imdb = "tt" + StrgUtils.substr((String)((Element)el.get(0)).attr("href"), (String)"\\?(\\d+)");
                }
                md.setId("imdb", (Object)imdb);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error parsing " + detailurl);
            throw e;
        }
        return md;
    }

    public List<MediaSearchResult> search(MediaSearchOptions options) throws Exception {
        LOGGER.debug("search() " + options.toString());
        if (options.getMediaType() != MediaType.MOVIE) {
            throw new UnsupportedMediaTypeException(options.getMediaType());
        }
        int year = 0;
        if (options.getYear() != 0) {
            year = options.getYear();
        }
        ArrayList<MediaSearchResult> resultList = new ArrayList<MediaSearchResult>();
        String searchUrl = "";
        String searchTerm = "";
        String imdb = "";
        if (!StringUtils.isNotEmpty((CharSequence)options.getQuery())) {
            LOGGER.debug("empty searchString");
            return resultList;
        }
        searchTerm = options.getQuery();
        searchUrl = "http://www.zelluloid.de/suche/index.php3?qstring=" + URLEncoder.encode(searchTerm, "UTF-8");
        LOGGER.debug("search for : " + searchTerm);
        searchTerm = MetadataUtil.removeNonSearchCharacters((String)searchTerm);
        Document doc = null;
        try {
            CachedUrl url = new CachedUrl(searchUrl);
            InputStream in = url.getInputStream();
            doc = Jsoup.parse((InputStream)in, (String)PAGE_ENCODING, (String)"");
            in.close();
        }
        catch (Exception e) {
            LOGGER.error("failed to search for " + searchTerm + ": " + e.getMessage());
        }
        if (doc == null || doc.text().contains("Interner Fehler")) {
            SearchTitleWithGoogle gs = new SearchTitleWithGoogle();
            List<MediaSearchResult> gr = gs.search("zelluloid.de", this.getProviderInfo(), options);
            for (MediaSearchResult msr : gr) {
                if (!msr.getUrl().contains("/filme/index.php3")) continue;
                String id = StrgUtils.substr((String)msr.getUrl(), (String)"id=(.*)");
                msr.setId(id);
                resultList.add(msr);
            }
            return resultList;
        }
        Elements filme = doc.getElementsByTag("tr");
        for (Element tr : filme) {
            Elements as;
            if (tr.getElementsByTag("tr").size() > 1 || (as = tr.getElementsByAttributeValueStarting("href", "hit.php3?hit=")).isEmpty() || tr.text().contains("TV-Serie")) continue;
            try {
                Element a = as.first();
                String id = StrgUtils.substr((String)a.attr("href"), (String)"-movie-(.*?)-");
                MediaSearchResult sr = new MediaSearchResult(providerInfo.getId(), options.getMediaType());
                sr.setId(id);
                if (StringUtils.isEmpty((CharSequence)sr.getTitle())) {
                    if (a.html().contains("nobr")) {
                        sr.setTitle(a.ownText());
                    } else {
                        sr.setTitle(a.text());
                    }
                }
                LOGGER.debug("found movie " + sr.getTitle());
                sr.setOriginalTitle(a.getElementsByTag("span").text());
                try {
                    sr.setYear(Integer.parseInt(StrgUtils.substr((String)tr.getElementsByTag("nobr").text(), (String)".*(\\d{4}).*")));
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                sr.setUrl("http://www.zelluloid.de/filme/index.php3?id=" + id);
                if (imdb.equals(sr.getIMDBId())) {
                    sr.setScore(1.0f);
                } else {
                    float score = MetadataUtil.calculateScore((String)searchTerm, (String)sr.getTitle());
                    if (this.yearDiffers(year, sr.getYear())) {
                        float diff = (float)Math.abs(year - sr.getYear()) / 100.0f;
                        LOGGER.debug("parsed year does not match search result year - downgrading score by " + diff);
                        score -= diff;
                    }
                    sr.setScore(score);
                }
                resultList.add(sr);
            }
            catch (Exception e) {
                LOGGER.warn("error parsing movie result: " + e.getMessage());
            }
        }
        LOGGER.debug("found " + resultList.size() + " search results");
        if (resultList.isEmpty()) {
            if (!doc.getElementsByTag("title").text().contains("Suche nach")) {
                MediaSearchResult msr = new MediaSearchResult(providerInfo.getId(), options.getMediaType());
                Elements el = doc.getElementsByAttributeValueStarting("href", "index.php3?id=");
                if (el.size() > 0) {
                    msr.setId(StrgUtils.substr((String)((Element)el.get(0)).attr("href"), (String)"id=(\\d+)"));
                }
                msr.setTitle(StrgUtils.substr((String)doc.getElementsByTag("title").text(), (String)"(.*?)\\|").trim());
                el = doc.getElementsByAttributeValueContaining("href", "az.php3?j=");
                if (el.size() == 1) {
                    try {
                        msr.setYear(Integer.parseInt(((Element)el.get(0)).text()));
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                }
                resultList.add(msr);
            }
            return resultList;
        }
        Collections.sort(resultList);
        Collections.reverse(resultList);
        return resultList;
    }

    private boolean yearDiffers(Integer i1, Integer i2) {
        return i1 != null && i1 != 0 && i2 != null && i2 != 0 && i1 != i2;
    }

    private MediaGenres getTmmGenre(String genre) {
        MediaGenres g = null;
        if (genre.isEmpty()) {
            return g;
        }
        try {
            int gid = Integer.parseInt(genre);
            switch (gid) {
                case 2: {
                    g = MediaGenres.COMEDY;
                    break;
                }
                case 3: {
                    g = MediaGenres.ACTION;
                    break;
                }
                case 4: {
                    g = MediaGenres.THRILLER;
                    break;
                }
                case 5: {
                    g = MediaGenres.WAR;
                    break;
                }
                case 6: {
                    g = MediaGenres.SCIENCE_FICTION;
                    break;
                }
                case 7: {
                    g = MediaGenres.FANTASY;
                    break;
                }
                case 9: {
                    g = MediaGenres.ANIMATION;
                    break;
                }
                case 10: {
                    g = MediaGenres.ANIMATION;
                    break;
                }
                case 11: {
                    g = null;
                    break;
                }
                case 13: {
                    g = MediaGenres.ANIMATION;
                    break;
                }
                case 14: {
                    g = MediaGenres.DRAMA;
                    break;
                }
                case 15: {
                    g = MediaGenres.DOCUMENTARY;
                    break;
                }
                case 16: {
                    g = MediaGenres.ADVENTURE;
                    break;
                }
                case 17: {
                    g = MediaGenres.ROMANCE;
                    break;
                }
                case 18: {
                    g = MediaGenres.ANIMATION;
                    break;
                }
                case 19: {
                    g = MediaGenres.ROAD_MOVIE;
                    break;
                }
                case 22: {
                    g = MediaGenres.HORROR;
                    break;
                }
                case 23: {
                    g = MediaGenres.EROTIC;
                    break;
                }
                case 25: {
                    g = MediaGenres.DISASTER;
                    break;
                }
                case 26: {
                    g = MediaGenres.THRILLER;
                    break;
                }
                case 27: {
                    g = MediaGenres.SPORT;
                    break;
                }
                case 28: {
                    g = MediaGenres.BIOGRAPHY;
                    break;
                }
                case 29: {
                    g = MediaGenres.HISTORY;
                    break;
                }
                case 30: {
                    g = MediaGenres.SCIENCE_FICTION;
                    break;
                }
                case 31: {
                    g = MediaGenres.SCIENCE_FICTION;
                    break;
                }
                case 32: {
                    g = MediaGenres.SCIENCE_FICTION;
                    break;
                }
                case 33: {
                    g = MediaGenres.WESTERN;
                    break;
                }
                case 34: {
                    g = MediaGenres.CRIME;
                    break;
                }
                case 35: {
                    g = MediaGenres.WAR;
                    break;
                }
                case 36: {
                    g = MediaGenres.CRIME;
                    break;
                }
                case 37: {
                    g = MediaGenres.HORROR;
                    break;
                }
                case 38: {
                    g = MediaGenres.MUSICAL;
                    break;
                }
                case 39: {
                    g = MediaGenres.MUSIC;
                    break;
                }
                case 40: {
                    g = MediaGenres.FAMILY;
                    break;
                }
                case 42: {
                    g = MediaGenres.MYSTERY;
                    break;
                }
                case 43: {
                    g = MediaGenres.SPORT;
                    break;
                }
                case 44: {
                    g = MediaGenres.REALITY_TV;
                    break;
                }
                case 45: {
                    g = MediaGenres.WAR;
                    break;
                }
                case 46: {
                    g = MediaGenres.ANIMATION;
                    break;
                }
                case 47: {
                    g = MediaGenres.INDIE;
                    break;
                }
                case 48: {
                    g = MediaGenres.HORROR;
                    break;
                }
                case 49: {
                    g = MediaGenres.SCIENCE_FICTION;
                    break;
                }
                case 50: {
                    g = MediaGenres.FANTASY;
                    break;
                }
                case 51: {
                    g = MediaGenres.CRIME;
                    break;
                }
                case 52: {
                    g = MediaGenres.SILENT_MOVIE;
                    break;
                }
                case 53: {
                    g = MediaGenres.SHORT;
                    break;
                }
                case 54: {
                    g = MediaGenres.INDIE;
                    break;
                }
                case 55: {
                    g = MediaGenres.FAMILY;
                    break;
                }
                case 56: {
                    g = MediaGenres.SCIENCE_FICTION;
                    break;
                }
                case 59: {
                    g = MediaGenres.FAMILY;
                    break;
                }
                case 61: {
                    g = MediaGenres.SERIES;
                    break;
                }
                case 62: {
                    g = MediaGenres.HISTORY;
                    break;
                }
                case 63: {
                    g = MediaGenres.FOREIGN;
                    break;
                }
                case 64: {
                    g = MediaGenres.GAME_SHOW;
                    break;
                }
                case 65: {
                    g = null;
                    break;
                }
                case 68: {
                    g = MediaGenres.HORROR;
                }
            }
        }
        catch (Exception e) {
            g = MediaGenres.getGenre((String)genre);
        }
        return g;
    }
}

