/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.tmdb;

import com.uwetrottmann.tmdb2.Tmdb;
import com.uwetrottmann.tmdb2.entities.AppendToResponse;
import com.uwetrottmann.tmdb2.entities.CastMember;
import com.uwetrottmann.tmdb2.entities.CrewMember;
import com.uwetrottmann.tmdb2.entities.FindResults;
import com.uwetrottmann.tmdb2.entities.Genre;
import com.uwetrottmann.tmdb2.entities.Keyword;
import com.uwetrottmann.tmdb2.entities.Movie;
import com.uwetrottmann.tmdb2.entities.MovieKeywords;
import com.uwetrottmann.tmdb2.entities.MovieResultsPage;
import com.uwetrottmann.tmdb2.entities.ProductionCompany;
import com.uwetrottmann.tmdb2.entities.ProductionCountry;
import com.uwetrottmann.tmdb2.entities.ReleaseDate;
import com.uwetrottmann.tmdb2.entities.ReleaseDatesResult;
import com.uwetrottmann.tmdb2.entities.SpokenLanguage;
import com.uwetrottmann.tmdb2.enumerations.AppendToResponseItem;
import com.uwetrottmann.tmdb2.enumerations.ExternalSource;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.MediaSearchOptions;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.Certification;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCastMember;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.tmdb.TmdbConnectionCounter;
import org.tinymediamanager.scraper.tmdb.TmdbMetadataProvider;
import org.tinymediamanager.scraper.util.LanguageUtils;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MetadataUtil;

class TmdbMovieMetadataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmdbMovieMetadataProvider.class);
    private Tmdb api;

    public TmdbMovieMetadataProvider(Tmdb api) {
        this.api = api;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<MediaSearchResult> search(MediaSearchOptions query) throws Exception {
        LOGGER.debug("search() " + query.toString());
        ArrayList<MediaSearchResult> resultList = new ArrayList<MediaSearchResult>();
        String searchString = "";
        Integer year = null;
        if (query.getMediaType() != MediaType.MOVIE) {
            throw new Exception("wrong media type for this scraper");
        }
        if (StringUtils.isEmpty((CharSequence)searchString) && StringUtils.isNotEmpty((CharSequence)query.getQuery())) {
            searchString = query.getQuery();
        }
        if (query.getYear() != 0) {
            year = query.getYear();
        }
        if (StringUtils.isEmpty((CharSequence)searchString)) {
            LOGGER.debug("TMDB Scraper: empty searchString");
            return resultList;
        }
        boolean adult = TmdbMetadataProvider.providerInfo.getConfig().getValueAsBool("includeAdult");
        searchString = MetadataUtil.removeNonSearchCharacters((String)searchString);
        String language = query.getLanguage().getLanguage();
        if (StringUtils.isNotBlank((CharSequence)query.getLanguage().getCountry())) {
            language = language + "-" + query.getLanguage().getCountry();
        }
        String imdbId = "";
        int tmdbId = 0;
        LOGGER.info("========= BEGIN TMDB Scraper Search for: " + searchString);
        Tmdb tmdb = this.api;
        synchronized (tmdb) {
            MovieResultsPage resultsPage;
            if (query.getTmdbId() != 0) {
                TmdbConnectionCounter.trackConnections();
                tmdbId = query.getTmdbId();
                try {
                    Movie movie = (Movie)this.api.moviesService().summary(tmdbId, language, null).execute().body();
                    MediaSearchResult result = this.morphMovieToSearchResult(movie);
                    resultList.add(result);
                }
                catch (Exception e) {
                    LOGGER.warn("problem getting data vom tmdb: " + e.getMessage());
                }
                LOGGER.debug("found " + resultList.size() + " results with TMDB id");
            }
            if (resultList.size() == 0 && StringUtils.isNotEmpty((CharSequence)query.getImdbId())) {
                TmdbConnectionCounter.trackConnections();
                imdbId = query.getImdbId();
                try {
                    FindResults findResults = (FindResults)this.api.findService().find(imdbId, null, language).execute().body();
                    if (findResults != null && findResults.movie_results != null) {
                        for (Movie movie : findResults.movie_results) {
                            resultList.add(this.morphMovieToSearchResult(movie));
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("problem getting data vom tmdb: " + e.getMessage());
                }
                LOGGER.debug("found " + resultList.size() + " results with IMDB id");
            }
            if (resultList.size() == 0) {
                TmdbConnectionCounter.trackConnections();
                try {
                    resultsPage = (MovieResultsPage)this.api.searchService().movie(searchString, 1, language, adult, year, year, "phrase").execute().body();
                    if (resultsPage != null && resultsPage.results != null) {
                        for (Movie movie : resultsPage.results) {
                            resultList.add(this.morphMovieToSearchResult(movie));
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("problem getting data vom tmdb: " + e.getMessage());
                }
                LOGGER.debug("found " + resultList.size() + " results with search string");
            }
            if (resultList.size() == 0) {
                searchString = searchString.replaceFirst("\\s\\d{4}$", "");
                TmdbConnectionCounter.trackConnections();
                try {
                    resultsPage = (MovieResultsPage)this.api.searchService().movie(searchString, 1, language, adult, null, null, "phrase").execute().body();
                    if (resultsPage != null && resultsPage.results != null) {
                        for (Movie movie : resultsPage.results) {
                            resultList.add(this.morphMovieToSearchResult(movie));
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("problem getting data vom tmdb: " + e.getMessage());
                }
                LOGGER.debug("found " + resultList.size() + " results with search string without year");
            }
        }
        LOGGER.info("found " + resultList.size() + " results");
        if (resultList.isEmpty()) {
            return resultList;
        }
        for (MediaSearchResult result : resultList) {
            if (imdbId.equals(result.getIMDBId()) || String.valueOf(tmdbId).equals(result.getId())) {
                result.setScore(1.0f);
                continue;
            }
            float score = MetadataUtil.calculateScore((String)searchString, (String)result.getTitle());
            if (this.yearDiffers(year, result.getYear())) {
                float diff = (float)Math.abs(year - result.getYear()) / 100.0f;
                LOGGER.debug("parsed year does not match search result year - downgrading score by " + diff);
                score -= diff;
            }
            result.setScore(score);
        }
        return resultList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MediaMetadata getMetadata(MediaScrapeOptions options) throws Exception {
        LOGGER.debug("getMetadata() " + options.toString());
        MediaMetadata md = new MediaMetadata(TmdbMetadataProvider.providerInfo.getId());
        int tmdbId = 0;
        if (options.getResult() != null) {
            tmdbId = Integer.parseInt(options.getResult().getId());
        }
        if (tmdbId == 0) {
            try {
                tmdbId = Integer.parseInt(options.getId(TmdbMetadataProvider.providerInfo.getId()));
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
        }
        if (tmdbId == 0) {
            tmdbId = options.getTmdbId();
        }
        String imdbId = options.getImdbId();
        if (tmdbId == 0 && !MetadataUtil.isValidImdbId((String)imdbId)) {
            LOGGER.warn("not possible to scrape from TMDB - no tmdbId/imdbId found");
            return md;
        }
        String language = options.getLanguage().getLanguage();
        if (StringUtils.isNotBlank((CharSequence)options.getLanguage().getCountry())) {
            language = language + "-" + options.getLanguage().getCountry();
        }
        LOGGER.debug("TMDB: getMetadata: tmdbId = " + tmdbId + "; imdbId = " + imdbId);
        Movie movie = null;
        Tmdb tmdb = this.api;
        synchronized (tmdb) {
            if (tmdbId == 0 && MetadataUtil.isValidImdbId((String)imdbId)) {
                try {
                    int tempTmdbId = this.getTmdbIdFromImdbId(imdbId);
                    if (tempTmdbId > 0) {
                        TmdbConnectionCounter.trackConnections();
                        movie = (Movie)this.api.moviesService().summary(tempTmdbId, language, new AppendToResponse(AppendToResponseItem.CREDITS, AppendToResponseItem.RELEASE_DATES)).execute().body();
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("problem getting data vom tmdb: " + e.getMessage());
                }
            }
            if (movie == null && tmdbId != 0) {
                try {
                    TmdbConnectionCounter.trackConnections();
                    movie = (Movie)this.api.moviesService().summary(tmdbId, language, new AppendToResponse(AppendToResponseItem.CREDITS, AppendToResponseItem.RELEASE_DATES)).execute().body();
                }
                catch (Exception e) {
                    LOGGER.warn("problem getting data vom tmdb: " + e.getMessage());
                }
            }
        }
        if (movie == null) {
            LOGGER.warn("no result found");
            return md;
        }
        md = this.morphMovieToMediaMetadata(movie, options);
        try {
            TmdbConnectionCounter.trackConnections();
            MovieKeywords mk = (MovieKeywords)this.api.moviesService().keywords(tmdbId).execute().body();
            for (Keyword kw : mk.keywords) {
                switch (kw.name) {
                    case "aftercreditsstinger": 
                    case "duringcreditsstinger": {
                        md.addTag(kw.name);
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error getting keywords");
        }
        if (StringUtils.isBlank((CharSequence)movie.overview) && !"en".equalsIgnoreCase(options.getLanguage().getLanguage())) {
            Locale oldLang = options.getLanguage();
            try {
                options.setLanguage(new Locale("en"));
                MediaMetadata englishMd = this.getMetadata(options);
                if (StringUtils.isBlank((CharSequence)movie.overview) && !StringUtils.isBlank((CharSequence)englishMd.getPlot())) {
                    md.setPlot(englishMd.getPlot());
                }
                if (StringUtils.isBlank((CharSequence)movie.title) && !StringUtils.isBlank((CharSequence)englishMd.getTitle())) {
                    md.setTitle(englishMd.getTitle());
                }
                if (StringUtils.isBlank((CharSequence)movie.original_title) && !StringUtils.isBlank((CharSequence)englishMd.getOriginalTitle())) {
                    md.setOriginalTitle(englishMd.getOriginalTitle());
                }
                if (StringUtils.isBlank((CharSequence)movie.tagline) && !StringUtils.isBlank((CharSequence)englishMd.getTagline())) {
                    md.setTagline(englishMd.getTagline());
                }
            }
            catch (Exception e) {
            }
            finally {
                options.setLanguage(oldLang);
            }
        }
        return md;
    }

    int getTmdbIdFromImdbId(String imdbId) throws Exception {
        TmdbConnectionCounter.trackConnections();
        try {
            FindResults findResults = (FindResults)this.api.findService().find(imdbId, ExternalSource.IMDB_ID, null).execute().body();
            if (findResults != null && findResults.movie_results != null && !findResults.movie_results.isEmpty()) {
                return findResults.movie_results.get((int)0).id;
            }
        }
        catch (Exception e) {
            LOGGER.debug("failed to get tmdb id: " + e.getMessage());
        }
        return 0;
    }

    private MediaSearchResult morphMovieToSearchResult(Movie movie) {
        MediaSearchResult searchResult = new MediaSearchResult(TmdbMetadataProvider.providerInfo.getId(), MediaType.MOVIE);
        searchResult.setId(Integer.toString(movie.id));
        searchResult.setIMDBId(movie.imdb_id);
        searchResult.setTitle(movie.title);
        searchResult.setOriginalTitle(movie.original_title);
        searchResult.setPosterUrl(TmdbMetadataProvider.configuration.images.base_url + "w342" + movie.poster_path);
        if (movie.release_date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(movie.release_date);
            searchResult.setYear(calendar.get(1));
        }
        return searchResult;
    }

    private MediaMetadata morphMovieToMediaMetadata(Movie movie, MediaScrapeOptions options) {
        MediaMetadata md = new MediaMetadata(TmdbMetadataProvider.providerInfo.getId());
        md.setId(TmdbMetadataProvider.providerInfo.getId(), (Object)movie.id);
        md.setTitle(movie.title);
        md.setOriginalTitle(movie.original_title);
        md.setPlot(movie.overview);
        md.setTagline(movie.tagline);
        md.setRuntime(movie.runtime);
        md.setRating(movie.vote_average);
        md.setVoteCount(movie.vote_count);
        if (StringUtils.isNotBlank((CharSequence)movie.poster_path)) {
            MediaArtwork ma = new MediaArtwork(TmdbMetadataProvider.providerInfo.getId(), MediaArtwork.MediaArtworkType.POSTER);
            ma.setPreviewUrl(TmdbMetadataProvider.configuration.images.base_url + "w185" + movie.poster_path);
            ma.setDefaultUrl(TmdbMetadataProvider.configuration.images.base_url + "w342" + movie.poster_path);
            ma.setLanguage(options.getLanguage().getLanguage());
            ma.setTmdbId(movie.id.intValue());
            md.addMediaArt(ma);
        }
        for (SpokenLanguage lang : ListUtils.nullSafe(movie.spoken_languages)) {
            if (TmdbMetadataProvider.providerInfo.getConfig().getValueAsBool("scrapeLanguageNames").booleanValue()) {
                md.addSpokenLanguage(LanguageUtils.getLocalizedLanguageNameFromLocalizedString((Locale)options.getLanguage(), (String[])new String[]{lang.name, lang.iso_639_1}));
                continue;
            }
            md.addSpokenLanguage(lang.iso_639_1);
        }
        for (ProductionCountry country : ListUtils.nullSafe(movie.production_countries)) {
            if (TmdbMetadataProvider.providerInfo.getConfig().getValueAsBool("scrapeLanguageNames").booleanValue()) {
                md.addCountry(LanguageUtils.getLocalizedCountryForLanguage((Locale)options.getLanguage(), (String[])new String[]{country.name, country.iso_3166_1}));
                continue;
            }
            md.addCountry(country.iso_3166_1);
        }
        if (MetadataUtil.isValidImdbId((String)movie.imdb_id)) {
            md.setId("imdb", (Object)movie.imdb_id);
        }
        for (ProductionCompany company : ListUtils.nullSafe(movie.production_companies)) {
            md.addProductionCompany(company.name.trim());
        }
        Date releaseDate = movie.release_date;
        if (releaseDate != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(releaseDate);
            md.setYear(calendar.get(1));
        }
        md.setReleaseDate(releaseDate);
        if (movie.release_dates != null) {
            for (ReleaseDatesResult countries : ListUtils.nullSafe(movie.release_dates.results)) {
                if (options.getCountry() != null && options.getCountry().getAlpha2().compareToIgnoreCase(countries.iso_3166_1) != 0) continue;
                for (ReleaseDate countryReleaseDate : ListUtils.nullSafe(countries.release_dates)) {
                    if (StringUtils.isEmpty((CharSequence)countryReleaseDate.certification)) continue;
                    md.addCertification(Certification.getCertification((String)countries.iso_3166_1, (String)countryReleaseDate.certification));
                }
            }
        }
        if (movie.credits != null) {
            MediaCastMember cm;
            for (CastMember castMember : ListUtils.nullSafe(movie.credits.cast)) {
                cm = new MediaCastMember();
                cm.setType(MediaCastMember.CastType.ACTOR);
                cm.setCharacter(castMember.character);
                cm.setName(castMember.name);
                if (!StringUtils.isEmpty((CharSequence)castMember.profile_path)) {
                    cm.setImageUrl(TmdbMetadataProvider.configuration.images.base_url + "w185" + castMember.profile_path);
                }
                md.addCastMember(cm);
            }
            for (CrewMember crewMember : ListUtils.nullSafe(movie.credits.crew)) {
                cm = new MediaCastMember();
                if ("Director".equals(crewMember.job)) {
                    cm.setType(MediaCastMember.CastType.DIRECTOR);
                    cm.setPart(crewMember.department);
                } else if ("Writing".equals(crewMember.department)) {
                    cm.setType(MediaCastMember.CastType.WRITER);
                    cm.setPart(crewMember.department);
                } else {
                    if (!"Production".equals(crewMember.department)) continue;
                    cm.setType(MediaCastMember.CastType.PRODUCER);
                    cm.setPart(crewMember.job);
                }
                cm.setName(crewMember.name);
                if (!StringUtils.isEmpty((CharSequence)crewMember.profile_path)) {
                    cm.setImageUrl(TmdbMetadataProvider.configuration.images.base_url + "w185" + crewMember.profile_path);
                }
                md.addCastMember(cm);
            }
        }
        for (Genre genre : ListUtils.nullSafe(movie.genres)) {
            md.addGenre(TmdbMetadataProvider.getTmmGenre(genre));
        }
        if (movie.belongs_to_collection != null) {
            md.setId("tmdbSet", (Object)movie.belongs_to_collection.id);
            md.setCollectionName(movie.belongs_to_collection.name);
        }
        return md;
    }

    private boolean yearDiffers(Integer i1, Integer i2) {
        return i1 != null && i1 != 0 && i2 != null && i2 != 0 && i1 != i2;
    }
}

