/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.tmdb;

import com.uwetrottmann.tmdb2.Tmdb;
import com.uwetrottmann.tmdb2.TmdbInterceptor;
import com.uwetrottmann.tmdb2.entities.Configuration;
import com.uwetrottmann.tmdb2.entities.Genre;
import java.util.Collections;
import java.util.List;
import net.xeoh.plugins.base.annotations.PluginImplementation;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.MediaSearchOptions;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.UnsupportedMediaTypeException;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaEpisode;
import org.tinymediamanager.scraper.entities.MediaGenres;
import org.tinymediamanager.scraper.entities.MediaTrailer;
import org.tinymediamanager.scraper.http.TmmHttpClient;
import org.tinymediamanager.scraper.mediaprovider.IMovieArtworkProvider;
import org.tinymediamanager.scraper.mediaprovider.IMovieMetadataProvider;
import org.tinymediamanager.scraper.mediaprovider.IMovieSetMetadataProvider;
import org.tinymediamanager.scraper.mediaprovider.IMovieTrailerProvider;
import org.tinymediamanager.scraper.mediaprovider.ITvShowArtworkProvider;
import org.tinymediamanager.scraper.mediaprovider.ITvShowMetadataProvider;
import org.tinymediamanager.scraper.tmdb.TmdbArtworkProvider;
import org.tinymediamanager.scraper.tmdb.TmdbMovieMetadataProvider;
import org.tinymediamanager.scraper.tmdb.TmdbMovieSetMetadataProvider;
import org.tinymediamanager.scraper.tmdb.TmdbTrailerProvider;
import org.tinymediamanager.scraper.tmdb.TmdbTvShowMetadataProvider;
import org.tinymediamanager.scraper.util.ApiKey;

@PluginImplementation
public class TmdbMetadataProvider
implements IMovieMetadataProvider,
IMovieSetMetadataProvider,
ITvShowMetadataProvider,
IMovieArtworkProvider,
ITvShowArtworkProvider,
IMovieTrailerProvider {
    static Tmdb api;
    static MediaProviderInfo providerInfo;
    static Configuration configuration;

    private static MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo providerInfo = new MediaProviderInfo("tmdb", "themoviedb.org", "<html><h3>The Movie Database (TMDb)</h3><br />The largest free movie database maintained by the community. It provides metadata and artwork<br />in many different languages. Thus it is the first choice for non english users<br /><br />Available languages: multiple</html>", TmdbMetadataProvider.class.getResource("/themoviedb_org.png"));
        providerInfo.setVersion(TmdbMetadataProvider.class);
        providerInfo.getConfig().addBoolean("includeAdult", false);
        providerInfo.getConfig().addBoolean("scrapeLanguageNames", true);
        providerInfo.getConfig().load();
        return providerInfo;
    }

    private static synchronized void initAPI() throws Exception {
        if (api == null && (configuration = (Configuration)(api = new Tmdb(ApiKey.decryptApikey((String)"dj5KmN0AO0eFDMF1tybX3H+zxGpfm4pUQAlEhM3iah/g2kuCzUQVZiiJ+ceCP2DO")){

            @Override
            protected synchronized OkHttpClient okHttpClient() {
                OkHttpClient.Builder builder = TmmHttpClient.newBuilder((boolean)true);
                builder.addInterceptor((Interceptor)new TmdbInterceptor(this));
                return builder.build();
            }
        }).configurationService().configuration().execute().body()) == null) {
            throw new Exception("Invalid TMDB API key");
        }
    }

    public MediaProviderInfo getProviderInfo() {
        return providerInfo;
    }

    public List<MediaSearchResult> search(MediaSearchOptions query) throws Exception {
        List<MediaSearchResult> searchResults;
        TmdbMetadataProvider.initAPI();
        switch (query.getMediaType()) {
            case MOVIE: {
                searchResults = new TmdbMovieMetadataProvider(api).search(query);
                break;
            }
            case MOVIE_SET: {
                searchResults = new TmdbMovieSetMetadataProvider(api).search(query);
                break;
            }
            case TV_SHOW: {
                searchResults = new TmdbTvShowMetadataProvider(api).search(query);
                break;
            }
            default: {
                throw new UnsupportedMediaTypeException(query.getMediaType());
            }
        }
        Collections.sort(searchResults);
        Collections.reverse(searchResults);
        return searchResults;
    }

    public List<MediaEpisode> getEpisodeList(MediaScrapeOptions options) throws Exception {
        TmdbMetadataProvider.initAPI();
        switch (options.getType()) {
            case TV_SHOW: {
                return new TmdbTvShowMetadataProvider(api).getEpisodeList(options);
            }
        }
        throw new Exception("unsupported media type");
    }

    public MediaMetadata getMetadata(MediaScrapeOptions options) throws Exception {
        TmdbMetadataProvider.initAPI();
        switch (options.getType()) {
            case MOVIE: {
                return new TmdbMovieMetadataProvider(api).getMetadata(options);
            }
            case MOVIE_SET: {
                return new TmdbMovieSetMetadataProvider(api).getMetadata(options);
            }
            case TV_SHOW: 
            case TV_EPISODE: {
                return new TmdbTvShowMetadataProvider(api).getMetadata(options);
            }
        }
        throw new UnsupportedMediaTypeException(options.getType());
    }

    public List<MediaArtwork> getArtwork(MediaScrapeOptions options) throws Exception {
        TmdbMetadataProvider.initAPI();
        return new TmdbArtworkProvider(api).getArtwork(options);
    }

    public List<MediaTrailer> getTrailers(MediaScrapeOptions options) throws Exception {
        TmdbMetadataProvider.initAPI();
        switch (options.getType()) {
            case MOVIE: {
                return new TmdbTrailerProvider(api).getTrailers(options);
            }
        }
        throw new Exception("unsupported media type");
    }

    public int getTmdbIdFromImdbId(String imdbId) throws Exception {
        TmdbMetadataProvider.initAPI();
        return new TmdbMovieMetadataProvider(api).getTmdbIdFromImdbId(imdbId);
    }

    static MediaGenres getTmmGenre(Genre genre) {
        MediaGenres g = null;
        switch (genre.id) {
            case 28: {
                g = MediaGenres.ACTION;
                break;
            }
            case 12: {
                g = MediaGenres.ADVENTURE;
                break;
            }
            case 16: {
                g = MediaGenres.ANIMATION;
                break;
            }
            case 35: {
                g = MediaGenres.COMEDY;
                break;
            }
            case 80: {
                g = MediaGenres.CRIME;
                break;
            }
            case 105: {
                g = MediaGenres.DISASTER;
                break;
            }
            case 99: {
                g = MediaGenres.DOCUMENTARY;
                break;
            }
            case 18: {
                g = MediaGenres.DRAMA;
                break;
            }
            case 82: {
                g = MediaGenres.EASTERN;
                break;
            }
            case 2916: {
                g = MediaGenres.EROTIC;
                break;
            }
            case 10751: {
                g = MediaGenres.FAMILY;
                break;
            }
            case 10750: {
                g = MediaGenres.FAN_FILM;
                break;
            }
            case 14: {
                g = MediaGenres.FANTASY;
                break;
            }
            case 10753: {
                g = MediaGenres.FILM_NOIR;
                break;
            }
            case 10769: {
                g = MediaGenres.FOREIGN;
                break;
            }
            case 36: {
                g = MediaGenres.HISTORY;
                break;
            }
            case 10595: {
                g = MediaGenres.HOLIDAY;
                break;
            }
            case 27: {
                g = MediaGenres.HORROR;
                break;
            }
            case 10756: {
                g = MediaGenres.INDIE;
                break;
            }
            case 10402: {
                g = MediaGenres.MUSIC;
                break;
            }
            case 22: {
                g = MediaGenres.MUSICAL;
                break;
            }
            case 9648: {
                g = MediaGenres.MYSTERY;
                break;
            }
            case 10754: {
                g = MediaGenres.NEO_NOIR;
                break;
            }
            case 1115: {
                g = MediaGenres.ROAD_MOVIE;
                break;
            }
            case 10749: {
                g = MediaGenres.ROMANCE;
                break;
            }
            case 878: {
                g = MediaGenres.SCIENCE_FICTION;
                break;
            }
            case 10755: {
                g = MediaGenres.SHORT;
                break;
            }
            case 9805: {
                g = MediaGenres.SPORT;
                break;
            }
            case 10758: {
                g = MediaGenres.SPORTING_EVENT;
                break;
            }
            case 10757: {
                g = MediaGenres.SPORTS_FILM;
                break;
            }
            case 10748: {
                g = MediaGenres.SUSPENSE;
                break;
            }
            case 10770: {
                g = MediaGenres.TV_MOVIE;
                break;
            }
            case 53: {
                g = MediaGenres.THRILLER;
                break;
            }
            case 10752: {
                g = MediaGenres.WAR;
                break;
            }
            case 37: {
                g = MediaGenres.WESTERN;
            }
        }
        if (g == null) {
            g = MediaGenres.getGenre((String)genre.name);
        }
        return g;
    }

    static {
        providerInfo = TmdbMetadataProvider.createMediaProviderInfo();
    }
}

