/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.tmdb;

import com.uwetrottmann.tmdb2.Tmdb;
import com.uwetrottmann.tmdb2.entities.Image;
import com.uwetrottmann.tmdb2.entities.Images;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.tmdb.TmdbConnectionCounter;
import org.tinymediamanager.scraper.tmdb.TmdbMetadataProvider;
import org.tinymediamanager.scraper.tmdb.TmdbMovieMetadataProvider;
import org.tinymediamanager.scraper.util.ListUtils;

class TmdbArtworkProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmdbArtworkProvider.class);
    private Tmdb api;

    public TmdbArtworkProvider(Tmdb api) {
        this.api = api;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<MediaArtwork> getArtwork(MediaScrapeOptions options) throws Exception {
        LOGGER.debug("getArtwork() " + options.toString());
        MediaArtwork.MediaArtworkType artworkType = options.getArtworkType();
        int tmdbId = options.getTmdbId();
        String imdbId = options.getImdbId();
        if (tmdbId == 0 && StringUtils.isNotEmpty((CharSequence)imdbId)) {
            tmdbId = new TmdbMovieMetadataProvider(this.api).getTmdbIdFromImdbId(imdbId);
        }
        if (tmdbId == 0) {
            LOGGER.debug("Cannot get artwork - neither imdb/tmdb set");
            return new ArrayList<MediaArtwork>(0);
        }
        Images images = null;
        Tmdb tmdb = this.api;
        synchronized (tmdb) {
            TmdbConnectionCounter.trackConnections();
            switch (options.getType()) {
                case MOVIE: {
                    images = (Images)this.api.moviesService().images(tmdbId, null).execute().body();
                    break;
                }
                case MOVIE_SET: {
                    images = (Images)this.api.collectionService().images(tmdbId, null).execute().body();
                    break;
                }
                case TV_SHOW: {
                    images = (Images)this.api.tvService().images(tmdbId, null).execute().body();
                    break;
                }
                case TV_EPISODE: {
                    int seasonNr = -1;
                    int episodeNr = -1;
                    try {
                        seasonNr = Integer.parseInt(options.getId("seasonNr"));
                        episodeNr = Integer.parseInt(options.getId("episodeNr"));
                        if (seasonNr <= -1 || episodeNr <= -1) break;
                        images = (Images)this.api.tvEpisodesService().images(tmdbId, seasonNr, episodeNr).execute().body();
                        break;
                    }
                    catch (Exception e) {
                        LOGGER.warn("error parsing season/episode number");
                    }
                }
            }
        }
        if (images == null) {
            return new ArrayList<MediaArtwork>(0);
        }
        List<MediaArtwork> artwork = this.prepareArtwork(images, artworkType, tmdbId, options);
        MediaMetadata md = options.getMetadata();
        if (md != null) {
            md.addMediaArt(artwork);
        }
        return artwork;
    }

    private List<MediaArtwork> prepareArtwork(Images tmdbArtwork, MediaArtwork.MediaArtworkType artworkType, int tmdbId, MediaScrapeOptions options) {
        MediaArtwork ma;
        ArrayList<MediaArtwork> artwork = new ArrayList<MediaArtwork>();
        String baseUrl = TmdbMetadataProvider.configuration.images.base_url;
        if (tmdbArtwork == null) {
            return artwork;
        }
        if (tmdbArtwork.posters != null) {
            Collections.sort(tmdbArtwork.posters, new ImageComparator(options.getLanguage().getLanguage()));
        }
        if (tmdbArtwork.backdrops != null) {
            Collections.sort(tmdbArtwork.backdrops, new ImageComparator(options.getLanguage().getLanguage()));
        }
        if (artworkType == MediaArtwork.MediaArtworkType.POSTER || artworkType == MediaArtwork.MediaArtworkType.ALL) {
            for (Image image : ListUtils.nullSafe(tmdbArtwork.posters)) {
                ma = new MediaArtwork(TmdbMetadataProvider.providerInfo.getId(), MediaArtwork.MediaArtworkType.POSTER);
                ma.setPreviewUrl(baseUrl + "w185" + image.file_path);
                ma.setLanguage(image.iso_639_1);
                ma.setTmdbId(tmdbId);
                ma.addImageSize(image.width.intValue(), image.height.intValue(), baseUrl + "original" + image.file_path);
                if (500 < image.width) {
                    ma.addImageSize(500, image.height * 500 / image.width, baseUrl + "w500" + image.file_path);
                }
                if (342 < image.width) {
                    ma.addImageSize(342, image.height * 342 / image.width, baseUrl + "w342" + image.file_path);
                }
                if (185 < image.width) {
                    ma.addImageSize(185, image.height * 185 / image.width, baseUrl + "w185" + image.file_path);
                }
                this.prepareDefaultPoster(ma, options);
                artwork.add(ma);
            }
        }
        if (artworkType == MediaArtwork.MediaArtworkType.BACKGROUND || artworkType == MediaArtwork.MediaArtworkType.ALL) {
            for (Image image : ListUtils.nullSafe(tmdbArtwork.backdrops)) {
                ma = new MediaArtwork(TmdbMetadataProvider.providerInfo.getId(), MediaArtwork.MediaArtworkType.BACKGROUND);
                ma.setPreviewUrl(baseUrl + "w300" + image.file_path);
                ma.setLanguage(image.iso_639_1);
                ma.setTmdbId(tmdbId);
                ma.addImageSize(image.width.intValue(), image.height.intValue(), baseUrl + "original" + image.file_path);
                if (1280 < image.width) {
                    ma.addImageSize(1280, image.height * 1280 / image.width, baseUrl + "w1280" + image.file_path);
                }
                if (300 < image.width) {
                    ma.addImageSize(300, image.height * 300 / image.width, baseUrl + "w300" + image.file_path);
                }
                this.prepareDefaultFanart(ma, options);
                artwork.add(ma);
            }
        }
        return artwork;
    }

    private void prepareDefaultPoster(MediaArtwork ma, MediaScrapeOptions options) {
        for (MediaArtwork.ImageSizeAndUrl image : ma.getImageSizes()) {
            if (image.getWidth() >= 1000) {
                if (options.getPosterSize().getOrder() < MediaArtwork.PosterSizes.LARGE.getOrder()) continue;
                ma.setDefaultUrl(image.getUrl());
                ma.setSizeOrder(MediaArtwork.PosterSizes.LARGE.getOrder());
                break;
            }
            if (image.getWidth() >= 500) {
                if (options.getPosterSize().getOrder() < MediaArtwork.PosterSizes.BIG.getOrder()) continue;
                ma.setDefaultUrl(image.getUrl());
                ma.setSizeOrder(MediaArtwork.PosterSizes.BIG.getOrder());
                break;
            }
            if (image.getWidth() >= 342) {
                if (options.getPosterSize().getOrder() < MediaArtwork.PosterSizes.MEDIUM.getOrder()) continue;
                ma.setDefaultUrl(image.getUrl());
                ma.setSizeOrder(MediaArtwork.PosterSizes.MEDIUM.getOrder());
                break;
            }
            if (image.getWidth() < 185 || options.getPosterSize() != MediaArtwork.PosterSizes.SMALL) continue;
            ma.setDefaultUrl(image.getUrl());
            ma.setSizeOrder(MediaArtwork.PosterSizes.SMALL.getOrder());
            break;
        }
    }

    private void prepareDefaultFanart(MediaArtwork ma, MediaScrapeOptions options) {
        for (MediaArtwork.ImageSizeAndUrl image : ma.getImageSizes()) {
            if (image.getWidth() >= 1920) {
                if (options.getFanartSize().getOrder() < MediaArtwork.FanartSizes.LARGE.getOrder()) continue;
                ma.setDefaultUrl(image.getUrl());
                ma.setSizeOrder(MediaArtwork.FanartSizes.LARGE.getOrder());
                break;
            }
            if (image.getWidth() >= 1280) {
                if (options.getFanartSize().getOrder() < MediaArtwork.FanartSizes.MEDIUM.getOrder()) continue;
                ma.setDefaultUrl(image.getUrl());
                ma.setSizeOrder(MediaArtwork.FanartSizes.MEDIUM.getOrder());
                break;
            }
            if (image.getWidth() < 300 || options.getFanartSize().getOrder() < MediaArtwork.FanartSizes.SMALL.getOrder()) continue;
            ma.setDefaultUrl(image.getUrl());
            ma.setSizeOrder(MediaArtwork.FanartSizes.SMALL.getOrder());
            break;
        }
    }

    private static class ImageComparator
    implements Comparator<Image> {
        private String preferredLangu;

        private ImageComparator(String language) {
            this.preferredLangu = language;
        }

        @Override
        public int compare(Image arg0, Image arg1) {
            if (this.preferredLangu.equals(arg0.iso_639_1) && !this.preferredLangu.equals(arg1.iso_639_1)) {
                return -1;
            }
            if (!this.preferredLangu.equals(arg0.iso_639_1) && this.preferredLangu.equals(arg1.iso_639_1)) {
                return 1;
            }
            if ("en".equals(arg0.iso_639_1) && !"en".equals(arg1.iso_639_1)) {
                return -1;
            }
            if (!"en".equals(arg0.iso_639_1) && "en".equals(arg1.iso_639_1)) {
                return 1;
            }
            if (arg0.vote_average.equals(arg1.vote_average)) {
                return 0;
            }
            return arg0.vote_average.floatValue() > arg1.vote_average.floatValue() ? -1 : 1;
        }
    }
}

