/*
 * Decompiled with CFR 0.152.
 */
package com.uwetrottmann.tmdb2.enumerations;

import java.util.HashMap;
import java.util.Map;

public enum Status {
    RUMORED("Rumored"),
    PLANNED("Planned"),
    IN_PRODUCTION("In Production"),
    POST_PRODUCTION("Post Production"),
    RELEASED("Released"),
    CANCELLED("Cancelled");

    public final String value;
    private static final Map<String, Status> STRING_MAPPING;

    private Status(String value) {
        this.value = value;
    }

    public static Status fromValue(String value) {
        return STRING_MAPPING.get(value.toUpperCase());
    }

    public String toString() {
        return this.value;
    }

    static {
        STRING_MAPPING = new HashMap<String, Status>();
        for (Status via : Status.values()) {
            STRING_MAPPING.put(via.toString().toUpperCase(), via);
        }
    }
}

