/*
 * Decompiled with CFR 0.152.
 */
package com.uwetrottmann.tmdb2;

import com.google.gson.Gson;
import com.uwetrottmann.tmdb2.DiscoverMovieBuilder;
import com.uwetrottmann.tmdb2.DiscoverTvBuilder;
import com.uwetrottmann.tmdb2.TmdbHelper;
import com.uwetrottmann.tmdb2.TmdbInterceptor;
import com.uwetrottmann.tmdb2.services.CollectionService;
import com.uwetrottmann.tmdb2.services.ConfigurationService;
import com.uwetrottmann.tmdb2.services.DiscoverService;
import com.uwetrottmann.tmdb2.services.FindService;
import com.uwetrottmann.tmdb2.services.GenreService;
import com.uwetrottmann.tmdb2.services.MoviesService;
import com.uwetrottmann.tmdb2.services.PeopleService;
import com.uwetrottmann.tmdb2.services.ReviewsService;
import com.uwetrottmann.tmdb2.services.SearchService;
import com.uwetrottmann.tmdb2.services.TvEpisodesService;
import com.uwetrottmann.tmdb2.services.TvSeasonsService;
import com.uwetrottmann.tmdb2.services.TvService;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class Tmdb {
    public static final String API_HOST = "api.themoviedb.org";
    public static final String API_VERSION = "3";
    public static final String API_URL = "https://api.themoviedb.org/3/";
    public static final String PARAM_API_KEY = "api_key";
    private OkHttpClient okHttpClient;
    private Retrofit retrofit;
    private String apiKey;

    public Tmdb(String apiKey) {
        this.apiKey = apiKey;
    }

    public void apiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String apiKey() {
        return this.apiKey;
    }

    protected Retrofit.Builder retrofitBuilder() {
        return new Retrofit.Builder().baseUrl(API_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)TmdbHelper.getGsonBuilder().create())).client(this.okHttpClient());
    }

    protected synchronized OkHttpClient okHttpClient() {
        if (this.okHttpClient == null) {
            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            this.setOkHttpClientDefaults(builder);
            this.okHttpClient = builder.build();
        }
        return this.okHttpClient;
    }

    protected void setOkHttpClientDefaults(OkHttpClient.Builder builder) {
        builder.addInterceptor((Interceptor)new TmdbInterceptor(this));
    }

    protected Retrofit getRetrofit() {
        if (this.retrofit == null) {
            this.retrofit = this.retrofitBuilder().build();
        }
        return this.retrofit;
    }

    public ConfigurationService configurationService() {
        return (ConfigurationService)this.getRetrofit().create(ConfigurationService.class);
    }

    public FindService findService() {
        return (FindService)this.getRetrofit().create(FindService.class);
    }

    public MoviesService moviesService() {
        return (MoviesService)this.getRetrofit().create(MoviesService.class);
    }

    public PeopleService personService() {
        return (PeopleService)this.getRetrofit().create(PeopleService.class);
    }

    public SearchService searchService() {
        return (SearchService)this.getRetrofit().create(SearchService.class);
    }

    public TvService tvService() {
        return (TvService)this.getRetrofit().create(TvService.class);
    }

    public TvSeasonsService tvSeasonsService() {
        return (TvSeasonsService)this.getRetrofit().create(TvSeasonsService.class);
    }

    public TvEpisodesService tvEpisodesService() {
        return (TvEpisodesService)this.getRetrofit().create(TvEpisodesService.class);
    }

    public DiscoverService discoverService() {
        return (DiscoverService)this.getRetrofit().create(DiscoverService.class);
    }

    public CollectionService collectionService() {
        return (CollectionService)this.getRetrofit().create(CollectionService.class);
    }

    public GenreService genreService() {
        return (GenreService)this.getRetrofit().create(GenreService.class);
    }

    public ReviewsService reviewsService() {
        return (ReviewsService)this.getRetrofit().create(ReviewsService.class);
    }

    public DiscoverMovieBuilder discoverMovie() {
        return new DiscoverMovieBuilder(this.discoverService());
    }

    public DiscoverTvBuilder discoverTv() {
        return new DiscoverTvBuilder(this.discoverService());
    }
}

