/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.settings;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowSettings;
import org.tinymediamanager.scraper.trakttv.ClearTraktTvTask;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.panels.ScrollablePanel;

public class TvShowSettingsPanel
extends ScrollablePanel {
    private static final long serialVersionUID = -675729644848101096L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private TvShowSettings settings = TvShowModuleManager.SETTINGS;
    private JLabel lblImageCache;
    private JCheckBox chckbxImageCache;
    private JLabel lblImageCacheHint;
    private JCheckBox chckbxTraktTv;
    private final JButton btnClearTraktTvShows;
    private JCheckBox cbDvdOrder;
    private JTextField tfAddBadword;
    private JList<String> listBadWords;
    private JList<String> listDatasources;
    private JList<String> listExclude;

    public TvShowSettingsPanel() {
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow(3)")}));
        JPanel panelGeneral = new JPanel();
        panelGeneral.setBorder(new TitledBorder(null, BUNDLE.getString("Settings.general"), 4, 2, null, null));
        this.add((Component)panelGeneral, "2, 2, fill, fill");
        panelGeneral.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC}));
        this.lblImageCache = new JLabel(BUNDLE.getString("Settings.imagecacheimport"));
        panelGeneral.add((Component)this.lblImageCache, "2, 2");
        this.chckbxImageCache = new JCheckBox("");
        panelGeneral.add((Component)this.chckbxImageCache, "4, 2");
        this.lblImageCacheHint = new JLabel(BUNDLE.getString("Settings.imagecacheimporthint"));
        panelGeneral.add((Component)this.lblImageCacheHint, "6, 2, 3, 1");
        TmmFontHelper.changeFont((JComponent)this.lblImageCacheHint, 0.833);
        JSeparator separator = new JSeparator();
        panelGeneral.add((Component)separator, "2, 4, 7, 1");
        JLabel lblTraktTv = new JLabel(BUNDLE.getString("Settings.trakt"));
        panelGeneral.add((Component)lblTraktTv, "2, 6");
        this.chckbxTraktTv = new JCheckBox("");
        panelGeneral.add((Component)this.chckbxTraktTv, "4, 6");
        this.btnClearTraktTvShows = new JButton(BUNDLE.getString("Settings.trakt.cleartvshows"));
        this.btnClearTraktTvShows.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int confirm = JOptionPane.showOptionDialog(null, BUNDLE.getString("Settings.trakt.cleartvshows.hint"), BUNDLE.getString("Settings.trakt.cleartvshows"), 0, 3, null, null, null);
                if (confirm == 0) {
                    ClearTraktTvTask task = new ClearTraktTvTask(false, true);
                    TmmTaskManager.getInstance().addUnnamedTask(task);
                }
            }
        });
        panelGeneral.add((Component)this.btnClearTraktTvShows, "6, 6");
        JPanel panelBadWords = new JPanel();
        panelBadWords.setBorder(new TitledBorder(null, BUNDLE.getString("Settings.tvshow.badwords"), 4, 2, null, null));
        this.add((Component)panelBadWords, "4, 2, fill, fill");
        panelBadWords.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"50px:grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JTextPane txtpntBadWordsHint = new JTextPane();
        txtpntBadWordsHint.setBackground(UIManager.getColor("Panel.background"));
        txtpntBadWordsHint.setText(BUNDLE.getString("Settings.tvshow.badwords.hint"));
        TmmFontHelper.changeFont((JComponent)txtpntBadWordsHint, 0.833);
        panelBadWords.add((Component)txtpntBadWordsHint, "2, 2, 3, 1, fill, default");
        JScrollPane scpBadWords = new JScrollPane();
        panelBadWords.add((Component)scpBadWords, "2, 4, fill, fill");
        this.listBadWords = new JList();
        scpBadWords.setViewportView(this.listBadWords);
        JButton btnRemoveBadWord = new JButton(IconManager.LIST_REMOVE);
        btnRemoveBadWord.setToolTipText(BUNDLE.getString("Button.remove"));
        btnRemoveBadWord.setMargin(new Insets(2, 2, 2, 2));
        btnRemoveBadWord.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int row = TvShowSettingsPanel.this.listBadWords.getSelectedIndex();
                if (row != -1) {
                    String badWord = TvShowModuleManager.SETTINGS.getBadWords().get(row);
                    TvShowModuleManager.SETTINGS.removeBadWord(badWord);
                }
            }
        });
        panelBadWords.add((Component)btnRemoveBadWord, "4, 4, default, bottom");
        this.tfAddBadword = new JTextField();
        this.tfAddBadword.setColumns(10);
        panelBadWords.add((Component)this.tfAddBadword, "2, 6, fill, default");
        JButton btnAddBadWord = new JButton(IconManager.LIST_ADD);
        btnAddBadWord.setToolTipText(BUNDLE.getString("Button.add"));
        btnAddBadWord.setMargin(new Insets(2, 2, 2, 2));
        btnAddBadWord.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StringUtils.isNotEmpty((CharSequence)TvShowSettingsPanel.this.tfAddBadword.getText())) {
                    TvShowModuleManager.SETTINGS.addBadWord(TvShowSettingsPanel.this.tfAddBadword.getText());
                    TvShowSettingsPanel.this.tfAddBadword.setText("");
                }
            }
        });
        panelBadWords.add((Component)btnAddBadWord, "4, 6");
        JPanel panelTvShowDataSources = new JPanel();
        panelTvShowDataSources.setBorder(new TitledBorder(null, BUNDLE.getString("Settings.tvshowdatasource"), 4, 2, null, null));
        this.add((Component)panelTvShowDataSources, "2, 4, 3, 1, fill, top");
        panelTvShowDataSources.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"50dlu:grow"), FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.UNRELATED_GAP_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"200dlu:grow(2)"), FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"160px:grow"), FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC}));
        JLabel lblDataSource = new JLabel(BUNDLE.getString("Settings.source"));
        panelTvShowDataSources.add((Component)lblDataSource, "2, 2, 5, 1");
        JLabel lblSkipFolders = new JLabel(BUNDLE.getString("Settings.ignore"));
        panelTvShowDataSources.add((Component)lblSkipFolders, "12, 2, 3, 1");
        JScrollPane scrollPaneDatasource = new JScrollPane();
        panelTvShowDataSources.add((Component)scrollPaneDatasource, "2, 4, 5, 1, fill, fill");
        this.listDatasources = new JList();
        scrollPaneDatasource.setViewportView(this.listDatasources);
        JPanel panelTvShowSourcesButtons = new JPanel();
        panelTvShowDataSources.add((Component)panelTvShowSourcesButtons, "8, 4, default, top");
        panelTvShowSourcesButtons.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.DEFAULT_COLSPEC}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}));
        JButton btnAdd = new JButton(IconManager.LIST_ADD);
        btnAdd.setToolTipText(BUNDLE.getString("Button.add"));
        btnAdd.setMargin(new Insets(2, 2, 2, 2));
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String path = TmmProperties.getInstance().getProperty("tvshow.datasource.path");
                Path file = TmmUIHelper.selectDirectory(BUNDLE.getString("Settings.tvshowdatasource.folderchooser"), path);
                if (file != null && Files.isDirectory(file, new LinkOption[0])) {
                    TvShowSettingsPanel.this.settings.addTvShowDataSources(file.toAbsolutePath().toString());
                    TmmProperties.getInstance().putProperty("tvshow.datasource.path", file.toAbsolutePath().toString());
                }
            }
        });
        panelTvShowSourcesButtons.add((Component)btnAdd, "1, 1, fill, top");
        JButton btnRemove = new JButton(IconManager.LIST_REMOVE);
        btnRemove.setToolTipText(BUNDLE.getString("Button.remove"));
        btnRemove.setMargin(new Insets(2, 2, 2, 2));
        btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int row = TvShowSettingsPanel.this.listDatasources.getSelectedIndex();
                if (row != -1) {
                    String path = TvShowSettingsPanel.this.settings.getTvShowDataSource().get(row);
                    Object[] choices = new String[]{BUNDLE.getString("Button.continue"), BUNDLE.getString("Button.abort")};
                    int decision = JOptionPane.showOptionDialog(null, String.format(BUNDLE.getString("Settings.tvshowdatasource.remove.info"), path), BUNDLE.getString("Settings.datasource.remove"), 0, -1, null, choices, BUNDLE.getString("Button.abort"));
                    if (decision == 0) {
                        TvShowSettingsPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                        TvShowSettingsPanel.this.settings.removeTvShowDataSources(path);
                        TvShowSettingsPanel.this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
            }
        });
        panelTvShowSourcesButtons.add((Component)btnRemove, "1, 3, fill, top");
        JScrollPane scrollPane = new JScrollPane();
        panelTvShowDataSources.add((Component)scrollPane, "12, 4, fill, fill");
        this.listExclude = new JList();
        scrollPane.setViewportView(this.listExclude);
        JPanel panelSkipFolderButtons = new JPanel();
        panelTvShowDataSources.add((Component)panelSkipFolderButtons, "14, 4, fill, fill");
        panelSkipFolderButtons.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.DEFAULT_COLSPEC}, new RowSpec[]{FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}));
        JButton btnAddSkipFolder = new JButton(IconManager.LIST_ADD);
        btnAddSkipFolder.setToolTipText(BUNDLE.getString("Settings.addignore"));
        btnAddSkipFolder.setMargin(new Insets(2, 2, 2, 2));
        btnAddSkipFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String path = TmmProperties.getInstance().getProperty("tvshow.ignore.path");
                Path file = TmmUIHelper.selectDirectory(BUNDLE.getString("Settings.ignore"), path);
                if (file != null && Files.isDirectory(file, new LinkOption[0])) {
                    TvShowSettingsPanel.this.settings.addTvShowSkipFolder(file.toAbsolutePath().toString());
                    TmmProperties.getInstance().putProperty("tvshow.ignore.path", file.toAbsolutePath().toString());
                }
            }
        });
        panelSkipFolderButtons.add((Component)btnAddSkipFolder, "1, 1");
        JButton btnRemoveSkipFolder = new JButton(IconManager.LIST_REMOVE);
        btnRemoveSkipFolder.setToolTipText(BUNDLE.getString("Settings.removeignore"));
        btnRemoveSkipFolder.setMargin(new Insets(2, 2, 2, 2));
        btnRemoveSkipFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = TvShowSettingsPanel.this.listExclude.getSelectedIndex();
                if (row != -1) {
                    String ingore = TvShowSettingsPanel.this.settings.getTvShowSkipFolders().get(row);
                    TvShowSettingsPanel.this.settings.removeTvShowSkipFolder(ingore);
                }
            }
        });
        panelSkipFolderButtons.add((Component)btnRemoveSkipFolder, "1, 3");
        JLabel lblDvdOrder = new JLabel(BUNDLE.getString("Settings.dvdorder"));
        panelTvShowDataSources.add((Component)lblDvdOrder, "2, 6, right, default");
        this.cbDvdOrder = new JCheckBox("");
        panelTvShowDataSources.add((Component)this.cbDvdOrder, "4, 6");
        this.initDataBindings();
        if (!Globals.isDonator()) {
            this.chckbxTraktTv.setSelected(false);
            this.chckbxTraktTv.setEnabled(false);
            this.btnClearTraktTvShows.setEnabled(false);
        }
    }

    protected void initDataBindings() {
        BeanProperty settingsBeanProperty = BeanProperty.create((String)"syncTrakt");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty, (Object)this.chckbxTraktTv, (Property)jCheckBoxBeanProperty);
        autoBinding.bind();
        BeanProperty settingsBeanProperty_1 = BeanProperty.create((String)"dvdOrder");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_1, (Object)this.cbDvdOrder, (Property)jCheckBoxBeanProperty);
        autoBinding_1.bind();
        BeanProperty settingsBeanProperty_2 = BeanProperty.create((String)"tvShowDataSource");
        JListBinding jListBinding = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_2, this.listDatasources);
        jListBinding.bind();
        BeanProperty settingsBeanProperty_3 = BeanProperty.create((String)"tvShowSkipFolders");
        JListBinding jListBinding_1 = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_3, this.listExclude);
        jListBinding_1.bind();
        BeanProperty settingsBeanProperty_4 = BeanProperty.create((String)"badWords");
        JListBinding jListBinding_2 = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)settingsBeanProperty_4, this.listBadWords);
        jListBinding_2.bind();
        BeanProperty tvShowSettingsBeanProperty = BeanProperty.create((String)"buildImageCacheOnImport");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)tvShowSettingsBeanProperty, (Object)this.chckbxImageCache, (Property)jCheckBoxBeanProperty);
        autoBinding_2.bind();
    }
}

