/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.dialogs;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.japura.gui.CheckComboBox;
import org.japura.gui.model.ListCheckModel;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.ui.EqualsLayout;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.MediaScraperCheckComboBox;
import org.tinymediamanager.ui.components.MediaScraperComboBox;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.tvshows.TvShowScraperMetadataPanel;

public class TvShowScrapeMetadataDialog
extends TmmDialog {
    private static final long serialVersionUID = 6120530120703772160L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private TvShowSearchAndScrapeOptions tvShowSearchAndScrapeConfig = new TvShowSearchAndScrapeOptions();
    private boolean startScrape = true;
    private MediaScraperComboBox cbMetadataScraper;
    private CheckComboBox cbArtworkScraper;

    public TvShowScrapeMetadataDialog(String title) {
        super(title, "updateMetadata");
        this.setBounds(5, 5, 533, 280);
        TvShowScraperMetadataConfig settings = Globals.settings.getTvShowScraperMetadataConfig();
        TvShowScraperMetadataConfig scraperMetadataConfig = new TvShowScraperMetadataConfig();
        scraperMetadataConfig.setTitle(settings.isTitle());
        scraperMetadataConfig.setPlot(settings.isPlot());
        scraperMetadataConfig.setAired(settings.isAired());
        scraperMetadataConfig.setRating(settings.isRating());
        scraperMetadataConfig.setRuntime(settings.isRuntime());
        scraperMetadataConfig.setYear(settings.isYear());
        scraperMetadataConfig.setCertification(settings.isCertification());
        scraperMetadataConfig.setCast(settings.isCast());
        scraperMetadataConfig.setGenres(settings.isGenres());
        scraperMetadataConfig.setArtwork(settings.isArtwork());
        scraperMetadataConfig.setEpisodes(settings.isEpisodes());
        scraperMetadataConfig.setStatus(settings.isStatus());
        this.tvShowSearchAndScrapeConfig.setScraperMetadataConfig(scraperMetadataConfig);
        JPanel panelContent = new JPanel();
        this.getContentPane().add((Component)panelContent, "Center");
        panelContent.setLayout(new BorderLayout(0, 0));
        JPanel panelScraper = new JPanel();
        panelContent.add((Component)panelScraper, "North");
        panelScraper.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.PARAGRAPH_GAP_ROWSPEC}));
        JLabel lblMetadataScraperT = new JLabel(BUNDLE.getString("scraper.metadata"));
        panelScraper.add((Component)lblMetadataScraperT, "2, 2, right, default");
        this.cbMetadataScraper = new MediaScraperComboBox(TvShowList.getInstance().getAvailableMediaScrapers());
        panelScraper.add((Component)this.cbMetadataScraper, "4, 2");
        JLabel lblArtworkScraper = new JLabel(BUNDLE.getString("scraper.artwork"));
        panelScraper.add((Component)lblArtworkScraper, "2, 4, right, default");
        this.cbArtworkScraper = new MediaScraperCheckComboBox();
        this.cbArtworkScraper.setTextFor(CheckComboBox.NONE, BUNDLE.getString("scraper.selected.none"));
        this.cbArtworkScraper.setTextFor(CheckComboBox.MULTIPLE, BUNDLE.getString("scraper.selected.multiple"));
        this.cbArtworkScraper.setTextFor(CheckComboBox.ALL, BUNDLE.getString("scraper.selected.all"));
        panelScraper.add((Component)this.cbArtworkScraper, "4, 4");
        JPanel panelCenter = new JPanel();
        panelContent.add((Component)panelCenter, "Center");
        panelCenter.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_ROWSPEC}));
        TvShowScraperMetadataPanel panelScraperMetadataSetting = new TvShowScraperMetadataPanel(this.tvShowSearchAndScrapeConfig.getScraperMetadataConfig());
        panelScraperMetadataSetting.setBorder(new TitledBorder(new LineBorder(new Color(184, 207, 229)), BUNDLE.getString("scraper.metadata.select"), 4, 2, null, null));
        panelCenter.add((Component)panelScraperMetadataSetting, "2, 2, fill, default");
        JPanel panelButtons = new JPanel();
        panelButtons.setLayout(new EqualsLayout(5));
        panelButtons.setBorder(new EmptyBorder(4, 4, 4, 4));
        panelContent.add((Component)panelButtons, "South");
        JButton btnStart = new JButton(BUNDLE.getString("scraper.start"));
        btnStart.setIcon(IconManager.APPLY);
        btnStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TvShowScrapeMetadataDialog.this.startScrape = true;
                TvShowScrapeMetadataDialog.this.setVisible(false);
            }
        });
        panelButtons.add(btnStart);
        JButton btnCancel = new JButton(BUNDLE.getString("Button.cancel"));
        btnCancel.setIcon(IconManager.CANCEL);
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TvShowScrapeMetadataDialog.this.startScrape = false;
                TvShowScrapeMetadataDialog.this.setVisible(false);
            }
        });
        panelButtons.add(btnCancel);
        MediaScraper defaultScraper = TvShowList.getInstance().getDefaultMediaScraper();
        this.cbMetadataScraper.setSelectedItem(defaultScraper);
        ListCheckModel model = this.cbArtworkScraper.getModel();
        for (MediaScraper artworkScraper : TvShowList.getInstance().getAvailableArtworkScrapers()) {
            model.addElement(new Object[]{artworkScraper});
            if (!TvShowModuleManager.SETTINGS.getTvShowArtworkScrapers().contains(artworkScraper.getId())) continue;
            model.addCheck(new Object[]{artworkScraper});
        }
    }

    public TvShowSearchAndScrapeOptions getTvShowSearchAndScrapeConfig() {
        this.tvShowSearchAndScrapeConfig.setMetadataScraper((MediaScraper)this.cbMetadataScraper.getSelectedItem());
        ListCheckModel model = this.cbArtworkScraper.getModel();
        for (Object checked : model.getCheckeds()) {
            if (checked == null || !(checked instanceof MediaScraper)) continue;
            this.tvShowSearchAndScrapeConfig.addArtworkScraper((MediaScraper)checked);
        }
        return this.tvShowSearchAndScrapeConfig;
    }

    public boolean shouldStartScrape() {
        return this.startScrape;
    }
}

