/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.dialogs;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.tasks.TvShowEpisodeScrapeTask;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.trakttv.SyncTraktTvTask;
import org.tinymediamanager.ui.EqualsLayout;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.ImageLabel;
import org.tinymediamanager.ui.components.MediaScraperComboBox;
import org.tinymediamanager.ui.dialogs.ImageChooserDialog;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.tvshows.TvShowChooserModel;
import org.tinymediamanager.ui.tvshows.TvShowScraperMetadataPanel;

public class TvShowChooserDialog
extends TmmDialog
implements ActionListener {
    private static final long serialVersionUID = 2371518113606870230L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowChooserDialog.class);
    private TvShowList tvShowList = TvShowList.getInstance();
    private TvShow tvShowToScrape;
    private List<TvShowChooserModel> tvShowsFound = ObservableCollections.observableList(new ArrayList());
    private TvShowScraperMetadataConfig scraperMetadataConfig = new TvShowScraperMetadataConfig();
    private MediaScraper mediaScraper;
    private List<MediaScraper> artworkScrapers;
    private boolean continueQueue = true;
    private final JPanel contentPanel = new JPanel();
    private JTextField textFieldSearchString;
    private MediaScraperComboBox cbScraper;
    private JComboBox<MediaLanguages> cbLanguage;
    private JTable table;
    private JTextArea lblTvShowName;
    private JTextPane tpTvShowOverview;
    private ImageLabel lblTvShowPoster;
    private JLabel lblProgressAction;
    private JProgressBar progressBar;
    private JButton okButton;
    private JLabel lblPath;

    public TvShowChooserDialog(TvShow tvShow, boolean inQueue) {
        super(BUNDLE.getString("tvshowchooser.search"), "tvShowChooser");
        this.setBounds(5, 5, 985, 586);
        TvShowScraperMetadataConfig settings = Globals.settings.getTvShowScraperMetadataConfig();
        this.mediaScraper = this.tvShowList.getDefaultMediaScraper();
        this.artworkScrapers = this.tvShowList.getAvailableArtworkScrapers();
        this.scraperMetadataConfig.setTitle(settings.isTitle());
        this.scraperMetadataConfig.setPlot(settings.isPlot());
        this.scraperMetadataConfig.setRating(settings.isRating());
        this.scraperMetadataConfig.setRuntime(settings.isRuntime());
        this.scraperMetadataConfig.setYear(settings.isYear());
        this.scraperMetadataConfig.setAired(settings.isAired());
        this.scraperMetadataConfig.setStatus(settings.isStatus());
        this.scraperMetadataConfig.setCertification(settings.isCertification());
        this.scraperMetadataConfig.setCast(settings.isCast());
        this.scraperMetadataConfig.setGenres(settings.isGenres());
        this.scraperMetadataConfig.setArtwork(settings.isArtwork());
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"800px:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.NARROW_LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.NARROW_LINE_GAP_ROWSPEC, RowSpec.decode((String)"fill:default:grow"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        this.lblPath = new JLabel("");
        this.contentPanel.add((Component)this.lblPath, "2, 2");
        JPanel panelSearchField = new JPanel();
        this.contentPanel.add((Component)panelSearchField, "2, 4, fill, fill");
        panelSearchField.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"right:default")}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.NARROW_LINE_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JLabel lblScraper = new JLabel(BUNDLE.getString("scraper"));
        panelSearchField.add((Component)lblScraper, "2, 1, right, default");
        this.cbScraper = new MediaScraperComboBox(this.tvShowList.getAvailableMediaScrapers());
        MediaScraper defaultScraper = this.tvShowList.getDefaultMediaScraper();
        this.cbScraper.setSelectedItem(defaultScraper);
        this.cbScraper.setAction(new ChangeScraperAction());
        panelSearchField.add((Component)this.cbScraper, "4, 1, fill, default");
        this.textFieldSearchString = new JTextField();
        panelSearchField.add((Component)this.textFieldSearchString, "6, 1, fill, default");
        this.textFieldSearchString.setColumns(10);
        JButton btnSearch = new JButton(BUNDLE.getString("Button.search"));
        btnSearch.setIcon(IconManager.SEARCH);
        panelSearchField.add((Component)btnSearch, "8, 1");
        btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TvShowChooserDialog.this.searchTvShow(TvShowChooserDialog.this.textFieldSearchString.getText());
            }
        });
        this.getRootPane().setDefaultButton(btnSearch);
        JLabel lblLanguage = new JLabel("Language");
        panelSearchField.add((Component)lblLanguage, "2, 3, right, default");
        this.cbLanguage = new JComboBox();
        this.cbLanguage.setModel(new DefaultComboBoxModel<MediaLanguages>(MediaLanguages.values()));
        this.cbLanguage.setSelectedItem(TvShowModuleManager.SETTINGS.getScraperLanguage());
        this.cbLanguage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TvShowChooserDialog.this.searchTvShow(TvShowChooserDialog.this.textFieldSearchString.getText());
            }
        });
        panelSearchField.add(this.cbLanguage, "4, 3, fill, default");
        JSplitPane splitPane = new JSplitPane();
        splitPane.setResizeWeight(0.5);
        splitPane.setContinuousLayout(true);
        this.contentPanel.add((Component)splitPane, "2, 6, fill, fill");
        JPanel panelSearchResults = new JPanel();
        splitPane.setLeftComponent(panelSearchResults);
        panelSearchResults.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.LABEL_COMPONENT_GAP_COLSPEC, ColumnSpec.decode((String)"300px:grow")}, new RowSpec[]{FormFactory.LINE_GAP_ROWSPEC, RowSpec.decode((String)"fill:150px:grow")}));
        JScrollPane scrollPane = new JScrollPane();
        panelSearchResults.add((Component)scrollPane, "2, 2, fill, fill");
        this.table = new JTable();
        scrollPane.setViewportView(this.table);
        this.table.setSelectionMode(0);
        this.table.setBorder(new LineBorder(new Color(0, 0, 0)));
        ListSelectionModel rowSM = this.table.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (!lsm.isSelectionEmpty()) {
                    int selectedRow = lsm.getMinSelectionIndex();
                    selectedRow = TvShowChooserDialog.this.table.convertRowIndexToModel(selectedRow);
                    try {
                        TvShowChooserModel model = (TvShowChooserModel)TvShowChooserDialog.this.tvShowsFound.get(selectedRow);
                        if (model != TvShowChooserModel.emptyResult && !model.isScraped()) {
                            ScrapeTask task = new ScrapeTask(model);
                            task.execute();
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.warn(ex.getMessage());
                    }
                }
            }
        });
        JPanel panelSearchDetail = new JPanel();
        splitPane.setRightComponent(panelSearchDetail);
        panelSearchDetail.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"left:150px"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"200px:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.DEFAULT_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"240px:grow")}));
        this.lblTvShowName = new JTextArea("");
        this.lblTvShowName.setLineWrap(true);
        this.lblTvShowName.setOpaque(false);
        this.lblTvShowName.setWrapStyleWord(true);
        TmmFontHelper.changeFont(this.lblTvShowName, 1.166, 1);
        panelSearchDetail.add((Component)this.lblTvShowName, "2, 1, 3, 1, fill, top");
        this.lblTvShowPoster = new ImageLabel(false);
        this.lblTvShowPoster.setAlternativeText(BUNDLE.getString("image.notfound.poster"));
        this.lblTvShowPoster.setAlternativeText("");
        panelSearchDetail.add((Component)this.lblTvShowPoster, "2, 4, fill, fill");
        scrollPane = new JScrollPane();
        scrollPane.setBorder(null);
        panelSearchDetail.add((Component)scrollPane, "4, 4, fill, fill");
        this.tpTvShowOverview = new JTextPane();
        this.tpTvShowOverview.setOpaque(false);
        scrollPane.setViewportView(this.tpTvShowOverview);
        JLabel lblScrapeFollowingItems = new JLabel(BUNDLE.getString("chooser.scrape"));
        this.contentPanel.add((Component)lblScrapeFollowingItems, "2, 8");
        TvShowScraperMetadataPanel panelScraperMetadataSetting = new TvShowScraperMetadataPanel(this.scraperMetadataConfig);
        this.contentPanel.add((Component)panelScraperMetadataSetting, "2, 9, default, fill");
        JPanel bottomPane = new JPanel();
        this.contentPanel.add((Component)bottomPane, "2, 11");
        bottomPane.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, ColumnSpec.decode((String)"max(82dlu;default)"), FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"50dlu:grow"), FormSpecs.DEFAULT_COLSPEC}, new RowSpec[]{FormSpecs.LINE_GAP_ROWSPEC, RowSpec.decode((String)"25px"), FormSpecs.RELATED_GAP_ROWSPEC}));
        this.progressBar = new JProgressBar();
        bottomPane.add((Component)this.progressBar, "2, 2");
        this.lblProgressAction = new JLabel("");
        bottomPane.add((Component)this.lblProgressAction, "4, 2, left, default");
        JPanel buttonPane = new JPanel();
        bottomPane.add((Component)buttonPane, "5, 2, fill, fill");
        EqualsLayout layout = new EqualsLayout(5);
        layout.setMinWidth(100);
        buttonPane.setLayout(layout);
        this.okButton = new JButton(BUNDLE.getString("Button.ok"));
        buttonPane.add(this.okButton);
        this.okButton.setActionCommand("OK");
        this.okButton.setIcon(IconManager.APPLY);
        this.okButton.addActionListener(this);
        JButton cancelButton = new JButton(BUNDLE.getString("Button.cancel"));
        buttonPane.add(cancelButton);
        cancelButton.setActionCommand("Cancel");
        cancelButton.setIcon(IconManager.CANCEL);
        cancelButton.addActionListener(this);
        if (inQueue) {
            JButton abortButton = new JButton(BUNDLE.getString("Button.abortqueue"));
            buttonPane.add(abortButton);
            abortButton.setActionCommand("Abort");
            abortButton.addActionListener(this);
            abortButton.setIcon(IconManager.PROCESS_STOP);
        }
        this.tvShowToScrape = tvShow;
        this.progressBar.setVisible(false);
        this.initDataBindings();
        this.table.getColumnModel().getColumn(0).setHeaderValue(BUNDLE.getString("chooser.searchresult"));
        this.lblPath.setText(this.tvShowToScrape.getPath());
        this.textFieldSearchString.setText(this.tvShowToScrape.getTitle());
        this.searchTvShow(this.textFieldSearchString.getText());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TvShowChooserModel model;
        int row;
        if ("OK".equals(e.getActionCommand()) && (row = this.table.getSelectedRow()) >= 0 && (model = this.tvShowsFound.get(row)) != TvShowChooserModel.emptyResult) {
            List<TvShowEpisode> episodesToScrape;
            if (!model.isScraped()) {
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "TvShowChooser", "message.scrape.threadcrashed"));
                return;
            }
            MediaMetadata md = model.getMetadata();
            if (!TvShowModuleManager.SETTINGS.isScrapeBestImage()) {
                md.clearMediaArt();
            }
            this.tvShowToScrape.setMetadata(md, this.scraperMetadataConfig);
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (this.scraperMetadataConfig.isArtwork()) {
                if (!TvShowModuleManager.SETTINGS.isScrapeBestImage()) {
                    ImageLabel lblImage = new ImageLabel();
                    ImageChooserDialog dialog = new ImageChooserDialog(this.tvShowToScrape.getIds(), ImageChooserDialog.ImageType.POSTER, this.artworkScrapers, lblImage, null, null, MediaType.TV_SHOW);
                    dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                    dialog.setVisible(true);
                    this.tvShowToScrape.setArtworkUrl(lblImage.getImageUrl(), MediaFileType.POSTER);
                    this.tvShowToScrape.downloadArtwork(MediaFileType.POSTER);
                    lblImage = new ImageLabel();
                    ArrayList<String> extrathumbs = new ArrayList<String>();
                    ArrayList<String> extrafanarts = new ArrayList<String>();
                    ImageChooserDialog dialog2 = new ImageChooserDialog(this.tvShowToScrape.getIds(), ImageChooserDialog.ImageType.FANART, this.artworkScrapers, lblImage, extrathumbs, extrafanarts, MediaType.TV_SHOW);
                    dialog2.setVisible(true);
                    this.tvShowToScrape.setArtworkUrl(lblImage.getImageUrl(), MediaFileType.FANART);
                    this.tvShowToScrape.downloadArtwork(MediaFileType.FANART);
                    lblImage = new ImageLabel();
                    dialog = new ImageChooserDialog(this.tvShowToScrape.getIds(), ImageChooserDialog.ImageType.BANNER, this.artworkScrapers, lblImage, null, null, MediaType.TV_SHOW);
                    dialog.setVisible(true);
                    this.tvShowToScrape.setArtworkUrl(lblImage.getImageUrl(), MediaFileType.BANNER);
                    this.tvShowToScrape.downloadArtwork(MediaFileType.BANNER);
                } else {
                    model.startArtworkScrapeTask(this.tvShowToScrape, this.scraperMetadataConfig);
                }
            }
            if (this.scraperMetadataConfig.isEpisodes() && !(episodesToScrape = this.tvShowToScrape.getEpisodesToScrape()).isEmpty()) {
                TvShowEpisodeScrapeTask task = new TvShowEpisodeScrapeTask(episodesToScrape, this.mediaScraper);
                task.setLanguage(model.getLanguage());
                TmmTaskManager.getInstance().addUnnamedTask(task);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
            if (TvShowModuleManager.SETTINGS.getSyncTrakt()) {
                SyncTraktTvTask task = new SyncTraktTvTask(null, Arrays.asList(this.tvShowToScrape));
                TmmTaskManager.getInstance().addUnnamedTask(task);
            }
            this.setVisible(false);
        }
        if ("Cancel".equals(e.getActionCommand())) {
            this.setVisible(false);
        }
        if ("Abort".equals(e.getActionCommand())) {
            this.continueQueue = false;
            this.setVisible(false);
        }
    }

    private void searchTvShow(String searchTerm) {
        SearchTask task = new SearchTask(searchTerm);
        task.execute();
    }

    private void startProgressBar(final String description) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TvShowChooserDialog.this.lblProgressAction.setText(description);
                TvShowChooserDialog.this.progressBar.setVisible(true);
                TvShowChooserDialog.this.progressBar.setIndeterminate(true);
            }
        });
    }

    private void stopProgressBar() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TvShowChooserDialog.this.lblProgressAction.setText("");
                TvShowChooserDialog.this.progressBar.setVisible(false);
                TvShowChooserDialog.this.progressBar.setIndeterminate(false);
            }
        });
    }

    protected void initDataBindings() {
        JTableBinding jTableBinding = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, this.tvShowsFound, (JTable)this.table);
        BeanProperty tvShowChooserModelBeanProperty = BeanProperty.create((String)"combinedName");
        jTableBinding.addColumnBinding((Property)tvShowChooserModelBeanProperty).setEditable(false);
        jTableBinding.bind();
        BeanProperty jTableBeanProperty_1 = BeanProperty.create((String)"selectedElement.overview");
        BeanProperty jTextPaneBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.table, (Property)jTableBeanProperty_1, (Object)this.tpTvShowOverview, (Property)jTextPaneBeanProperty);
        autoBinding_1.bind();
        BeanProperty jTableBeanProperty_2 = BeanProperty.create((String)"selectedElement.posterUrl");
        BeanProperty imageLabelBeanProperty = BeanProperty.create((String)"imageUrl");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.table, (Property)jTableBeanProperty_2, (Object)this.lblTvShowPoster, (Property)imageLabelBeanProperty);
        autoBinding_2.bind();
        BeanProperty jTableBeanProperty_3 = BeanProperty.create((String)"selectedElement.combinedName");
        BeanProperty jTextAreaBeanProperty_1 = BeanProperty.create((String)"text");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.table, (Property)jTableBeanProperty_3, (Object)this.lblTvShowName, (Property)jTextAreaBeanProperty_1);
        autoBinding_3.bind();
    }

    public boolean showDialog() {
        this.setVisible(true);
        return this.continueQueue;
    }

    private class ChangeScraperAction
    extends AbstractAction {
        private static final long serialVersionUID = -3537728352474538431L;

        @Override
        public void actionPerformed(ActionEvent e) {
            TvShowChooserDialog.this.mediaScraper = (MediaScraper)TvShowChooserDialog.this.cbScraper.getSelectedItem();
            TvShowChooserDialog.this.searchTvShow(TvShowChooserDialog.this.textFieldSearchString.getText());
        }
    }

    private class ScrapeTask
    extends SwingWorker<Void, Void> {
        private TvShowChooserModel model;

        public ScrapeTask(TvShowChooserModel model) {
            this.model = model;
        }

        @Override
        public Void doInBackground() {
            TvShowChooserDialog.this.startProgressBar(BUNDLE.getString("chooser.scrapeing") + " " + this.model.getName());
            TvShowChooserDialog.this.okButton.setEnabled(false);
            this.model.scrapeMetaData();
            TvShowChooserDialog.this.okButton.setEnabled(true);
            return null;
        }

        @Override
        public void done() {
            TvShowChooserDialog.this.stopProgressBar();
        }
    }

    private class SearchTask
    extends SwingWorker<Void, Void> {
        private String searchTerm;
        private MediaLanguages language;

        public SearchTask(String searchTerm) {
            this.searchTerm = searchTerm;
            this.language = (MediaLanguages)TvShowChooserDialog.this.cbLanguage.getSelectedItem();
        }

        @Override
        public Void doInBackground() {
            TvShowChooserDialog.this.startProgressBar(BUNDLE.getString("chooser.searchingfor") + " " + this.searchTerm);
            List<MediaSearchResult> searchResult = TvShowChooserDialog.this.tvShowList.searchTvShow(this.searchTerm, TvShowChooserDialog.this.mediaScraper, this.language);
            TvShowChooserDialog.this.tvShowsFound.clear();
            if (searchResult.size() == 0) {
                TvShowChooserDialog.this.tvShowsFound.add(TvShowChooserModel.emptyResult);
            } else {
                MediaScraper mpFromResult = null;
                for (MediaSearchResult result : searchResult) {
                    if (mpFromResult == null) {
                        mpFromResult = TvShowChooserDialog.this.tvShowList.getMediaScraperById(result.getProviderId());
                    }
                    TvShowChooserDialog.this.tvShowsFound.add(new TvShowChooserModel(mpFromResult, TvShowChooserDialog.this.artworkScrapers, result, this.language));
                }
            }
            if (TvShowChooserDialog.this.tvShowsFound.size() == 1) {
                TvShowChooserDialog.this.table.setRowSelectionInterval(0, 0);
            }
            return null;
        }

        @Override
        public void done() {
            TvShowChooserDialog.this.stopProgressBar();
        }
    }
}

