/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.tasks.TvShowEpisodeScrapeTask;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.tvshows.dialogs.TvShowChooserDialog;

public class TvShowScrapeNewItemsAction
extends AbstractAction {
    private static final long serialVersionUID = -3365542777082781952L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public TvShowScrapeNewItemsAction() {
        this.putValue("Name", BUNDLE.getString("tvshow.scrape.newitems"));
        this.putValue("SwingLargeIconKey", IconManager.SEARCH);
        this.putValue("SmallIcon", IconManager.SEARCH);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TvShow tvShow;
        TvShowChooserDialog chooser;
        ArrayList<TvShow> newTvShows = new ArrayList<TvShow>();
        ArrayList<TvShowEpisode> newEpisodes = new ArrayList<TvShowEpisode>();
        for (TvShow tvShow2 : new ArrayList<TvShow>(TvShowList.getInstance().getTvShows())) {
            if (tvShow2.isNewlyAdded() && !tvShow2.isScraped()) {
                newTvShows.add(tvShow2);
                continue;
            }
            for (TvShowEpisode episode : tvShow2.getEpisodes()) {
                if (!episode.isNewlyAdded() || episode.isScraped()) continue;
                newEpisodes.add(episode);
            }
        }
        TvShowEpisodeScrapeTask task = new TvShowEpisodeScrapeTask(newEpisodes, TvShowList.getInstance().getDefaultMediaScraper());
        TmmTaskManager.getInstance().addUnnamedTask(task);
        Iterator i$ = newTvShows.iterator();
        while (i$.hasNext() && (chooser = new TvShowChooserDialog(tvShow = (TvShow)i$.next(), newTvShows.size() > 1)).showDialog()) {
        }
    }
}

