/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.core.tvshow.tasks.TvShowRenameTask;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowRenameAction
extends AbstractAction {
    private static final long serialVersionUID = -8988748633666277616L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public TvShowRenameAction(boolean withTitle) {
        this.putValue("SwingLargeIconKey", new ImageIcon(this.getClass().getResource("/org/tinymediamanager/ui/images/rename-icon.png")));
        this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/org/tinymediamanager/ui/images/rename-icon.png")));
        if (withTitle) {
            this.putValue("Name", BUNDLE.getString("tvshow.rename"));
        }
        this.putValue("ShortDescription", BUNDLE.getString("tvshow.rename"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List<TvShow> selectedTvShows = TvShowUIModule.getInstance().getSelectionModel().getSelectedTvShows();
        HashSet<TvShowEpisode> selectedEpisodes = new HashSet<TvShowEpisode>();
        for (Object obj : TvShowUIModule.getInstance().getSelectionModel().getSelectedObjects()) {
            TvShowEpisode episode;
            if (obj instanceof TvShowEpisode && !selectedTvShows.contains((episode = (TvShowEpisode)obj).getTvShow())) {
                selectedEpisodes.add(episode);
            }
            if (!(obj instanceof TvShowSeason)) continue;
            TvShowSeason season = (TvShowSeason)obj;
            for (TvShowEpisode episode2 : season.getEpisodes()) {
                selectedEpisodes.add(episode2);
            }
        }
        TvShowRenameTask renameTask = new TvShowRenameTask(selectedTvShows, new ArrayList<TvShowEpisode>(selectedEpisodes), true);
        if (TmmTaskManager.getInstance().addMainTask(renameTask)) {
            JOptionPane.showMessageDialog(null, BUNDLE.getString("onlyoneoperation"));
        }
    }
}

