/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows;

import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.TimeUnit;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.MediaFileAudioStream;
import org.tinymediamanager.core.entities.MediaFileSubtitle;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.tvshows.TvShowEpisodeSelectionModel;

public class TvShowEpisodeMediaInformationPanel
extends JPanel {
    private static final long serialVersionUID = 2513029074142934502L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private TvShowEpisodeSelectionModel selectionModel;
    private JLabel lblRuntime;
    private JCheckBox chckbxWatched;
    private JPanel panelVideoStreamDetails;
    private JLabel lblVideoCodec;
    private JLabel lblVideoResolution;
    private JLabel lblVideoBitrate;
    private JPanel panelAudioStreamT;
    private JPanel panelAudioStreamDetails;
    private JPanel panelSubtitleT;
    private JPanel panelSubtitleDetails;
    private JLabel lblSourceT;
    private JLabel lblSource;

    public TvShowEpisodeMediaInformationPanel(TvShowEpisodeSelectionModel model) {
        this.selectionModel = model;
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"25px"), FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"25px"), FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"25px"), FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"100px:grow")}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.UNRELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.UNRELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.UNRELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}));
        JLabel lblRuntimeT = new JLabel(BUNDLE.getString("metatag.runtime"));
        this.add((Component)lblRuntimeT, "2, 2");
        this.lblRuntime = new JLabel("");
        this.add((Component)this.lblRuntime, "6, 2");
        JLabel lblWatchedT = new JLabel(BUNDLE.getString("metatag.watched"));
        this.add((Component)lblWatchedT, "10, 2");
        this.chckbxWatched = new JCheckBox("");
        this.add((Component)this.chckbxWatched, "14, 2");
        JLabel lblVideoT = new JLabel(BUNDLE.getString("metatag.video"));
        this.add((Component)lblVideoT, "2, 4");
        JLabel lblMovie = new JLabel(BUNDLE.getString("metatag.episode"));
        this.add((Component)lblMovie, "6, 4");
        this.panelVideoStreamDetails = new JPanel();
        this.panelVideoStreamDetails.setLayout(new GridLayout(1, 4, 0, 25));
        this.add((Component)this.panelVideoStreamDetails, "10, 4, 7, 1, fill, top");
        this.lblVideoCodec = new JLabel("");
        this.panelVideoStreamDetails.add(this.lblVideoCodec);
        this.lblVideoResolution = new JLabel("");
        this.panelVideoStreamDetails.add(this.lblVideoResolution);
        this.lblVideoBitrate = new JLabel("");
        this.panelVideoStreamDetails.add(this.lblVideoBitrate);
        this.panelVideoStreamDetails.add(new JLabel(""));
        this.lblSourceT = new JLabel(BUNDLE.getString("metatag.source"));
        this.add((Component)this.lblSourceT, "6, 6");
        this.lblSource = new JLabel("");
        this.add((Component)this.lblSource, "10, 6");
        JLabel lblAudioT = new JLabel(BUNDLE.getString("metatag.audio"));
        this.add((Component)lblAudioT, "2, 8, default, top");
        this.panelAudioStreamT = new JPanel();
        this.panelAudioStreamT.setLayout(new GridLayout(0, 1));
        this.add((Component)this.panelAudioStreamT, "6, 8, left, top");
        this.panelAudioStreamDetails = new JPanel();
        this.panelAudioStreamDetails.setLayout(new GridLayout(0, 4));
        this.add((Component)this.panelAudioStreamDetails, "10, 8, 7, 1, fill, top");
        JLabel lblSubtitle = new JLabel(BUNDLE.getString("metatag.subtitles"));
        this.add((Component)lblSubtitle, "2, 10, default, top");
        this.panelSubtitleT = new JPanel();
        this.panelSubtitleT.setLayout(new GridLayout(0, 1));
        this.add((Component)this.panelSubtitleT, "6, 10, left, top");
        this.panelSubtitleDetails = new JPanel();
        this.panelSubtitleDetails.setLayout(new GridLayout(0, 1));
        this.add((Component)this.panelSubtitleDetails, "10, 10, 5, 1, left, top");
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String property = propertyChangeEvent.getPropertyName();
                Object source = propertyChangeEvent.getSource();
                if (source.getClass() == TvShowEpisodeSelectionModel.class && "selectedTvShowEpisode".equals(property) || "mediaInformation".equals(property)) {
                    TvShowEpisodeMediaInformationPanel.this.fillVideoStreamDetails();
                    TvShowEpisodeMediaInformationPanel.this.buildAudioStreamDetails();
                    TvShowEpisodeMediaInformationPanel.this.buildSubtitleStreamDetails();
                }
            }
        };
        this.selectionModel.addPropertyChangeListener(propertyChangeListener);
    }

    private void fillVideoStreamDetails() {
        List<MediaFile> mediaFiles = this.selectionModel.getSelectedTvShowEpisode().getMediaFiles(MediaFileType.VIDEO);
        if (mediaFiles.size() == 0) {
            return;
        }
        int runtime = this.selectionModel.getSelectedTvShowEpisode().getRuntimeFromMediaFiles();
        if (runtime == 0) {
            this.lblRuntime.setText("");
        } else {
            long h = TimeUnit.SECONDS.toHours(runtime);
            long m = TimeUnit.SECONDS.toMinutes((long)runtime - TimeUnit.HOURS.toSeconds(h));
            long s = TimeUnit.SECONDS.toSeconds((long)runtime - TimeUnit.HOURS.toSeconds(h) - TimeUnit.MINUTES.toSeconds(m));
            if (s > 30L) {
                ++m;
            }
            this.lblRuntime.setText(h + "h " + String.format("%02d", m) + "m");
        }
        MediaFile mediaFile = this.selectionModel.getSelectedTvShowEpisode().getBiggestMediaFile(MediaFileType.VIDEO);
        this.chckbxWatched.setSelected(this.selectionModel.getSelectedTvShowEpisode().isWatched());
        if (mediaFile != null) {
            this.lblVideoCodec.setText(mediaFile.getVideoCodec());
            this.lblVideoResolution.setText(mediaFile.getVideoResolution());
            this.lblVideoBitrate.setText(mediaFile.getBiteRateInKbps());
        }
        this.lblSource.setText(this.selectionModel.getSelectedTvShowEpisode().getMediaSource().toString());
    }

    private void buildAudioStreamDetails() {
        this.panelAudioStreamT.removeAll();
        this.panelAudioStreamDetails.removeAll();
        List<MediaFile> mediaFiles = this.selectionModel.getSelectedTvShowEpisode().getMediaFilesContainingAudioStreams();
        for (MediaFile mediaFile : mediaFiles) {
            for (int i = 0; i < mediaFile.getAudioStreams().size(); ++i) {
                MediaFileAudioStream audioStream = mediaFile.getAudioStreams().get(i);
                if (mediaFile.getType() == MediaFileType.VIDEO) {
                    this.panelAudioStreamT.add(new JLabel(BUNDLE.getString("metatag.internal")));
                } else {
                    this.panelAudioStreamT.add(new JLabel(BUNDLE.getString("metatag.external")));
                }
                this.panelAudioStreamDetails.add(new JLabel(audioStream.getCodec()));
                this.panelAudioStreamDetails.add(new JLabel(audioStream.getChannels()));
                this.panelAudioStreamDetails.add(new JLabel(audioStream.getBitrateInKbps()));
                this.panelAudioStreamDetails.add(new JLabel(audioStream.getLanguage()));
            }
        }
        this.panelAudioStreamDetails.revalidate();
        this.panelAudioStreamT.revalidate();
    }

    private void buildSubtitleStreamDetails() {
        this.panelSubtitleT.removeAll();
        this.panelSubtitleDetails.removeAll();
        HashSet<MediaFileSubtitle> subs = new HashSet<MediaFileSubtitle>();
        for (MediaFile mediaFile : this.selectionModel.getSelectedTvShowEpisode().getMediaFilesContainingSubtitles()) {
            for (int i = 0; i < mediaFile.getSubtitles().size(); ++i) {
                MediaFileSubtitle subtitle = mediaFile.getSubtitles().get(i);
                if (mediaFile.getType() == MediaFileType.SUBTITLE) {
                    this.panelSubtitleT.add(new JLabel(BUNDLE.getString("metatag.external")));
                    this.panelSubtitleDetails.add(new JLabel(mediaFile.getFilename()));
                    continue;
                }
                subs.add(subtitle);
            }
        }
        for (MediaFileSubtitle sub : subs) {
            this.panelSubtitleT.add(new JLabel(BUNDLE.getString("metatag.internal")));
            String info = sub.getLanguage() + (sub.isForced() ? " forced" : "") + " (" + sub.getCodec() + ")";
            this.panelSubtitleDetails.add(new JLabel(info));
        }
        this.panelSubtitleDetails.revalidate();
        this.panelSubtitleT.revalidate();
    }
}

