/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets.actions;

import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.moviesets.MovieSetUIModule;
import org.tinymediamanager.ui.moviesets.dialogs.MovieSetChooserDialog;

public class MovieSetSearchAction
extends AbstractAction {
    private static final long serialVersionUID = -2260581786599155278L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public MovieSetSearchAction(boolean withTitle) {
        if (withTitle) {
            this.putValue("Name", BUNDLE.getString("movieset.search"));
        }
        this.putValue("SwingLargeIconKey", IconManager.SEARCH);
        this.putValue("SmallIcon", IconManager.SEARCH);
        this.putValue("ShortDescription", BUNDLE.getString("movieset.search"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MovieSet movieSet;
        MovieSetChooserDialog chooser;
        List<MovieSet> selectedMovieSets = MovieSetUIModule.getInstance().getSelectionModel().getSelectedMovieSets();
        Iterator<MovieSet> i$ = selectedMovieSets.iterator();
        while (i$.hasNext() && (chooser = new MovieSetChooserDialog(movieSet = i$.next(), selectedMovieSets.size() > 1)).showDialog()) {
        }
    }
}

