/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets;

import java.util.Collections;
import java.util.Comparator;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.ui.moviesets.MovieTreeNode;

public class MovieSetTreeNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 1095499645850717752L;
    protected static final Comparator<TreeNode> nodeComparator = new Comparator<TreeNode>(){

        @Override
        public int compare(TreeNode o1, TreeNode o2) {
            if (o1 instanceof MovieTreeNode && o2 instanceof MovieTreeNode) {
                MovieTreeNode node1 = (MovieTreeNode)o1;
                Movie movie1 = (Movie)node1.getUserObject();
                MovieTreeNode node2 = (MovieTreeNode)o2;
                Movie movie2 = (Movie)node2.getUserObject();
                if (movie1 == null || movie2 == null || movie1.getMovieSet() == null || movie2.getMovieSet() == null) {
                    return 0;
                }
                int index1 = movie1.getMovieSet().getMovieIndex(movie1);
                int index2 = movie2.getMovieSet().getMovieIndex(movie2);
                return index1 - index2;
            }
            return o1.toString().compareToIgnoreCase(o2.toString());
        }
    };

    public MovieSetTreeNode(Object userObject) {
        super(userObject);
    }

    @Override
    public String toString() {
        if (this.getUserObject() instanceof MovieSet) {
            MovieSet movieSet = (MovieSet)this.getUserObject();
            return movieSet.getTitle();
        }
        return super.toString();
    }

    public void sort() {
        if (this.children != null) {
            Collections.sort(this.children, nodeComparator);
        }
    }
}

