/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;

public class MovieSetSelectionModel
extends AbstractModelObject {
    private static final String SELECTED_MOVIE_SET = "selectedMovieSet";
    private MovieSet selectedMovieSet;
    private MovieSet initalMovieSet;
    private PropertyChangeListener propertyChangeListener;
    private JTree tree;

    public MovieSetSelectionModel(JTree tree) {
        this.selectedMovieSet = this.initalMovieSet = new MovieSet("");
        this.tree = tree;
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MovieSetSelectionModel.this.firePropertyChange(evt);
            }
        };
    }

    public void setSelectedMovieSet(MovieSet movieSet) {
        MovieSet oldValue = this.selectedMovieSet;
        this.selectedMovieSet = movieSet != null ? movieSet : this.initalMovieSet;
        if (oldValue != null) {
            oldValue.removePropertyChangeListener(this.propertyChangeListener);
        }
        if (this.selectedMovieSet != null) {
            this.selectedMovieSet.addPropertyChangeListener(this.propertyChangeListener);
        }
        this.firePropertyChange(SELECTED_MOVIE_SET, oldValue, this.selectedMovieSet);
    }

    public MovieSet getSelectedMovieSet() {
        return this.selectedMovieSet;
    }

    public List<MovieSet> getSelectedMovieSets() {
        ArrayList<MovieSet> selectedMovieSets = new ArrayList<MovieSet>();
        TreePath[] paths = this.tree.getSelectionPaths();
        if (paths != null) {
            for (TreePath path : paths) {
                DefaultMutableTreeNode node;
                if (path.getPathCount() <= 1 || !((node = (DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject() instanceof MovieSet)) continue;
                MovieSet movieSet = (MovieSet)node.getUserObject();
                selectedMovieSets.add(movieSet);
            }
        }
        return selectedMovieSets;
    }

    public List<Movie> getSelectedMovies() {
        ArrayList<Movie> selectedMovies = new ArrayList<Movie>();
        TreePath[] paths = this.tree.getSelectionPaths();
        if (paths != null) {
            for (TreePath path : paths) {
                DefaultMutableTreeNode node;
                if (path.getPathCount() <= 1 || !((node = (DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject() instanceof Movie)) continue;
                Movie movie = (Movie)node.getUserObject();
                selectedMovies.add(movie);
            }
        }
        return selectedMovies;
    }

    public List<Movie> getSelectedMoviesRecursive() {
        ArrayList<Movie> selectedMovies = new ArrayList<Movie>();
        TreePath[] paths = this.tree.getSelectionPaths();
        if (paths != null) {
            for (TreePath path : paths) {
                Movie movie;
                if (path.getPathCount() <= 1) continue;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (node.getUserObject() instanceof MovieSet) {
                    MovieSet movieSet = (MovieSet)node.getUserObject();
                    for (Movie movie2 : movieSet.getMovies()) {
                        if (selectedMovies.contains(movie2)) continue;
                        selectedMovies.add(movie2);
                    }
                }
                if (!(node.getUserObject() instanceof Movie) || selectedMovies.contains(movie = (Movie)node.getUserObject())) continue;
                selectedMovies.add(movie);
            }
        }
        return selectedMovies;
    }
}

