/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.settings;

import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.apache.commons.lang3.StringUtils;
import org.imgscalr.Scalr;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.core.movie.MovieTrailerQuality;
import org.tinymediamanager.core.movie.MovieTrailerSources;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.mediaprovider.IMediaProvider;
import org.tinymediamanager.ui.TableColumnResizer;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.panels.MediaScraperConfigurationPanel;
import org.tinymediamanager.ui.panels.ScrollablePanel;

public class MovieTrailerSettingsPanel
extends ScrollablePanel {
    private static final long serialVersionUID = -1607146878528487625L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private MovieSettings settings = MovieModuleManager.MOVIE_SETTINGS;
    private List<TrailerScraper> scrapers = ObservableCollections.observableList(new ArrayList());
    private JTable tableTrailerScraper;
    private JTextPane tpScraperDescription;
    private JComboBox<MovieTrailerSources> cbTrailerSource;
    private JComboBox<MovieTrailerQuality> cbTrailerQuality;
    private JCheckBox checkBox;
    private JCheckBox chckbxAutomaticTrailerDownload;
    private JPanel panelScraperOptions;

    public MovieTrailerSettingsPanel() {
        List<String> enabledTrailerProviders = this.settings.getMovieTrailerScrapers();
        int selectedIndex = -1;
        int counter = 0;
        for (MediaScraper scraper : MovieList.getInstance().getAvailableTrailerScrapers()) {
            TrailerScraper trailerScraper = new TrailerScraper(scraper);
            if (enabledTrailerProviders.contains(trailerScraper.getScraperId())) {
                trailerScraper.active = true;
                if (selectedIndex < 0) {
                    selectedIndex = counter;
                }
            }
            this.scrapers.add(trailerScraper);
            ++counter;
        }
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_ROWSPEC}));
        JPanel panelTrailerScrapers = new JPanel();
        panelTrailerScrapers.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), BUNDLE.getString("scraper.trailer"), 4, 2, null, null));
        this.add((Component)panelTrailerScrapers, "2, 2, fill, fill");
        panelTrailerScrapers.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.UNRELATED_GAP_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"200dlu:grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"100dlu:grow"), FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.UNRELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC}));
        JScrollPane scrollPaneScraperDetails = new JScrollPane();
        scrollPaneScraperDetails.setHorizontalScrollBarPolicy(31);
        scrollPaneScraperDetails.setBorder(null);
        panelTrailerScrapers.add((Component)scrollPaneScraperDetails, "8, 1, 1, 2, fill, fill");
        JPanel panelScraperDetails = new JPanel();
        scrollPaneScraperDetails.setViewportView(panelScraperDetails);
        panelScraperDetails.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{RowSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}));
        Font font = UIManager.getFont("Label.font");
        String bodyRule = "body { font-family: " + font.getFamily() + "; " + "font-size: " + font.getSize() + "pt; }";
        this.tpScraperDescription = new JTextPane();
        this.tpScraperDescription.setOpaque(false);
        this.tpScraperDescription.setEditorKit(new HTMLEditorKit());
        ((HTMLDocument)this.tpScraperDescription.getDocument()).getStyleSheet().addRule(bodyRule);
        panelScraperDetails.add((Component)this.tpScraperDescription, "1, 1, fill, top");
        this.panelScraperOptions = new ScrollablePanel();
        this.panelScraperOptions.setLayout(new FlowLayout(0));
        panelScraperDetails.add((Component)this.panelScraperOptions, "1, 3, fill, top");
        JScrollPane scrollPaneScraper = new JScrollPane();
        panelTrailerScrapers.add((Component)scrollPaneScraper, "2, 2, 5, 1, fill, fill");
        this.tableTrailerScraper = new JTable();
        this.tableTrailerScraper.setRowHeight(29);
        scrollPaneScraper.setViewportView(this.tableTrailerScraper);
        JSeparator separator = new JSeparator();
        panelTrailerScrapers.add((Component)separator, "2, 4, 7, 1");
        this.checkBox = new JCheckBox(BUNDLE.getString("Settings.trailer.preferred"));
        panelTrailerScrapers.add((Component)this.checkBox, "2, 6, 7, 1");
        JLabel lblTrailerSource = new JLabel(BUNDLE.getString("Settings.trailer.source"));
        panelTrailerScrapers.add((Component)lblTrailerSource, "4, 8, right, default");
        this.cbTrailerSource = new JComboBox();
        this.cbTrailerSource.setModel(new DefaultComboBoxModel<MovieTrailerSources>(MovieTrailerSources.values()));
        panelTrailerScrapers.add(this.cbTrailerSource, "6, 8, fill, default");
        JLabel lblTrailerQuality = new JLabel(BUNDLE.getString("Settings.trailer.quality"));
        panelTrailerScrapers.add((Component)lblTrailerQuality, "4, 10, right, default");
        this.cbTrailerQuality = new JComboBox();
        this.cbTrailerQuality.setModel(new DefaultComboBoxModel<MovieTrailerQuality>(MovieTrailerQuality.values()));
        panelTrailerScrapers.add(this.cbTrailerQuality, "6, 10, fill, default");
        this.chckbxAutomaticTrailerDownload = new JCheckBox(BUNDLE.getString("Settings.trailer.automaticdownload"));
        panelTrailerScrapers.add((Component)this.chckbxAutomaticTrailerDownload, "2, 12, 7, 1");
        JLabel lblAutomaticTrailerDownloadHint = new JLabel(BUNDLE.getString("Settings.trailer.automaticdownload.hint"));
        TmmFontHelper.changeFont((JComponent)lblAutomaticTrailerDownloadHint, 0.833);
        panelTrailerScrapers.add((Component)lblAutomaticTrailerDownloadHint, "4, 14, 5, 1");
        this.initDataBindings();
        TableColumnResizer.setMaxWidthForColumn(this.tableTrailerScraper, 0, 2);
        TableColumnResizer.setMaxWidthForColumn(this.tableTrailerScraper, 1, 2);
        TableColumnResizer.adjustColumnPreferredWidths(this.tableTrailerScraper, 5);
        this.tableTrailerScraper.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent arg0) {
                if (arg0.getColumn() == 0) {
                    int row = arg0.getFirstRow();
                    TrailerScraper changedScraper = (TrailerScraper)MovieTrailerSettingsPanel.this.scrapers.get(row);
                    if (changedScraper.active) {
                        MovieTrailerSettingsPanel.this.settings.addMovieTrailerScraper(changedScraper.getScraperId());
                    } else {
                        MovieTrailerSettingsPanel.this.settings.removeMovieTrailerScraper(changedScraper.getScraperId());
                    }
                }
            }
        });
        this.tableTrailerScraper.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = MovieTrailerSettingsPanel.this.tableTrailerScraper.convertRowIndexToModel(MovieTrailerSettingsPanel.this.tableTrailerScraper.getSelectedRow());
                if (index > -1) {
                    MovieTrailerSettingsPanel.this.panelScraperOptions.removeAll();
                    if (((TrailerScraper)MovieTrailerSettingsPanel.this.scrapers.get(index)).getMediaProvider().getProviderInfo().getConfig().hasConfig()) {
                        MovieTrailerSettingsPanel.this.panelScraperOptions.add(new MediaScraperConfigurationPanel(((TrailerScraper)MovieTrailerSettingsPanel.this.scrapers.get(index)).getMediaProvider()));
                    }
                    MovieTrailerSettingsPanel.this.panelScraperOptions.revalidate();
                }
            }
        });
        if (selectedIndex < 0) {
            selectedIndex = 0;
        }
        if (counter > 0) {
            this.tableTrailerScraper.getSelectionModel().setSelectionInterval(selectedIndex, selectedIndex);
        }
    }

    protected void initDataBindings() {
        JTableBinding jTableBinding = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, this.scrapers, (JTable)this.tableTrailerScraper);
        BeanProperty trailerScraperBeanProperty = BeanProperty.create((String)"active");
        jTableBinding.addColumnBinding((Property)trailerScraperBeanProperty).setColumnName("Active").setColumnClass(Boolean.class);
        BeanProperty trailerScraperBeanProperty_1 = BeanProperty.create((String)"scraperLogo");
        jTableBinding.addColumnBinding((Property)trailerScraperBeanProperty_1).setColumnName("Logo").setEditable(false).setColumnClass(ImageIcon.class);
        BeanProperty trailerScraperBeanProperty_2 = BeanProperty.create((String)"scraperName");
        jTableBinding.addColumnBinding((Property)trailerScraperBeanProperty_2).setColumnName("Name").setEditable(false).setColumnClass(String.class);
        jTableBinding.bind();
        BeanProperty jTableBeanProperty = BeanProperty.create((String)"selectedElement.scraperDescription");
        BeanProperty jTextPaneBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tableTrailerScraper, (Property)jTableBeanProperty, (Object)this.tpScraperDescription, (Property)jTextPaneBeanProperty);
        autoBinding.bind();
        BeanProperty movieSettingsBeanProperty = BeanProperty.create((String)"trailerSource");
        BeanProperty jComboBoxBeanProperty = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty, this.cbTrailerSource, (Property)jComboBoxBeanProperty);
        autoBinding_1.bind();
        BeanProperty movieSettingsBeanProperty_1 = BeanProperty.create((String)"trailerQuality");
        BeanProperty jComboBoxBeanProperty_1 = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_1, this.cbTrailerQuality, (Property)jComboBoxBeanProperty_1);
        autoBinding_2.bind();
        BeanProperty movieSettingsBeanProperty_2 = BeanProperty.create((String)"useTrailerPreference");
        BeanProperty jCheckBoxBeanProperty = BeanProperty.create((String)"selected");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_2, (Object)this.checkBox, (Property)jCheckBoxBeanProperty);
        autoBinding_3.bind();
        BeanProperty movieSettingsBeanProperty_3 = BeanProperty.create((String)"automaticTrailerDownload");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty_3, (Object)this.chckbxAutomaticTrailerDownload, (Property)jCheckBoxBeanProperty);
        autoBinding_4.bind();
    }

    public class TrailerScraper
    extends AbstractModelObject {
        private MediaScraper scraper;
        private Icon scraperLogo;
        private boolean active;

        public TrailerScraper(MediaScraper scraper) {
            this.scraper = scraper;
            this.scraperLogo = scraper.getMediaProvider().getProviderInfo().getProviderLogo() == null ? new ImageIcon() : this.getScaledIcon(new ImageIcon(scraper.getMediaProvider().getProviderInfo().getProviderLogo()));
        }

        private ImageIcon getScaledIcon(ImageIcon original) {
            Canvas c = new Canvas();
            FontMetrics fm = c.getFontMetrics(MovieTrailerSettingsPanel.this.getFont());
            int height = (int)((float)fm.getHeight() * 2.0f);
            int width = original.getIconWidth() / original.getIconHeight() * height;
            BufferedImage scaledImage = Scalr.resize((BufferedImage)ImageCache.createImage(original.getImage()), (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.AUTOMATIC, (int)width, (int)height, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_ANTIALIAS});
            return new ImageIcon(scaledImage);
        }

        public String getScraperId() {
            return this.scraper.getId();
        }

        public String getScraperName() {
            return this.scraper.getName() + " - " + this.scraper.getVersion();
        }

        public String getScraperDescription() {
            String description = null;
            try {
                description = BUNDLE.getString("scraper." + this.scraper.getId() + ".hint");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (StringUtils.isBlank(description)) {
                description = this.scraper.getDescription();
            }
            return description;
        }

        public Icon getScraperLogo() {
            return this.scraperLogo;
        }

        public Boolean getActive() {
            return this.active;
        }

        public void setActive(Boolean newValue) {
            Boolean oldValue = this.active;
            this.active = newValue;
            this.firePropertyChange("active", oldValue, newValue);
        }

        public IMediaProvider getMediaProvider() {
            return this.scraper.getMediaProvider();
        }
    }
}

