/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.settings;

import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.apache.commons.lang3.StringUtils;
import org.imgscalr.Scalr;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.mediaprovider.IMediaProvider;
import org.tinymediamanager.ui.TableColumnResizer;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.panels.MediaScraperConfigurationPanel;
import org.tinymediamanager.ui.panels.ScrollablePanel;

public class MovieSubtitleSettingsPanel
extends ScrollablePanel {
    private static final long serialVersionUID = -1607146878528487625L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private MovieSettings settings = MovieModuleManager.MOVIE_SETTINGS;
    private List<SubtitleScraper> scrapers = ObservableCollections.observableList(new ArrayList());
    private JTable tableScraper;
    private JTextPane tpScraperDescription;
    private JPanel panelScraperOptions;
    private JComboBox cbScraperLanguage;

    public MovieSubtitleSettingsPanel() {
        this.initComponents();
    }

    private void initComponents() {
        List<String> enabledSubtitleProviders = this.settings.getMovieSubtitleScrapers();
        int selectedIndex = -1;
        int counter = 0;
        for (MediaScraper scraper : MovieList.getInstance().getAvailableSubtitleScrapers()) {
            SubtitleScraper subtitleScraper = new SubtitleScraper(scraper);
            if (enabledSubtitleProviders.contains(subtitleScraper.getScraperId())) {
                subtitleScraper.active = true;
                if (selectedIndex < 0) {
                    selectedIndex = counter;
                }
            }
            this.scrapers.add(subtitleScraper);
            ++counter;
        }
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.RELATED_GAP_ROWSPEC}));
        JPanel panelSubtitleScrapers = new JPanel();
        panelSubtitleScrapers.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), BUNDLE.getString("scraper.subtitle"), 4, 2, null, null));
        this.add((Component)panelSubtitleScrapers, "2, 2, 5, 1, fill, fill");
        panelSubtitleScrapers.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"100dlu:grow"), FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"200dlu:grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"100dlu:grow")}));
        JScrollPane scrollPaneScraperDetails = new JScrollPane();
        scrollPaneScraperDetails.setHorizontalScrollBarPolicy(31);
        scrollPaneScraperDetails.setBorder(null);
        panelSubtitleScrapers.add((Component)scrollPaneScraperDetails, "4, 1, 1, 2, fill, fill");
        JPanel panelScraperDetails = new JPanel();
        scrollPaneScraperDetails.setViewportView(panelScraperDetails);
        panelScraperDetails.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{RowSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}));
        Font font = UIManager.getFont("Label.font");
        String bodyRule = "body { font-family: " + font.getFamily() + "; " + "font-size: " + font.getSize() + "pt; }";
        this.tpScraperDescription = new JTextPane();
        this.tpScraperDescription.setOpaque(false);
        this.tpScraperDescription.setEditorKit(new HTMLEditorKit());
        ((HTMLDocument)this.tpScraperDescription.getDocument()).getStyleSheet().addRule(bodyRule);
        panelScraperDetails.add((Component)this.tpScraperDescription, "1, 1, fill, top");
        this.panelScraperOptions = new ScrollablePanel();
        this.panelScraperOptions.setLayout(new FlowLayout(0));
        panelScraperDetails.add((Component)this.panelScraperOptions, "1, 3, fill, top");
        JScrollPane scrollPaneScraper = new JScrollPane();
        panelSubtitleScrapers.add((Component)scrollPaneScraper, "2, 2, fill, fill");
        this.tableScraper = new JTable();
        this.tableScraper.setRowHeight(29);
        scrollPaneScraper.setViewportView(this.tableScraper);
        JLabel lblScraperLanguage = new JLabel(BUNDLE.getString("Settings.preferredLanguage"));
        this.add((Component)lblScraperLanguage, "2, 4, right, default");
        this.cbScraperLanguage = new JComboBox<MediaLanguages>(MediaLanguages.values());
        this.add((Component)this.cbScraperLanguage, "4, 4, fill, default");
        this.initDataBindings();
        TableColumnResizer.setMaxWidthForColumn(this.tableScraper, 0, 2);
        TableColumnResizer.setMaxWidthForColumn(this.tableScraper, 1, 2);
        TableColumnResizer.adjustColumnPreferredWidths(this.tableScraper, 5);
        this.tableScraper.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent arg0) {
                if (arg0.getColumn() == 0) {
                    int row = arg0.getFirstRow();
                    SubtitleScraper changedScraper = (SubtitleScraper)MovieSubtitleSettingsPanel.this.scrapers.get(row);
                    if (changedScraper.active) {
                        MovieSubtitleSettingsPanel.this.settings.addMovieSubtitleScraper(changedScraper.getScraperId());
                    } else {
                        MovieSubtitleSettingsPanel.this.settings.removeMovieSubtitleScraper(changedScraper.getScraperId());
                    }
                }
            }
        });
        this.tableScraper.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = MovieSubtitleSettingsPanel.this.tableScraper.convertRowIndexToModel(MovieSubtitleSettingsPanel.this.tableScraper.getSelectedRow());
                if (index > -1) {
                    MovieSubtitleSettingsPanel.this.panelScraperOptions.removeAll();
                    if (((SubtitleScraper)MovieSubtitleSettingsPanel.this.scrapers.get(index)).getMediaProvider().getProviderInfo().getConfig().hasConfig()) {
                        MovieSubtitleSettingsPanel.this.panelScraperOptions.add(new MediaScraperConfigurationPanel(((SubtitleScraper)MovieSubtitleSettingsPanel.this.scrapers.get(index)).getMediaProvider()));
                    }
                    MovieSubtitleSettingsPanel.this.panelScraperOptions.revalidate();
                }
            }
        });
        if (selectedIndex < 0) {
            selectedIndex = 0;
        }
        if (counter > 0) {
            this.tableScraper.getSelectionModel().setSelectionInterval(selectedIndex, selectedIndex);
        }
    }

    protected void initDataBindings() {
        JTableBinding jTableBinding = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, this.scrapers, (JTable)this.tableScraper);
        BeanProperty subtitleScraperBeanProperty = BeanProperty.create((String)"active");
        jTableBinding.addColumnBinding((Property)subtitleScraperBeanProperty).setColumnName("Active").setColumnClass(Boolean.class);
        BeanProperty subtitleScraperBeanProperty_1 = BeanProperty.create((String)"scraperLogo");
        jTableBinding.addColumnBinding((Property)subtitleScraperBeanProperty_1).setColumnName("Logo").setEditable(false).setColumnClass(ImageIcon.class);
        BeanProperty subtitleScraperBeanProperty_2 = BeanProperty.create((String)"scraperName");
        jTableBinding.addColumnBinding((Property)subtitleScraperBeanProperty_2).setColumnName("Name").setEditable(false).setColumnClass(String.class);
        jTableBinding.bind();
        BeanProperty jTableBeanProperty = BeanProperty.create((String)"selectedElement.scraperDescription");
        BeanProperty jTextPaneBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.tableScraper, (Property)jTableBeanProperty, (Object)this.tpScraperDescription, (Property)jTextPaneBeanProperty);
        autoBinding.bind();
        BeanProperty movieSettingsBeanProperty = BeanProperty.create((String)"subtitleScraperLanguage");
        BeanProperty jComboBoxBeanProperty = BeanProperty.create((String)"selectedItem");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.settings, (Property)movieSettingsBeanProperty, (Object)this.cbScraperLanguage, (Property)jComboBoxBeanProperty);
        autoBinding_1.bind();
    }

    public class SubtitleScraper
    extends AbstractModelObject {
        private MediaScraper scraper;
        private Icon scraperLogo;
        private boolean active;

        public SubtitleScraper(MediaScraper scraper) {
            this.scraper = scraper;
            this.scraperLogo = scraper.getMediaProvider().getProviderInfo().getProviderLogo() == null ? new ImageIcon() : this.getScaledIcon(new ImageIcon(scraper.getMediaProvider().getProviderInfo().getProviderLogo()));
        }

        private ImageIcon getScaledIcon(ImageIcon original) {
            Canvas c = new Canvas();
            FontMetrics fm = c.getFontMetrics(MovieSubtitleSettingsPanel.this.getFont());
            int height = (int)((float)fm.getHeight() * 2.0f);
            int width = original.getIconWidth() / original.getIconHeight() * height;
            BufferedImage scaledImage = Scalr.resize((BufferedImage)ImageCache.createImage(original.getImage()), (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.AUTOMATIC, (int)width, (int)height, (BufferedImageOp[])new BufferedImageOp[]{Scalr.OP_ANTIALIAS});
            return new ImageIcon(scaledImage);
        }

        public String getScraperId() {
            return this.scraper.getId();
        }

        public String getScraperName() {
            return this.scraper.getName() + " - " + this.scraper.getVersion();
        }

        public String getScraperDescription() {
            String description = null;
            try {
                description = BUNDLE.getString("scraper." + this.scraper.getId() + ".hint");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (StringUtils.isBlank(description)) {
                description = this.scraper.getDescription();
            }
            return description;
        }

        public Icon getScraperLogo() {
            return this.scraperLogo;
        }

        public Boolean getActive() {
            return this.active;
        }

        public void setActive(Boolean newValue) {
            Boolean oldValue = this.active;
            this.active = newValue;
            this.firePropertyChange("active", oldValue, newValue);
        }

        public IMediaProvider getMediaProvider() {
            return this.scraper.getMediaProvider();
        }
    }
}

