/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.dialogs;

import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import org.japura.gui.CheckComboBox;
import org.japura.gui.model.ListCheckModel;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.ui.EqualsLayout;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.MediaScraperCheckComboBox;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class MovieDownloadSubtitleDialog
extends TmmDialog {
    private static final long serialVersionUID = 3826984454317879241L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private MediaScraperCheckComboBox cbSubtitleScraper;
    private JComboBox<MediaLanguages> cbLanguage;
    private boolean startDownload = false;

    public MovieDownloadSubtitleDialog(String title) {
        super(title, "downloadSubtitle");
        this.setMinimumSize(new Dimension(this.getWidth(), this.getHeight()));
        JPanel panelCenter = new JPanel();
        this.getContentPane().add((Component)panelCenter, "Center");
        panelCenter.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"200dlu:grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"75dlu"), FormSpecs.RELATED_GAP_ROWSPEC}));
        JPanel panelScraper = new JPanel();
        panelCenter.add((Component)panelScraper, "2, 2, default, fill");
        panelScraper.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.PARAGRAPH_GAP_ROWSPEC, RowSpec.decode((String)"default:grow"), FormSpecs.RELATED_GAP_ROWSPEC}));
        JLabel lblScraper = new JLabel(BUNDLE.getString("scraper"));
        panelScraper.add((Component)lblScraper, "2, 2, right, default");
        this.cbSubtitleScraper = new MediaScraperCheckComboBox();
        this.cbSubtitleScraper.setTextFor(CheckComboBox.NONE, BUNDLE.getString("scraper.selected.none"));
        this.cbSubtitleScraper.setTextFor(CheckComboBox.MULTIPLE, BUNDLE.getString("scraper.selected.multiple"));
        this.cbSubtitleScraper.setTextFor(CheckComboBox.ALL, BUNDLE.getString("scraper.selected.all"));
        panelScraper.add((Component)((Object)this.cbSubtitleScraper), "4, 2");
        JLabel lblLanguage = new JLabel(BUNDLE.getString("metatag.language"));
        panelScraper.add((Component)lblLanguage, "2, 4, right, default");
        this.cbLanguage = new JComboBox<MediaLanguages>(MediaLanguages.values());
        panelScraper.add(this.cbLanguage, "4, 4");
        JTextArea taHint = new JTextArea();
        taHint.setLineWrap(true);
        taHint.setWrapStyleWord(true);
        taHint.setText(BUNDLE.getString("movie.download.subtitles.hint"));
        taHint.setOpaque(false);
        panelScraper.add((Component)taHint, "2, 6, 3, 1, fill, fill");
        JPanel panelButtons = new JPanel();
        panelButtons.setLayout(new EqualsLayout(5));
        panelButtons.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.getContentPane().add((Component)panelButtons, "South");
        JButton btnStart = new JButton(BUNDLE.getString("scraper.start"));
        btnStart.setIcon(IconManager.APPLY);
        btnStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MovieDownloadSubtitleDialog.this.startDownload = true;
                MovieDownloadSubtitleDialog.this.setVisible(false);
            }
        });
        panelButtons.add(btnStart);
        JButton btnCancel = new JButton(BUNDLE.getString("Button.cancel"));
        btnCancel.setIcon(IconManager.CANCEL);
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MovieDownloadSubtitleDialog.this.startDownload = false;
                MovieDownloadSubtitleDialog.this.setVisible(false);
            }
        });
        panelButtons.add(btnCancel);
        ListCheckModel model = this.cbSubtitleScraper.getModel();
        for (MediaScraper subtitleScraper : MovieList.getInstance().getAvailableSubtitleScrapers()) {
            model.addElement(new Object[]{subtitleScraper});
            if (!MovieModuleManager.MOVIE_SETTINGS.getMovieSubtitleScrapers().contains(subtitleScraper.getId())) continue;
            model.addCheck(new Object[]{subtitleScraper});
        }
        this.cbLanguage.setSelectedItem(MovieModuleManager.MOVIE_SETTINGS.getSubtitleScraperLanguage());
    }

    public List<MediaScraper> getSubtitleScrapers() {
        ArrayList<MediaScraper> scrapers = new ArrayList<MediaScraper>();
        ListCheckModel model = this.cbSubtitleScraper.getModel();
        for (Object checked : model.getCheckeds()) {
            if (checked == null || !(checked instanceof MediaScraper)) continue;
            scrapers.add((MediaScraper)checked);
        }
        return scrapers;
    }

    public MediaLanguages getLanguage() {
        return (MediaLanguages)this.cbLanguage.getSelectedItem();
    }

    public boolean shouldStartDownload() {
        return this.startDownload;
    }
}

