/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieSearchAndScrapeOptions;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.tasks.MovieScrapeTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.movies.dialogs.MovieScrapeMetadataDialog;

public class MovieUnscrapedScrapeAction
extends AbstractAction {
    private static final long serialVersionUID = -5330113139288186736L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public MovieUnscrapedScrapeAction() {
        this.putValue("Name", BUNDLE.getString("movie.scrape.unscraped"));
        this.putValue("ShortDescription", BUNDLE.getString("movie.scrape.unscraped.desc"));
        this.putValue("SmallIcon", IconManager.SEARCH);
        this.putValue("SwingLargeIconKey", IconManager.SEARCH);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List<Movie> unscrapedMovies = MovieList.getInstance().getUnscrapedMovies();
        if (unscrapedMovies.size() > 0) {
            MovieScrapeMetadataDialog dialog = new MovieScrapeMetadataDialog(BUNDLE.getString("movie.scrape.unscraped"));
            dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
            dialog.setVisible(true);
            MovieSearchAndScrapeOptions options = dialog.getMovieSearchAndScrapeConfig();
            if (dialog.shouldStartScrape()) {
                MovieScrapeTask scrapeTask = new MovieScrapeTask(unscrapedMovies, true, options);
                if (TmmTaskManager.getInstance().addMainTask(scrapeTask)) {
                    JOptionPane.showMessageDialog(null, BUNDLE.getString("onlyoneoperation"));
                }
            }
        }
    }
}

