/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.scraper.trakttv.SyncTraktTvTask;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.movies.MovieUIModule;

public class MovieSyncSelectedTraktTvAction
extends AbstractAction {
    private static final long serialVersionUID = 6640292090443882545L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public MovieSyncSelectedTraktTvAction() {
        this.putValue("Name", BUNDLE.getString("movie.synctrakt.selected"));
        this.putValue("ShortDescription", BUNDLE.getString("movie.synctrakt.selected.desc"));
        this.putValue("SmallIcon", IconManager.SYNC);
        this.putValue("SwingLargeIconKey", IconManager.SYNC);
        if (!Globals.isDonator()) {
            this.setEnabled(false);
            this.putValue("ShortDescription", BUNDLE.getString("tmm.donatorfunction.hint"));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ArrayList<Movie> selectedMovies = new ArrayList<Movie>(MovieUIModule.getInstance().getSelectionModel().getSelectedMovies());
        SyncTraktTvTask task = new SyncTraktTvTask(selectedMovies, null);
        TmmTaskManager.getInstance().addUnnamedTask(task);
    }
}

