/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies;

import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.tinymediamanager.ui.ITmmUIModule;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.movies.MoviePanel;
import org.tinymediamanager.ui.movies.MovieSelectionModel;
import org.tinymediamanager.ui.movies.actions.MovieEditAction;
import org.tinymediamanager.ui.movies.actions.MovieSingleScrapeAction;
import org.tinymediamanager.ui.movies.actions.MovieUpdateDatasourceAction;
import org.tinymediamanager.ui.movies.settings.MovieSettingsContainerPanel;

public class MovieUIModule
implements ITmmUIModule {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final String ID = "movies";
    private static MovieUIModule instance = null;
    private MoviePanel listPanel;
    private JPanel detailPanel;
    private JPanel settingsPanel;
    private final MovieSelectionModel selectionModel;
    private Action searchAction;
    private Action editAction;
    private Action updateAction;
    private JPopupMenu searchPopupMenu;
    private JPopupMenu editPopupMenu;

    private MovieUIModule() {
        this.selectionModel = MainWindow.getActiveInstance().getMoviePanel().movieSelectionModel;
    }

    public static MovieUIModule getInstance() {
        if (instance == null) {
            instance = new MovieUIModule();
        }
        return instance;
    }

    public MovieSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    private void createActions() {
        this.searchAction = new MovieSingleScrapeAction(false);
        this.editAction = new MovieEditAction(false);
        this.updateAction = new MovieUpdateDatasourceAction(false);
    }

    private void createPopupMenu() {
        this.searchPopupMenu = new JPopupMenu();
        this.searchPopupMenu.add(new MovieSingleScrapeAction(true));
        this.editPopupMenu = new JPopupMenu();
        this.editPopupMenu.add(new MovieEditAction(true));
    }

    @Override
    public String getModuleId() {
        return ID;
    }

    @Override
    public JPanel getTabPanel() {
        return this.listPanel;
    }

    @Override
    public String getTabTitle() {
        return BUNDLE.getString("tmm.movies");
    }

    @Override
    public JPanel getDetailPanel() {
        return this.detailPanel;
    }

    @Override
    public Action getSearchAction() {
        return this.searchAction;
    }

    @Override
    public JPopupMenu getSearchMenu() {
        return this.searchPopupMenu;
    }

    @Override
    public Action getEditAction() {
        return this.editAction;
    }

    @Override
    public JPopupMenu getEditMenu() {
        return this.editPopupMenu;
    }

    @Override
    public Action getUpdateAction() {
        return this.updateAction;
    }

    @Override
    public JPopupMenu getUpdateMenu() {
        return null;
    }

    @Override
    public Action getExportAction() {
        return null;
    }

    @Override
    public JPopupMenu getExportMenu() {
        return null;
    }

    @Override
    public JPanel getSettingsPanel() {
        if (this.settingsPanel == null) {
            this.settingsPanel = new MovieSettingsContainerPanel();
        }
        return this.settingsPanel;
    }
}

