/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.matchers.MatcherEditor;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import ca.odell.glazedlists.swing.TableComparatorChooser;
import ca.odell.glazedlists.swing.TextComponentMatcherEditor;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.testing.FakeTmmTaskAction;
import org.tinymediamanager.ui.BorderCellRenderer;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.IconRenderer;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.actions.RequestFocusAction;
import org.tinymediamanager.ui.components.EnhancedTextField;
import org.tinymediamanager.ui.components.JSplitButton;
import org.tinymediamanager.ui.components.ZebraJTable;
import org.tinymediamanager.ui.movies.MovieComparator;
import org.tinymediamanager.ui.movies.MovieExtendedSearchPanel;
import org.tinymediamanager.ui.movies.MovieFilterator;
import org.tinymediamanager.ui.movies.MovieInformationPanel;
import org.tinymediamanager.ui.movies.MovieMatcherEditor;
import org.tinymediamanager.ui.movies.MovieSelectionModel;
import org.tinymediamanager.ui.movies.MovieTableFormat;
import org.tinymediamanager.ui.movies.MovieTableMouseListener;
import org.tinymediamanager.ui.movies.actions.DebugDumpMovie;
import org.tinymediamanager.ui.movies.actions.MovieAssignMovieSetAction;
import org.tinymediamanager.ui.movies.actions.MovieBatchEditAction;
import org.tinymediamanager.ui.movies.actions.MovieClearImageCacheAction;
import org.tinymediamanager.ui.movies.actions.MovieCreateOfflineAction;
import org.tinymediamanager.ui.movies.actions.MovieDeleteAction;
import org.tinymediamanager.ui.movies.actions.MovieDownloadMissingArtworkAction;
import org.tinymediamanager.ui.movies.actions.MovieEditAction;
import org.tinymediamanager.ui.movies.actions.MovieExportAction;
import org.tinymediamanager.ui.movies.actions.MovieFindMissingAction;
import org.tinymediamanager.ui.movies.actions.MovieMediaInformationAction;
import org.tinymediamanager.ui.movies.actions.MovieRemoveAction;
import org.tinymediamanager.ui.movies.actions.MovieRenameAction;
import org.tinymediamanager.ui.movies.actions.MovieRenamePreviewAction;
import org.tinymediamanager.ui.movies.actions.MovieRewriteNfoAction;
import org.tinymediamanager.ui.movies.actions.MovieSelectedScrapeAction;
import org.tinymediamanager.ui.movies.actions.MovieSelectedScrapeMetadataAction;
import org.tinymediamanager.ui.movies.actions.MovieSetWatchedFlagAction;
import org.tinymediamanager.ui.movies.actions.MovieSingleScrapeAction;
import org.tinymediamanager.ui.movies.actions.MovieSubtitleDownloadAction;
import org.tinymediamanager.ui.movies.actions.MovieSubtitleSearchAction;
import org.tinymediamanager.ui.movies.actions.MovieSyncSelectedTraktTvAction;
import org.tinymediamanager.ui.movies.actions.MovieSyncTraktTvAction;
import org.tinymediamanager.ui.movies.actions.MovieSyncWatchedTraktTvAction;
import org.tinymediamanager.ui.movies.actions.MovieTrailerDownloadAction;
import org.tinymediamanager.ui.movies.actions.MovieUnscrapedScrapeAction;
import org.tinymediamanager.ui.movies.actions.MovieUpdateAction;
import org.tinymediamanager.ui.movies.actions.MovieUpdateDatasourceAction;
import org.tinymediamanager.ui.movies.actions.MovieUpdateSingleDatasourceAction;

public class MoviePanel
extends JPanel {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MoviePanel.class);
    private final Action actionUpdateDataSources = new MovieUpdateDatasourceAction(false);
    private final Action actionUpdateDataSources2 = new MovieUpdateDatasourceAction(true);
    private final Action actionUpdateMovie = new MovieUpdateAction();
    private final Action actionScrape = new MovieSingleScrapeAction(false);
    private final Action actionScrape2 = new MovieSingleScrapeAction(true);
    private final Action actionEditMovie = new MovieEditAction(false);
    private final Action actionEditMovie2 = new MovieEditAction(true);
    private final Action actionScrapeUnscraped = new MovieUnscrapedScrapeAction();
    private final Action actionScrapeSelected = new MovieSelectedScrapeAction();
    private final Action actionScrapeMetadataSelected = new MovieSelectedScrapeMetadataAction();
    private final Action actionAssignMovieSets = new MovieAssignMovieSetAction();
    private final Action actionRenamerPreview = new MovieRenamePreviewAction();
    private final Action actionSyncTrakt = new MovieSyncTraktTvAction();
    private final Action actionSyncWatchedTrakt = new MovieSyncWatchedTraktTvAction();
    private final Action actionSyncSelectedTrakt = new MovieSyncSelectedTraktTvAction();
    private final Action actionTrailerDownload = new MovieTrailerDownloadAction();
    private final Action actionSearchSubtitle = new MovieSubtitleSearchAction();
    private final Action actionDownloadSubtitle = new MovieSubtitleDownloadAction();
    private final Action actionDownloadMissingArtwork = new MovieDownloadMissingArtworkAction();
    private final Action actionRename = new MovieRenameAction(false);
    private final Action actionRename2 = new MovieRenameAction(true);
    private final Action actionRemove2 = new MovieRemoveAction();
    private final Action actionDelete2 = new MovieDeleteAction();
    private final Action actionExport = new MovieExportAction();
    private final Action actionRewriteNfo = new MovieRewriteNfoAction();
    private final Action debugDumpMovie = new DebugDumpMovie();
    private final Action actionMediaInformation = new MovieMediaInformationAction(false);
    private final Action actionMediaInformation2 = new MovieMediaInformationAction(true);
    private final Action actionBatchEdit = new MovieBatchEditAction();
    private final Action actionSetWatchedFlag = new MovieSetWatchedFlagAction();
    private final Action actionClearImageCache = new MovieClearImageCacheAction();
    private MovieList movieList;
    private JTextField textField;
    private ZebraJTable table;
    private JPanel panelMovieCount;
    private JLabel lblMovieCount;
    private JLabel lblMovieCountTotal;
    private JButton btnRen;
    private JMenu menu;
    private DefaultEventTableModel<Movie> movieTableModel;
    private SortedList<Movie> sortedMovies;
    private FilterList<Movie> textFilteredMovies;
    private JPanel panelExtendedSearch;
    private JLabel lblMovieCountOf;
    private JLabel lblMovieCountFiltered;
    private JSplitPane splitPaneHorizontal;
    private MovieInformationPanel panelRight;
    private JButton btnMediaInformation;
    public MovieSelectionModel movieSelectionModel;

    public MoviePanel() {
        LOGGER.debug("loading MovieList");
        this.movieList = MovieList.getInstance();
        this.sortedMovies = new SortedList((EventList)GlazedListsSwing.swingThreadProxyList((EventList)((ObservableElementList)this.movieList.getMovies())), (Comparator)new MovieComparator());
        this.sortedMovies.setMode(1);
        this.menu = new JMenu(BUNDLE.getString("tmm.movies"));
        JFrame mainFrame = MainWindow.getFrame();
        JMenuBar menuBar = mainFrame.getJMenuBar();
        menuBar.add(this.menu);
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"850px:grow"), FormFactory.RELATED_GAP_COLSPEC}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"500px:grow")}));
        this.splitPaneHorizontal = new JSplitPane();
        this.splitPaneHorizontal.setContinuousLayout(true);
        this.add((Component)this.splitPaneHorizontal, "2, 2, fill, fill");
        JPanel panelMovieList = new JPanel();
        this.splitPaneHorizontal.setLeftComponent(panelMovieList);
        panelMovieList.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow"), ColumnSpec.decode((String)"default:grow"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, new RowSpec[]{RowSpec.decode((String)"26px"), FormFactory.RELATED_GAP_ROWSPEC, RowSpec.decode((String)"fill:max(200px;default):grow"), FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        JToolBar toolBar = new JToolBar();
        toolBar.setRollover(true);
        toolBar.setFloatable(false);
        toolBar.setOpaque(false);
        panelMovieList.add((Component)toolBar, "2, 1, left, fill");
        final JSplitButton buttonUpdateDatasource = new JSplitButton(IconManager.REFRESH);
        buttonUpdateDatasource.setText("   ");
        buttonUpdateDatasource.setHorizontalAlignment(2);
        buttonUpdateDatasource.setSplitWidth(18);
        buttonUpdateDatasource.setToolTipText(BUNDLE.getString("update.datasource"));
        buttonUpdateDatasource.addSplitButtonActionListener(new JSplitButton.SplitButtonActionListener(){

            @Override
            public void buttonClicked(ActionEvent e) {
                MoviePanel.this.actionUpdateDataSources.actionPerformed(e);
            }

            @Override
            public void splitButtonClicked(ActionEvent e) {
                buttonUpdateDatasource.getPopupMenu().removeAll();
                JMenuItem item = new JMenuItem(MoviePanel.this.actionUpdateDataSources2);
                buttonUpdateDatasource.getPopupMenu().add(item);
                buttonUpdateDatasource.getPopupMenu().addSeparator();
                for (String ds : MovieModuleManager.MOVIE_SETTINGS.getMovieDataSource()) {
                    buttonUpdateDatasource.getPopupMenu().add(new JMenuItem(new MovieUpdateSingleDatasourceAction(ds)));
                }
                buttonUpdateDatasource.getPopupMenu().addSeparator();
                buttonUpdateDatasource.getPopupMenu().add(new JMenuItem(MoviePanel.this.actionUpdateMovie));
                buttonUpdateDatasource.getPopupMenu().pack();
            }
        });
        JPopupMenu popup = new JPopupMenu("popup");
        buttonUpdateDatasource.setPopupMenu(popup);
        toolBar.add(buttonUpdateDatasource);
        JSplitButton buttonScrape = new JSplitButton(IconManager.SEARCH);
        buttonScrape.setText("   ");
        buttonScrape.setHorizontalAlignment(2);
        buttonScrape.setSplitWidth(18);
        buttonScrape.setToolTipText(BUNDLE.getString("movie.scrape.selected"));
        buttonScrape.addSplitButtonActionListener(new JSplitButton.SplitButtonActionListener(){

            @Override
            public void buttonClicked(ActionEvent e) {
                MoviePanel.this.actionScrape.actionPerformed(e);
            }

            @Override
            public void splitButtonClicked(ActionEvent e) {
            }
        });
        popup = new JPopupMenu("popup");
        JMenuItem item = new JMenuItem(this.actionScrape2);
        popup.add(item);
        item = new JMenuItem(this.actionScrapeUnscraped);
        popup.add(item);
        item = new JMenuItem(this.actionScrapeSelected);
        popup.add(item);
        buttonScrape.setPopupMenu(popup);
        toolBar.add(buttonScrape);
        toolBar.add(this.actionEditMovie);
        this.btnRen = new JButton("REN");
        this.btnRen.setAction(this.actionRename);
        toolBar.add(this.btnRen);
        this.btnMediaInformation = new JButton("MI");
        this.btnMediaInformation.setAction(this.actionMediaInformation);
        toolBar.add(this.btnMediaInformation);
        JButton btnCreateOflline = new JButton();
        btnCreateOflline.setAction(new MovieCreateOfflineAction(false));
        toolBar.add(btnCreateOflline);
        this.textField = EnhancedTextField.createSearchTextField();
        panelMovieList.add((Component)this.textField, "3, 1, right, bottom");
        this.textField.setColumns(13);
        this.getInputMap(2).put(KeyStroke.getKeyStroke(70, 128), "search");
        this.getActionMap().put("search", new RequestFocusAction(this.textField));
        TextComponentMatcherEditor textMatcherEditor = new TextComponentMatcherEditor((JTextComponent)this.textField, (TextFilterator)new MovieFilterator());
        MovieMatcherEditor movieMatcherEditor = new MovieMatcherEditor();
        FilterList extendedFilteredMovies = new FilterList(this.sortedMovies, (MatcherEditor)movieMatcherEditor);
        this.textFilteredMovies = new FilterList((EventList)extendedFilteredMovies, (MatcherEditor)textMatcherEditor);
        this.movieSelectionModel = new MovieSelectionModel(this.sortedMovies, (EventList<Movie>)this.textFilteredMovies, movieMatcherEditor);
        this.movieTableModel = new DefaultEventTableModel((EventList)GlazedListsSwing.swingThreadProxyList(this.textFilteredMovies), (TableFormat)new MovieTableFormat());
        this.table = new ZebraJTable((TableModel)this.movieTableModel);
        this.movieTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent arg0) {
                MoviePanel.this.lblMovieCountFiltered.setText(String.valueOf(MoviePanel.this.movieTableModel.getRowCount()));
                ListSelectionModel selectionModel = MoviePanel.this.table.getSelectionModel();
                if (selectionModel.isSelectionEmpty() && MoviePanel.this.movieTableModel.getRowCount() > 0) {
                    selectionModel.setSelectionInterval(0, 0);
                }
                if (selectionModel.isSelectionEmpty() && MoviePanel.this.movieTableModel.getRowCount() == 0) {
                    MoviePanel.this.movieSelectionModel.setSelectedMovie(null);
                }
            }
        });
        this.movieSelectionModel.setTableComparatorChooser((TableComparatorChooser<Movie>)TableComparatorChooser.install((JTable)this.table, this.sortedMovies, (Object)TableComparatorChooser.SINGLE_COLUMN));
        this.table.setNewFontSize((int)Math.round((double)this.getFont().getSize() * 0.916));
        JScrollPane scrollPane = ZebraJTable.createStripedJScrollPane(this.table);
        panelMovieList.add((Component)scrollPane, "2, 3, 4, 1, fill, fill");
        final JToggleButton filterButton = new JToggleButton(IconManager.FILTER);
        filterButton.setToolTipText(BUNDLE.getString("movieextendedsearch.options"));
        panelMovieList.add((Component)filterButton, "5, 1, right, bottom");
        this.movieSelectionModel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("filterChanged".equals(evt.getPropertyName())) {
                    if (Boolean.TRUE.equals(evt.getNewValue())) {
                        filterButton.setIcon(IconManager.FILTER_ACTIVE);
                        filterButton.setToolTipText(BUNDLE.getString("movieextendedsearch.options.active"));
                    } else {
                        filterButton.setIcon(IconManager.FILTER);
                        filterButton.setToolTipText(BUNDLE.getString("movieextendedsearch.options"));
                    }
                }
            }
        });
        this.panelExtendedSearch = new MovieExtendedSearchPanel(this.movieSelectionModel);
        this.panelExtendedSearch.setVisible(false);
        filterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (MoviePanel.this.panelExtendedSearch.isVisible()) {
                    MoviePanel.this.panelExtendedSearch.setVisible(false);
                } else {
                    MoviePanel.this.panelExtendedSearch.setVisible(true);
                }
            }
        });
        JPanel panelStatus = new JPanel();
        panelMovieList.add((Component)panelStatus, "2, 6, 2, 1");
        panelStatus.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"1px"), ColumnSpec.decode((String)"146px:grow"), FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{RowSpec.decode((String)"fill:default:grow")}));
        this.panelMovieCount = new JPanel();
        panelStatus.add((Component)this.panelMovieCount, "3, 1, left, fill");
        this.lblMovieCount = new JLabel(BUNDLE.getString("tmm.movies") + ":");
        this.panelMovieCount.add(this.lblMovieCount);
        this.lblMovieCountFiltered = new JLabel("");
        this.panelMovieCount.add(this.lblMovieCountFiltered);
        this.lblMovieCountOf = new JLabel(BUNDLE.getString("tmm.of"));
        this.panelMovieCount.add(this.lblMovieCountOf);
        this.lblMovieCountTotal = new JLabel("");
        this.panelMovieCount.add(this.lblMovieCountTotal);
        JLayeredPane layeredPaneRight = new JLayeredPane();
        layeredPaneRight.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{ColumnSpec.decode((String)"default"), ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{RowSpec.decode((String)"default"), RowSpec.decode((String)"default:grow")}));
        this.panelRight = new MovieInformationPanel(this.movieSelectionModel);
        layeredPaneRight.add((Component)this.panelRight, "1, 1, 2, 2, fill, fill");
        layeredPaneRight.setLayer(this.panelRight, 0);
        layeredPaneRight.add((Component)this.panelExtendedSearch, "1, 1, fill, fill");
        layeredPaneRight.setLayer(this.panelExtendedSearch, 1);
        this.splitPaneHorizontal.setRightComponent(layeredPaneRight);
        this.splitPaneHorizontal.setContinuousLayout(true);
        this.initDataBindings();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                MoviePanel.this.menu.setVisible(false);
                super.componentHidden(e);
            }

            @Override
            public void componentShown(ComponentEvent e) {
                MoviePanel.this.menu.setVisible(true);
                super.componentHidden(e);
            }
        });
        this.init();
        if (MovieModuleManager.MOVIE_SETTINGS.isStoreUiFilters()) {
            this.movieList.searchDuplicates();
            this.movieSelectionModel.filterMovies(MovieModuleManager.MOVIE_SETTINGS.getUiFilters());
        }
    }

    private void buildMenu() {
        this.menu.setMnemonic(77);
        JMenuItem menuItem = this.menu.add(this.actionUpdateDataSources2);
        menuItem.setMnemonic(85);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(85, 3));
        final JMenu menuUpdateDatasources = new JMenu(BUNDLE.getString("update.datasource"));
        final JMenu menuFindMissingMovies = new JMenu(BUNDLE.getString("movie.findmissing"));
        menuUpdateDatasources.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent arg0) {
            }

            @Override
            public void menuDeselected(MenuEvent arg0) {
            }

            @Override
            public void menuSelected(MenuEvent arg0) {
                menuUpdateDatasources.removeAll();
                menuFindMissingMovies.removeAll();
                for (String ds : MovieModuleManager.MOVIE_SETTINGS.getMovieDataSource()) {
                    JMenuItem item = new JMenuItem(new MovieUpdateSingleDatasourceAction(ds));
                    menuUpdateDatasources.add(item);
                    item = new JMenuItem(new MovieFindMissingAction(ds));
                    menuFindMissingMovies.add(item);
                }
            }
        });
        this.menu.add(menuUpdateDatasources);
        this.menu.add(new MovieFindMissingAction());
        this.menu.add(menuFindMissingMovies);
        this.menu.add(new MovieCreateOfflineAction(true));
        this.menu.addSeparator();
        JMenu menuScrape = new JMenu(BUNDLE.getString("Button.scrape"));
        menuScrape.setMnemonic(83);
        menuItem = menuScrape.add(this.actionScrape2);
        menuItem.setMnemonic(83);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(83, 3));
        menuItem = menuScrape.add(this.actionScrapeSelected);
        menuItem.setMnemonic(70);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(70, 3));
        menuItem = menuScrape.add(this.actionScrapeUnscraped);
        menuItem.setMnemonic(85);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(85, 3));
        menuItem = menuScrape.add(this.actionScrapeMetadataSelected);
        menuItem.setMnemonic(77);
        menuScrape.add(this.actionAssignMovieSets);
        this.menu.add(menuScrape);
        JMenu menuEdit = new JMenu(BUNDLE.getString("Button.edit"));
        menuEdit.setMnemonic(69);
        menuItem = menuEdit.add(this.actionEditMovie2);
        menuItem.setMnemonic(69);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(69, 3));
        menuItem = menuEdit.add(this.actionBatchEdit);
        menuItem.setMnemonic(66);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(66, 3));
        menuItem = menuEdit.add(this.actionSetWatchedFlag);
        menuItem.setMnemonic(87);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(87, 3));
        menuItem = menuEdit.add(this.actionRename2);
        menuItem.setMnemonic(82);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(82, 3));
        menuItem = menuEdit.add(this.actionRenamerPreview);
        menuItem.setMnemonic(80);
        this.menu.add(menuEdit);
        menuItem = this.menu.add(this.actionRewriteNfo);
        menuItem.setMnemonic(78);
        menuItem = this.menu.add(this.actionDownloadMissingArtwork);
        menuItem = this.menu.add(this.actionTrailerDownload);
        menuItem = this.menu.add(this.actionSearchSubtitle);
        menuItem = this.menu.add(this.actionDownloadSubtitle);
        this.menu.addSeparator();
        menuItem = this.menu.add(this.actionMediaInformation2);
        menuItem.setMnemonic(77);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(77, 3));
        menuItem = this.menu.add(this.actionExport);
        menuItem.setMnemonic(88);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(88, 3));
        menuItem = this.menu.add(this.actionRemove2);
        menuItem.setMnemonic(82);
        menuItem.setAccelerator(KeyStroke.getKeyStroke('\u007f'));
        menuItem = this.menu.add(this.actionDelete2);
        menuItem.setMnemonic(82);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(127, 1));
        this.menu.addSeparator();
        menuItem = this.menu.add(this.actionSyncTrakt);
        menuItem.setMnemonic(84);
        menuItem = this.menu.add(this.actionSyncWatchedTrakt);
        menuItem.setMnemonic(87);
        menuItem = this.menu.add(this.actionSyncSelectedTrakt);
        this.menu.addSeparator();
        menuItem = this.menu.add(this.actionClearImageCache);
        menuItem.setMnemonic(67);
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(this.actionScrape2);
        popupMenu.add(this.actionScrapeSelected);
        popupMenu.add(this.actionScrapeUnscraped);
        popupMenu.add(this.actionScrapeMetadataSelected);
        popupMenu.add(this.actionAssignMovieSets);
        popupMenu.addSeparator();
        popupMenu.add(this.actionUpdateMovie);
        popupMenu.addSeparator();
        popupMenu.add(this.actionEditMovie2);
        popupMenu.add(this.actionBatchEdit);
        popupMenu.add(this.actionSetWatchedFlag);
        popupMenu.add(this.actionRewriteNfo);
        popupMenu.add(this.actionRename2);
        popupMenu.add(this.actionRenamerPreview);
        popupMenu.add(this.actionMediaInformation2);
        popupMenu.add(this.actionExport);
        popupMenu.add(this.actionDownloadMissingArtwork);
        popupMenu.add(this.actionTrailerDownload);
        popupMenu.add(this.actionSearchSubtitle);
        popupMenu.add(this.actionDownloadSubtitle);
        popupMenu.addSeparator();
        popupMenu.add(this.actionSyncTrakt);
        popupMenu.add(this.actionSyncWatchedTrakt);
        popupMenu.add(this.actionSyncSelectedTrakt);
        popupMenu.addSeparator();
        popupMenu.add(this.actionClearImageCache);
        popupMenu.addSeparator();
        popupMenu.add(this.actionRemove2);
        popupMenu.add(this.actionDelete2);
        if (Globals.isDebug()) {
            JMenu menuDebug = new JMenu("Debug");
            menuDebug.add(this.debugDumpMovie);
            menuDebug.addSeparator();
            menuDebug.add(new FakeTmmTaskAction("download", 1, 10));
            menuDebug.add(new FakeTmmTaskAction("download", 10, 10));
            menuDebug.add(new FakeTmmTaskAction("image", 1, 10));
            menuDebug.add(new FakeTmmTaskAction("image", 10, 10));
            menuDebug.add(new FakeTmmTaskAction("unnamed", 1, 10));
            menuDebug.add(new FakeTmmTaskAction("unnamed", 10, 10));
            popupMenu.add(menuDebug);
        }
        MovieTableMouseListener mouseListener = new MovieTableMouseListener(popupMenu, this.table);
        this.table.addMouseListener(mouseListener);
    }

    private void init() {
        ListSelectionModel selectionModel;
        this.buildMenu();
        this.table.getColumnModel().getColumn(0).setCellRenderer(new BorderCellRenderer());
        this.table.getColumnModel().getColumn(0).setIdentifier("title");
        int width = this.table.getFontMetrics(this.table.getFont()).stringWidth(" 2000");
        int titleWidth = this.table.getFontMetrics(this.table.getFont()).stringWidth(BUNDLE.getString("metatag.year"));
        if (titleWidth > width) {
            width = titleWidth;
        }
        this.table.getTableHeader().getColumnModel().getColumn(1).setPreferredWidth(width);
        this.table.getTableHeader().getColumnModel().getColumn(1).setMinWidth(width);
        this.table.getTableHeader().getColumnModel().getColumn(1).setMaxWidth((int)((double)width * 1.5));
        this.table.getTableHeader().getColumnModel().getColumn(1).setIdentifier("year");
        width = this.table.getFontMetrics(this.table.getFont()).stringWidth(" 10.0");
        titleWidth = this.table.getFontMetrics(this.table.getFont()).stringWidth(BUNDLE.getString("metatag.rating"));
        if (titleWidth > width) {
            width = titleWidth;
        }
        this.table.getTableHeader().getColumnModel().getColumn(2).setPreferredWidth((int)((double)width * 1.2));
        this.table.getTableHeader().getColumnModel().getColumn(2).setMinWidth((int)((double)width * 1.2));
        this.table.getTableHeader().getColumnModel().getColumn(2).setMaxWidth((int)((double)width * 1.5));
        this.table.getTableHeader().getColumnModel().getColumn(2).setIdentifier("rating");
        width = this.table.getFontMetrics(this.table.getFont()).stringWidth("01. Jan. 2000");
        titleWidth = this.table.getFontMetrics(this.table.getFont()).stringWidth(BUNDLE.getString("metatag.dateadded"));
        if (titleWidth > width) {
            width = titleWidth;
        }
        this.table.getTableHeader().getColumnModel().getColumn(3).setPreferredWidth((int)((double)width * 1.2));
        this.table.getTableHeader().getColumnModel().getColumn(3).setMinWidth((int)((double)width * 1.2));
        this.table.getTableHeader().getColumnModel().getColumn(3).setMaxWidth((int)((double)width * 1.2));
        this.table.getTableHeader().getColumnModel().getColumn(3).setIdentifier("dateadded");
        this.table.getTableHeader().getColumnModel().getColumn(4).setHeaderRenderer(new IconRenderer(BUNDLE.getString("tmm.nfo")));
        this.table.getTableHeader().getColumnModel().getColumn(4).setMaxWidth(20);
        this.table.getColumnModel().getColumn(4).setHeaderValue(IconManager.INFO);
        this.table.getTableHeader().getColumnModel().getColumn(4).setIdentifier("nfo");
        this.table.getTableHeader().getColumnModel().getColumn(5).setHeaderRenderer(new IconRenderer(BUNDLE.getString("tmm.metadata")));
        this.table.getTableHeader().getColumnModel().getColumn(5).setMaxWidth(20);
        this.table.getColumnModel().getColumn(5).setHeaderValue(IconManager.SEARCH);
        this.table.getTableHeader().getColumnModel().getColumn(5).setIdentifier("metadata");
        this.table.getTableHeader().getColumnModel().getColumn(6).setHeaderRenderer(new IconRenderer(BUNDLE.getString("tmm.images")));
        this.table.getTableHeader().getColumnModel().getColumn(6).setMaxWidth(20);
        this.table.getColumnModel().getColumn(6).setHeaderValue(IconManager.IMAGE);
        this.table.getTableHeader().getColumnModel().getColumn(6).setIdentifier("images");
        this.table.getTableHeader().getColumnModel().getColumn(7).setHeaderRenderer(new IconRenderer(BUNDLE.getString("tmm.trailer")));
        this.table.getTableHeader().getColumnModel().getColumn(7).setMaxWidth(20);
        this.table.getColumnModel().getColumn(7).setHeaderValue(IconManager.CLAPBOARD);
        this.table.getTableHeader().getColumnModel().getColumn(7).setIdentifier("trailer");
        this.table.getTableHeader().getColumnModel().getColumn(8).setHeaderRenderer(new IconRenderer(BUNDLE.getString("tmm.subtitles")));
        this.table.getTableHeader().getColumnModel().getColumn(8).setMaxWidth(20);
        this.table.getColumnModel().getColumn(8).setHeaderValue(IconManager.SUBTITLE);
        this.table.getTableHeader().getColumnModel().getColumn(8).setIdentifier("subtitle");
        this.table.getTableHeader().getColumnModel().getColumn(9).setHeaderRenderer(new IconRenderer(BUNDLE.getString("metatag.watched")));
        this.table.getTableHeader().getColumnModel().getColumn(9).setMaxWidth(20);
        this.table.getColumnModel().getColumn(9).setHeaderValue(IconManager.PLAY_SMALL);
        this.table.getTableHeader().getColumnModel().getColumn(9).setIdentifier("watched");
        this.table.setSelectionModel((ListSelectionModel)this.movieSelectionModel.getSelectionModel());
        if (this.movieList.getMovies() != null && this.movieList.getMovies().size() > 0 && (selectionModel = this.table.getSelectionModel()).isSelectionEmpty()) {
            selectionModel.setSelectionInterval(0, 0);
        }
        if (!MovieModuleManager.MOVIE_SETTINGS.isYearColumnVisible()) {
            this.table.hideColumn("year");
        }
        if (!MovieModuleManager.MOVIE_SETTINGS.isRatingColumnVisible()) {
            this.table.hideColumn("rating");
        }
        if (!MovieModuleManager.MOVIE_SETTINGS.isDateAddedColumnVisible()) {
            this.table.hideColumn("dateadded");
        }
        if (!MovieModuleManager.MOVIE_SETTINGS.isNfoColumnVisible()) {
            this.table.hideColumn("nfo");
        }
        if (!MovieModuleManager.MOVIE_SETTINGS.isMetadataColumnVisible()) {
            this.table.hideColumn("metadata");
        }
        if (!MovieModuleManager.MOVIE_SETTINGS.isImageColumnVisible()) {
            this.table.hideColumn("images");
        }
        if (!MovieModuleManager.MOVIE_SETTINGS.isTrailerColumnVisible()) {
            this.table.hideColumn("trailer");
        }
        if (!MovieModuleManager.MOVIE_SETTINGS.isSubtitleColumnVisible()) {
            this.table.hideColumn("subtitle");
        }
        if (!MovieModuleManager.MOVIE_SETTINGS.isWatchedColumnVisible()) {
            this.table.hideColumn("watched");
        }
        PropertyChangeListener settingsPropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getSource() instanceof MovieSettings) {
                    if ("yearColumnVisible".equals(evt.getPropertyName())) {
                        this.setColumnVisibility("year", (Boolean)evt.getNewValue());
                    }
                    if ("ratingColumnVisible".equals(evt.getPropertyName())) {
                        this.setColumnVisibility("rating", (Boolean)evt.getNewValue());
                    }
                    if ("nfoColumnVisible".equals(evt.getPropertyName())) {
                        this.setColumnVisibility("nfo", (Boolean)evt.getNewValue());
                    }
                    if ("metadataColumnVisible".equals(evt.getPropertyName())) {
                        this.setColumnVisibility("metadata", (Boolean)evt.getNewValue());
                    }
                    if ("dateAddedColumnVisible".equals(evt.getPropertyName())) {
                        this.setColumnVisibility("dateadded", (Boolean)evt.getNewValue());
                    }
                    if ("imageColumnVisible".equals(evt.getPropertyName())) {
                        this.setColumnVisibility("images", (Boolean)evt.getNewValue());
                    }
                    if ("trailerColumnVisible".equals(evt.getPropertyName())) {
                        this.setColumnVisibility("trailer", (Boolean)evt.getNewValue());
                    }
                    if ("subtitleColumnVisible".equals(evt.getPropertyName())) {
                        this.setColumnVisibility("subtitle", (Boolean)evt.getNewValue());
                    }
                    if ("watchedColumnVisible".equals(evt.getPropertyName())) {
                        this.setColumnVisibility("watched", (Boolean)evt.getNewValue());
                    }
                }
            }

            private void setColumnVisibility(Object identifier, Boolean visible) {
                if (visible.booleanValue()) {
                    MoviePanel.this.table.showColumn(identifier);
                } else {
                    MoviePanel.this.table.hideColumn(identifier);
                }
            }
        };
        MovieModuleManager.MOVIE_SETTINGS.addPropertyChangeListener(settingsPropertyChangeListener);
        this.lblMovieCountFiltered.setText(String.valueOf(this.movieTableModel.getRowCount()));
        this.addKeyListener();
    }

    public JSplitPane getSplitPaneHorizontal() {
        return this.splitPaneHorizontal;
    }

    public JSplitPane getSplitPaneVertical() {
        return this.panelRight.getSplitPaneVertical();
    }

    protected void initDataBindings() {
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"text");
        BeanProperty movieListBeanProperty = BeanProperty.create((String)"movieCount");
        AutoBinding autoBinding_20 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieList, (Property)movieListBeanProperty, (Object)this.lblMovieCountTotal, (Property)jLabelBeanProperty);
        autoBinding_20.bind();
    }

    private void addKeyListener() {
        this.table.addKeyListener(new KeyListener(){
            private long lastKeypress = 0L;
            private String searchTerm = "";

            @Override
            public void keyTyped(KeyEvent arg0) {
                long now = System.currentTimeMillis();
                if (now - this.lastKeypress > 500L) {
                    this.searchTerm = "";
                }
                this.lastKeypress = now;
                if (arg0.getKeyChar() != '\uffff') {
                    this.searchTerm = this.searchTerm + arg0.getKeyChar();
                }
                if (StringUtils.isNotBlank((CharSequence)this.searchTerm)) {
                    TableModel model = MoviePanel.this.table.getModel();
                    for (int i = 0; i < model.getRowCount(); ++i) {
                        String title;
                        if (!(model.getValueAt(i, 0) instanceof Movie) || !(title = ((Movie)model.getValueAt(i, 0)).getTitleSortable().toLowerCase(Locale.ROOT)).startsWith(this.searchTerm)) continue;
                        ListSelectionModel selectionModel = MoviePanel.this.table.getSelectionModel();
                        selectionModel.setSelectionInterval(i, i);
                        MoviePanel.this.table.scrollRectToVisible(new Rectangle(MoviePanel.this.table.getCellRect(i, 0, true)));
                        break;
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyPressed(KeyEvent arg0) {
            }
        });
    }
}

