/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies;

import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.LinkLabel;
import org.tinymediamanager.ui.components.UpnpPlayButton;
import org.tinymediamanager.ui.movies.MovieSelectionModel;

public class MovieDetailsPanel
extends JPanel {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final long serialVersionUID = 6273970118830324299L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieDetailsPanel.class);
    private MovieSelectionModel movieSelectionModel;
    private JLabel lblOriginalTitleT;
    private JLabel lblOriginalTitle;
    private JLabel lblProductionT;
    private JLabel lblProduction;
    private JLabel lblGenresT;
    private JLabel lblGenres;
    private JLabel lblCertificationT;
    private JLabel lblCertification;
    private JLabel lblImdbIdT;
    private JLabel lblTmdbIdT;
    private LinkLabel lblImdbId;
    private LinkLabel lblTmdbId;
    private JLabel lblRuntimeT;
    private JLabel lblRuntime;
    private JLabel lblMinutes;
    private JLabel lblTagsT;
    private JLabel lblTags;
    private JLabel lblMoviePathT;
    private LinkLabel lblMoviePath;
    private JLabel lblMoviesetT;
    private JLabel lblMovieSet;
    private JLabel lblSpokenLanguagesT;
    private JLabel lblSpokenLanguages;
    private JButton btnPlay;
    private JLabel lblCountryT;
    private JLabel lblCountry;
    private JLabel lblReleaseDateT;
    private JLabel lblReleaseDate;
    private JLabel lblEditionT;
    private JLabel lblEdition;

    public MovieDetailsPanel(MovieSelectionModel model) {
        this.movieSelectionModel = model;
        this.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.UNRELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, ColumnSpec.decode((String)"100px:grow"), FormSpecs.RELATED_GAP_COLSPEC, FormSpecs.DEFAULT_COLSPEC, FormSpecs.UNRELATED_GAP_COLSPEC, ColumnSpec.decode((String)"100px:grow"), FormSpecs.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"55px"), FormSpecs.RELATED_GAP_COLSPEC}, new RowSpec[]{FormSpecs.RELATED_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, new RowSpec(RowSpec.CENTER, Sizes.bounded((Size)Sizes.MINIMUM, (Size)Sizes.constant((String)"15px", (boolean)false), (Size)Sizes.constant((String)"50px", (boolean)false)), 0.0), FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC, FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, FormSpecs.DEFAULT_ROWSPEC}));
        this.lblOriginalTitleT = new JLabel(BUNDLE.getString("metatag.originaltitle"));
        this.add((Component)this.lblOriginalTitleT, "2, 2");
        this.lblOriginalTitle = new JLabel("");
        this.add((Component)this.lblOriginalTitle, "4, 2, 7, 1");
        this.btnPlay = new UpnpPlayButton(){

            @Override
            public MediaFile getMediaFile() {
                return MovieDetailsPanel.this.movieSelectionModel.getSelectedMovie().getFirstVideoFile();
            }

            @Override
            public MediaEntity getMediaEntity() {
                return MovieDetailsPanel.this.movieSelectionModel.getSelectedMovie();
            }
        };
        this.add((Component)this.btnPlay, "12, 2, 1, 5");
        this.lblGenresT = new JLabel(BUNDLE.getString("metatag.genre"));
        this.add((Component)this.lblGenresT, "2, 4");
        this.lblGenresT.setLabelFor(this.lblGenres);
        this.lblGenres = new JLabel("");
        this.add((Component)this.lblGenres, "4, 4, 7, 1");
        this.lblRuntimeT = new JLabel(BUNDLE.getString("metatag.runtime"));
        this.add((Component)this.lblRuntimeT, "2, 6");
        this.lblRuntimeT.setLabelFor(this.lblRuntime);
        this.lblRuntime = new JLabel("");
        this.add((Component)this.lblRuntime, "4, 6");
        this.lblMinutes = new JLabel(BUNDLE.getString("metatag.minutes"));
        this.add((Component)this.lblMinutes, "6, 6");
        this.lblReleaseDateT = new JLabel(BUNDLE.getString("metatag.releasedate"));
        this.add((Component)this.lblReleaseDateT, "8, 6");
        this.lblReleaseDate = new JLabel("");
        this.add((Component)this.lblReleaseDate, "10, 6");
        this.lblCertificationT = new JLabel(BUNDLE.getString("metatag.certification"));
        this.add((Component)this.lblCertificationT, "2, 8");
        this.lblCertificationT.setLabelFor(this.lblCertification);
        this.lblCertification = new JLabel("");
        this.add((Component)this.lblCertification, "4, 8, 7, 1");
        this.lblProductionT = new JLabel(BUNDLE.getString("metatag.production"));
        this.add((Component)this.lblProductionT, "2, 10, default, top");
        this.lblProductionT.setLabelFor(this.lblProduction);
        this.lblProduction = new JLabel();
        this.add((Component)this.lblProduction, "4, 10, 9, 1");
        this.lblSpokenLanguagesT = new JLabel(BUNDLE.getString("metatag.spokenlanguages"));
        this.add((Component)this.lblSpokenLanguagesT, "2, 12");
        this.lblSpokenLanguages = new JLabel("");
        this.add((Component)this.lblSpokenLanguages, "4, 12, 3, 1");
        this.lblCountryT = new JLabel(BUNDLE.getString("metatag.country"));
        this.add((Component)this.lblCountryT, "8, 12");
        this.lblCountry = new JLabel("");
        this.add((Component)this.lblCountry, "10, 12, 3, 1");
        this.lblMoviesetT = new JLabel(BUNDLE.getString("metatag.movieset"));
        this.add((Component)this.lblMoviesetT, "2, 14");
        this.lblMovieSet = new JLabel("");
        this.add((Component)this.lblMovieSet, "4, 14, 9, 1");
        this.lblTagsT = new JLabel(BUNDLE.getString("metatag.tags"));
        this.add((Component)this.lblTagsT, "2, 16");
        this.lblTags = new JLabel("");
        this.add((Component)this.lblTags, "4, 16, 9, 1");
        this.lblEditionT = new JLabel(BUNDLE.getString("metatag.edition"));
        this.add((Component)this.lblEditionT, "2, 18");
        this.lblEdition = new JLabel("");
        this.add((Component)this.lblEdition, "4, 18, 7, 1");
        this.lblImdbIdT = new JLabel(BUNDLE.getString("metatag.imdb"));
        this.add((Component)this.lblImdbIdT, "2, 20");
        this.lblImdbId = new LinkLabel("");
        this.lblImdbId.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String url = "http://www.imdb.com/title/" + MovieDetailsPanel.this.lblImdbId.getNormalText();
                try {
                    TmmUIHelper.browseUrl(url);
                }
                catch (Exception e) {
                    LOGGER.error("browse to imdbid", (Throwable)e);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)url, "message.erroropenurl", new String[]{":", e.getLocalizedMessage()}));
                }
            }
        });
        this.add((Component)this.lblImdbId, "4, 20, 3, 1, left, default");
        this.lblImdbIdT.setLabelFor(this.lblImdbId);
        this.lblTmdbIdT = new JLabel(BUNDLE.getString("metatag.tmdb"));
        this.add((Component)this.lblTmdbIdT, "8, 20");
        this.lblTmdbId = new LinkLabel("");
        this.lblTmdbId.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String url = "http://www.themoviedb.org/movie/" + MovieDetailsPanel.this.lblTmdbId.getNormalText();
                try {
                    TmmUIHelper.browseUrl(url);
                }
                catch (Exception e) {
                    LOGGER.error("browse to tmdbid", (Throwable)e);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)url, "message.erroropenurl", new String[]{":", e.getLocalizedMessage()}));
                }
            }
        });
        this.add((Component)this.lblTmdbId, "10, 20, 3, 1, left, default");
        this.lblTmdbIdT.setLabelFor(this.lblTmdbId);
        this.lblMoviePathT = new JLabel(BUNDLE.getString("metatag.path"));
        this.add((Component)this.lblMoviePathT, "2, 22");
        this.lblMoviePath = new LinkLabel("");
        this.lblMoviePath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!StringUtils.isEmpty((CharSequence)MovieDetailsPanel.this.lblMoviePath.getNormalText())) {
                    Path path = Paths.get(MovieDetailsPanel.this.lblMoviePath.getNormalText(), new String[0]);
                    try {
                        if (Files.exists(path, new LinkOption[0])) {
                            TmmUIHelper.openFile(path);
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.error("open filemanager", (Throwable)ex);
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)path, "message.erroropenfolder", new String[]{":", ex.getLocalizedMessage()}));
                    }
                }
            }
        });
        this.lblMoviePathT.setLabelFor(this.lblMoviePath);
        this.lblMoviePathT.setLabelFor(this.lblMoviePath);
        this.add((Component)this.lblMoviePath, "4, 22, 9, 1");
        this.initDataBindings();
    }

    protected void initDataBindings() {
        BeanProperty movieSelectionModelBeanProperty_6 = BeanProperty.create((String)"selectedMovie.originalTitle");
        BeanProperty jLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_7 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_6, (Object)this.lblOriginalTitle, (Property)jLabelBeanProperty);
        autoBinding_7.bind();
        BeanProperty movieSelectionModelBeanProperty_7 = BeanProperty.create((String)"selectedMovie.genresAsString");
        AutoBinding autoBinding_8 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_7, (Object)this.lblGenres, (Property)jLabelBeanProperty);
        autoBinding_8.bind();
        BeanProperty movieSelectionModelBeanProperty_8 = BeanProperty.create((String)"selectedMovie.runtime");
        AutoBinding autoBinding_9 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_8, (Object)this.lblRuntime, (Property)jLabelBeanProperty);
        autoBinding_9.bind();
        BeanProperty movieSelectionModelBeanProperty_11 = BeanProperty.create((String)"selectedMovie.imdbId");
        BeanProperty linkLabelBeanProperty = BeanProperty.create((String)"text");
        AutoBinding autoBinding_12 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_11, (Object)this.lblImdbId, (Property)linkLabelBeanProperty);
        autoBinding_12.bind();
        BeanProperty movieSelectionModelBeanProperty_12 = BeanProperty.create((String)"selectedMovie.tmdbId");
        AutoBinding autoBinding_13 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_12, (Object)this.lblTmdbId, (Property)linkLabelBeanProperty);
        autoBinding_13.bind();
        BeanProperty movieSelectionModelBeanProperty_9 = BeanProperty.create((String)"selectedMovie.certification.name");
        AutoBinding autoBinding_10 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_9, (Object)this.lblCertification, (Property)jLabelBeanProperty);
        autoBinding_10.bind();
        BeanProperty movieSelectionModelBeanProperty_4 = BeanProperty.create((String)"selectedMovie.tagsAsString");
        AutoBinding autoBinding_4 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_4, (Object)this.lblTags, (Property)jLabelBeanProperty);
        autoBinding_4.bind();
        BeanProperty movieSelectionModelBeanProperty_5 = BeanProperty.create((String)"selectedMovie.productionCompany");
        AutoBinding autoBinding_5 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_5, (Object)this.lblProduction, (Property)jLabelBeanProperty);
        autoBinding_5.bind();
        BeanProperty movieSelectionModelBeanProperty = BeanProperty.create((String)"selectedMovie.path");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty, (Object)this.lblMoviePath, (Property)linkLabelBeanProperty);
        autoBinding.bind();
        BeanProperty movieSelectionModelBeanProperty_1 = BeanProperty.create((String)"selectedMovie.movieSetTitle");
        AutoBinding autoBinding_1 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_1, (Object)this.lblMovieSet, (Property)jLabelBeanProperty);
        autoBinding_1.bind();
        BeanProperty movieSelectionModelBeanProperty_2 = BeanProperty.create((String)"selectedMovie.spokenLanguages");
        AutoBinding autoBinding_2 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_2, (Object)this.lblSpokenLanguages, (Property)jLabelBeanProperty);
        autoBinding_2.bind();
        BeanProperty movieSelectionModelBeanProperty_3 = BeanProperty.create((String)"selectedMovie.country");
        AutoBinding autoBinding_3 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_3, (Object)this.lblCountry, (Property)jLabelBeanProperty);
        autoBinding_3.bind();
        BeanProperty movieSelectionModelBeanProperty_10 = BeanProperty.create((String)"selectedMovie.releaseDateAsString");
        AutoBinding autoBinding_6 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_10, (Object)this.lblReleaseDate, (Property)jLabelBeanProperty);
        autoBinding_6.bind();
        BeanProperty movieSelectionModelBeanProperty_13 = BeanProperty.create((String)"selectedMovie.editionAsString");
        AutoBinding autoBinding_11 = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, (Object)this.movieSelectionModel, (Property)movieSelectionModelBeanProperty_13, (Object)this.lblEdition, (Property)jLabelBeanProperty);
        autoBinding_11.bind();
    }
}

